/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.ColorThemingTreeRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendEntrySvgListCellRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.AbstractLegendEntryLayerableIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryLayerThemeIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.AbstractLegendEntryLayerableModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryHeaderModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryLayerModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryLayerThemeModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryLayerableModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class LegendEntryListCellRenderer
implements ListCellRenderer {
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final Task task;
    private final WithScale withScale;
    private final StringBuilder sbLayerName = new StringBuilder();
    private final LayerNameRenderer layerNameRenderer = new LayerNameRenderer();
    private final ColorThemingTreeRenderer colorThemingRenderer = new ColorThemingTreeRenderer();
    private final LegendEntrySvgListCellRenderer legendEntrySvgListCellRenderer = new LegendEntrySvgListCellRenderer();

    public LegendEntryListCellRenderer(Task task, WithScale withScale) {
        this.task = task;
        if (withScale == null) {
            withScale = task;
        }
        this.withScale = withScale;
        this.layerNameRenderer.setWithScale(withScale);
        this.colorThemingRenderer.setWithScale(withScale);
        this.legendEntrySvgListCellRenderer.setWithScale(withScale);
    }

    private Component getListCellRenderComponentNotFound(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel lblNotFound = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value.toString(), index, isSelected, cellHasFocus);
        lblNotFound.setFont(lblNotFound.getFont().deriveFont(2));
        lblNotFound.setForeground(Color.DARK_GRAY);
        lblNotFound.setToolTipText(I18N.get("ui.plugin.print.legend.LegendListCellRenderer.element-not-found"));
        return lblNotFound;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof LegendEntryHeaderModel) {
            JLabel lblHeader = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            lblHeader.setFont(lblHeader.getFont().deriveFont(1));
            LegendEntryHeaderModel legHeader = (LegendEntryHeaderModel)((Object)value);
            if (legHeader.getLevel() == 1) {
                lblHeader.setFont(lblHeader.getFont().deriveFont(lblHeader.getFont().getSize2D() + 1.0f));
            }
            return lblHeader;
        }
        if (value instanceof LegendEntryLayerModel && ((AbstractLegendEntryLayerableModel)((Object)value)).getSvgData() != null) {
            AbstractLegendEntryLayerableModel legLayerable = (AbstractLegendEntryLayerableModel)((Object)value);
            AbstractLegendEntryLayerableIntelligence legLayerableIntelligence = (AbstractLegendEntryLayerableIntelligence)legLayerable.getIntelligence();
            AbstractLayerable ly = legLayerableIntelligence.retrieveLayerableModel(this.task, this.withScale.getScale());
            if (ly == null) {
                return this.getListCellRenderComponentNotFound(list, value.toString(), index, isSelected, cellHasFocus);
            }
            this.legendEntrySvgListCellRenderer.setLayerable(ly);
            return this.legendEntrySvgListCellRenderer.getListCellRendererComponent(list, legLayerableIntelligence, index, isSelected, cellHasFocus);
        }
        if (value instanceof LegendEntryLayerThemeModel) {
            LegendEntryLayerThemeModel legLayerTheme = (LegendEntryLayerThemeModel)((Object)value);
            LegendEntryLayerThemeIntelligence legLayerThemeIntelligence = (LegendEntryLayerThemeIntelligence)legLayerTheme.getIntelligence();
            Layer ly = (Layer)legLayerThemeIntelligence.retrieveLayerableModel(this.task, this.withScale.getScale());
            if (ly == null) {
                return this.getListCellRenderComponentNotFound(list, value.toString(), index, isSelected, cellHasFocus);
            }
            BasicStyleModel style = legLayerThemeIntelligence.retrieveStyleModel(this.task, this.withScale.getScale());
            ColorThemingValue cv = new ColorThemingValue(legLayerTheme.getThemeId(), ly, style, legLayerTheme.getName());
            return this.colorThemingRenderer.getListCellRendererComponent((JList<? extends ColorThemingValue>)list, cv, index, isSelected, cellHasFocus);
        }
        if (value instanceof LegendEntryLayerModel) {
            LegendEntryLayerModel legLayer = (LegendEntryLayerModel)((Object)value);
            Layerable ly = (Layerable)((LegendEntryIntelligence)legLayer.getIntelligence()).retrieveLayerableModel(this.task, this.withScale.getScale());
            if (ly == null) {
                return this.getListCellRenderComponentNotFound(list, value.toString(), index, isSelected, cellHasFocus);
            }
            this.sbLayerName.delete(0, this.sbLayerName.length());
            this.sbLayerName.append(legLayer.getName());
            return this.layerNameRenderer.getListCellRendererComponent((JList<? extends Layerable>)list, ly, index, isSelected, cellHasFocus);
        }
        if (value instanceof LegendEntryLayerableModel) {
            AbstractLegendEntryLayerableModel legLayerable = (AbstractLegendEntryLayerableModel)((Object)value);
            AbstractLegendEntryLayerableIntelligence legLayerableIntelligence = (AbstractLegendEntryLayerableIntelligence)legLayerable.getIntelligence();
            AbstractLayerable ly = legLayerableIntelligence.retrieveLayerableModel(this.task, this.withScale.getScale());
            if (ly == null) {
                return this.getListCellRenderComponentNotFound(list, value.toString(), index, isSelected, cellHasFocus);
            }
            legLayerableIntelligence.setRenderScale(this.withScale.getScale());
            legLayerableIntelligence.setRenderTask(this.task);
            this.legendEntrySvgListCellRenderer.setLayerable(ly);
            return this.legendEntrySvgListCellRenderer.getListCellRendererComponent(list, legLayerableIntelligence, index, isSelected, cellHasFocus);
        }
        return this.getListCellRenderComponentNotFound(list, value.toString(), index, isSelected, cellHasFocus);
    }
}

