/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendSvgSymbolStore;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.AbstractLegendEntryLayerableModel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditLayerableEntryDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(EditLayerableEntryDialog.class);
    private boolean okPressed = false;
    private byte[] svgData;
    private BufferedImage prevImage = new BufferedImage(200, 100, 2);
    private JButton butCancel;
    private JButton butOK;
    private JButton butSVG;
    private JButton butSVGDelete;
    private JButton jButton3;
    private JLabel lblName;
    private JLabel lblSVG;
    private JLabel lblSVGPreview;
    private JPanel pnlButton;
    private JPanel pnlSVG;
    private JToolBar tbaSVG;
    private JTextField txtName;

    public EditLayerableEntryDialog(Dialog parent, AbstractLegendEntryLayerableModel legModel) {
        super(parent, true);
        this.initComponents();
        this.i18n();
        this.txtName.setText(legModel.getName());
        this.svgData = legModel.getSvgData();
        this.setSize(300, 220);
        this.updatePreview();
        SwingUtilities.getRootPane(this.butOK).setDefaultButton(this.butOK);
        this.txtName.requestFocusInWindow();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.print.legend.EditLayerableEntryDialog.title"));
        this.lblName.setText(I18N.get("ui.plugin.print.legend.EditLayerableEntryDialog.name"));
        this.lblSVG.setText(I18N.get("ui.plugin.print.legend.EditLayerableEntryDialog.svg-label"));
        this.lblSVG.setToolTipText(I18N.get("ui.plugin.print.legend.EditLayerableEntryDialog.svg-label-tooltip"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOK.setText(I18N.get("common.ok"));
        this.butSVG.setText("");
        this.butSVG.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butSVG.setMargin(new Insets(0, 0, 0, 0));
        this.butSVG.setToolTipText(I18N.get("ui.plugin.print.legend.EditLayerableEntryDialog.svg-choose-tooltip"));
        this.butSVGDelete.setText("");
        this.butSVGDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butSVGDelete.setMargin(new Insets(0, 0, 0, 0));
        this.butSVGDelete.setToolTipText(I18N.get("ui.plugin.print.legend.EditLayerableEntryDialog.svg-delete-tooltip"));
        Dimension svgPreviewDim = new Dimension(120, 70);
        this.pnlSVG.setMinimumSize(svgPreviewDim);
        this.pnlSVG.setPreferredSize(svgPreviewDim);
    }

    private void updatePreview() {
        this.prevImage = new BufferedImage(100, 50, 2);
        if (this.svgData != null) {
            Graphics2D g2d = (Graphics2D)this.prevImage.getGraphics();
            LegendSvgSymbolStore symStore = new LegendSvgSymbolStore(this.svgData);
            try {
                symStore.renderLegendSymbol(g2d, 50, 25, 100, 50);
            }
            catch (Exception e) {
                LOG.error("Legend Symbol can not be rendered.", (Throwable)e);
                ErrorBox.showException((Window)this, (String)I18N.get("common.error"), (Throwable)e);
                this.svgData = null;
            }
            this.lblSVGPreview.setText("");
            this.lblSVGPreview.setIcon(new ImageIcon(this.prevImage));
        } else {
            this.lblSVGPreview.setIcon(null);
            this.lblSVGPreview.setText("----");
        }
    }

    public boolean wasOkPressed() {
        return this.okPressed;
    }

    public String getLegendName() {
        return this.txtName.getText();
    }

    public byte[] getLegendSvgData() {
        return this.svgData;
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblSVG = new JLabel();
        this.pnlButton = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.pnlSVG = new JPanel();
        this.lblSVGPreview = new JLabel();
        this.tbaSVG = new JToolBar();
        this.butSVG = new JButton();
        this.butSVGDelete = new JButton();
        this.jButton3.setText("jButton3");
        this.setDefaultCloseOperation(2);
        this.setTitle("Eintrag \u00e4ndern");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblName.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.txtName, gridBagConstraints);
        this.lblSVG.setText("SVG - Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblSVG, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerableEntryDialog.this.butOKActionPerformed(evt);
            }
        });
        this.pnlButton.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerableEntryDialog.this.butCancelActionPerformed(evt);
            }
        });
        this.pnlButton.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlButton, gridBagConstraints);
        this.pnlSVG.setBackground(new Color(255, 255, 255));
        this.pnlSVG.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnlSVG.add(this.lblSVGPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlSVG, gridBagConstraints);
        this.tbaSVG.setRollover(true);
        this.butSVG.setText("w\u00e4hlen...");
        this.butSVG.setFocusable(false);
        this.butSVG.setHorizontalTextPosition(0);
        this.butSVG.setVerticalTextPosition(3);
        this.butSVG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerableEntryDialog.this.butSVGActionPerformed(evt);
            }
        });
        this.tbaSVG.add(this.butSVG);
        this.butSVGDelete.setText("SVG l\u00f6schen");
        this.butSVGDelete.setFocusable(false);
        this.butSVGDelete.setHorizontalTextPosition(0);
        this.butSVGDelete.setVerticalTextPosition(3);
        this.butSVGDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditLayerableEntryDialog.this.butSVGDeleteActionPerformed(evt);
            }
        });
        this.tbaSVG.add(this.butSVGDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.tbaSVG, gridBagConstraints);
        this.pack();
    }

    private void butOKActionPerformed(ActionEvent evt) {
        this.okPressed = true;
        this.setVisible(false);
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.okPressed = false;
        this.setVisible(false);
    }

    private void butSVGDeleteActionPerformed(ActionEvent evt) {
        this.svgData = null;
        this.updatePreview();
    }

    private void butSVGActionPerformed(ActionEvent evt) {
        JFileChooser fChooser = GUISupport.createJFileChooser();
        fChooser.setFileFilter(GUISupport.createFileFilter((String)"SVG-File", (String[])new String[]{"svg"}));
        int retval = fChooser.showOpenDialog(this);
        if (retval == 1) {
            return;
        }
        File svgFile = fChooser.getSelectedFile();
        try {
            this.svgData = FileUtils.readFileToByteArray((File)svgFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Should never reach here", e);
        }
        this.updatePreview();
    }
}

