/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraftUtils;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintRendererUtils;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.geom.Dimension2DDouble;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;

@FunctionalInterface
public interface ScaleDetector {
    public static ScaleDetector buildMultiScaleDetector(Collection<Integer> allowedScales) {
        final ArrayList<Integer> scales = new ArrayList<Integer>(allowedScales);
        return new ScaleDetector(){

            @Override
            public Integer determineScale(Dimension2D imageDimPx, double orientation, Envelope env, DrawingUnit drawingUnit) {
                Dimension2DDouble dEnv = new Dimension2DDouble(env.getWidth(), env.getHeight());
                Dimension2D dEnvRotated = PrintRendererUtils.calculateRotatedImageDimension((Dimension2D)dEnv, orientation);
                Envelope newEnv = new Envelope(env.centre());
                newEnv.expandBy(dEnvRotated.getWidth() / 2.0, dEnvRotated.getHeight() / 2.0);
                return PrintDraftUtils.findMatchingScale(imageDimPx, env, drawingUnit, scales);
            }
        };
    }

    public static ScaleDetector buildSingleScaleDetector(final Number requestedScale) {
        return new ScaleDetector(){

            @Override
            public Integer determineScale(Dimension2D imageDimPx, double orientation, Envelope env, DrawingUnit drawingUnit) {
                return requestedScale.intValue();
            }
        };
    }

    public static ScaleDetector buildSimpleScaleDetector() {
        return new ScaleDetector(){

            @Override
            public Integer determineScale(Dimension2D imageDimPx, double orientation, Envelope env, DrawingUnit drawingUnit) {
                Dimension2DDouble x = new Dimension2DDouble(PrintDraftUtils.ptToUnit(imageDimPx.getWidth(), drawingUnit), PrintDraftUtils.ptToUnit(imageDimPx.getHeight(), drawingUnit));
                Dimension2DDouble dEnv = new Dimension2DDouble(env.getWidth(), env.getHeight());
                Dimension2D dEnvRotated = PrintRendererUtils.calculateRotatedImageDimension((Dimension2D)dEnv, orientation);
                Envelope newEnv = new Envelope(env.centre());
                newEnv.expandBy(dEnvRotated.getWidth() / 2.0, dEnvRotated.getHeight() / 2.0);
                return (int)Math.ceil(Math.max(newEnv.getWidth() / x.getWidth(), newEnv.getHeight() / x.getHeight()));
            }
        };
    }

    public Integer determineScale(Dimension2D var1, double var2, Envelope var4, DrawingUnit var5);
}

