/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.workbench.model.Layerable;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyStorage<M, N> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyStorage.class);
    private final Map<M, N> store = new LinkedHashMap<M, N>();
    public static final Resetter<VectorLayerContext, String> RESET_LAYERFILTER = new Resetter<VectorLayerContext, String>(){

        @Override
        public void reset(VectorLayerContext resObject, String resValue) throws Exception {
            resObject.setFilter(resValue);
        }
    };
    public static final Resetter<LayerContext, Boolean> RESET_LAYERCONTEXTVISIBILITY = new Resetter<LayerContext, Boolean>(){

        @Override
        public void reset(LayerContext resObject, Boolean resValue) {
            resObject.setVisible(resValue.booleanValue());
        }
    };
    public static final Resetter<Layerable, Boolean> RESET_LAYERVISIBILITY = new Resetter<Layerable, Boolean>(){

        @Override
        public void reset(Layerable resObject, Boolean resValue) {
            resObject.setVisible(resValue);
        }
    };

    public final void clear() {
        this.store.clear();
    }

    public final boolean storeValue(M key, N value) {
        if (key != null && !this.store.containsKey(key)) {
            this.store.put(key, value);
            return true;
        }
        return false;
    }

    public void resetValues(Resetter<M, N> resetter) {
        for (Map.Entry<M, N> currEntry : this.store.entrySet()) {
            M resObject = currEntry.getKey();
            N resValue = currEntry.getValue();
            try {
                if (resObject == null) continue;
                LOG.debug(String.format("resetting '%s' to '%s'", resObject, resValue));
                resetter.reset(resObject, resValue);
            }
            catch (Exception ex) {
                LOG.warn(String.format("unable resetting '%s' to '%s': %s", resObject, resValue, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static interface Resetter<M, N> {
        public void reset(M var1, N var2) throws Exception;
    }
}

