/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.task.PrintLayerView;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.print.EmptyJRRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.JasperReportSupport;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.ScaleDetector;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendModel;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.type.PdfPrintScalingEnum;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(PrintThread.class);
    private final WorkbenchContext context;
    private final double scale;
    private final int orientation;
    private final PrintDraft printDraft;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final LayerView layerView;
    private final Envelope env = new Envelope(0.0, 0.0, 0.0, 0.0);
    private final List<ActionListener> lstListeners = new ArrayList<ActionListener>();
    private File printDir = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.JUMP), "print");
    private float printQuality = 1.5f;
    private boolean bolReady = false;
    private String strMessage = "";
    private boolean bolInterrupted = false;
    private final List<ActionListener> lstMessageListeners = new ArrayList<ActionListener>();
    private JRDataSource datasource;
    private File pdfFile = new File(this.printDir, String.format("print_%d.pdf", System.currentTimeMillis()));
    private boolean showAfterPrint = true;
    private LegendModel legend = null;

    public JRDataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(JRDataSource datasource) {
        this.datasource = datasource;
    }

    public PrintThread(double _scale, int _orientation, Envelope _env, PrintDraft _printDraft, Map<String, Object> _parameters, WorkbenchContext _context) {
        this.context = _context;
        this.scale = _scale;
        this.orientation = _orientation;
        this.printDraft = _printDraft;
        if (_parameters != null) {
            this.parameters.putAll(_parameters);
        }
        if (_env != null) {
            this.env.init(_env);
        }
        LOG.info(String.format("Printing '%s' with scale %f (envelope: %s)", _printDraft, this.scale, this.env));
        this.layerView = this.context != null ? new PrintLayerView(this.context.getLayerManager()) : null;
        this.setName("PrintThread");
        if (!this.printDir.exists()) {
            this.printDir.mkdirs();
        }
    }

    public static final File saveNorthArrowToFile(double _orientationDegrees) throws IOException {
        File f = File.createTempFile("northarrow", ".gif");
        PrintThread.saveRotatedImageToGIFFile(PrintThread.class.getResource("northarrow.gif"), f, _orientationDegrees);
        return f;
    }

    public static void saveRotatedImageToGIFFile(URL _imageLocation, File _outFile, double _orientationDegrees) throws IOException {
        BufferedImage imgNorthArrowOri = null;
        try {
            imgNorthArrowOri = ImageIO.read(_imageLocation);
        }
        catch (Exception e) {
            LOG.warn(String.format("Error loading image '%s'", _imageLocation), (Throwable)e);
        }
        AffineTransform txN = new AffineTransform();
        txN.rotate(Math.toRadians(_orientationDegrees), imgNorthArrowOri.getWidth() / 2, imgNorthArrowOri.getHeight() / 2);
        AffineTransformOp opN = new AffineTransformOp(txN, 2);
        BufferedImage imgNorthArrow = new BufferedImage(imgNorthArrowOri.getWidth(), imgNorthArrowOri.getHeight(), 2);
        Graphics2D g = (Graphics2D)imgNorthArrow.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, imgNorthArrow.getWidth(), imgNorthArrow.getHeight());
        imgNorthArrow = opN.filter(imgNorthArrowOri, imgNorthArrow);
        PrintThread.saveImage(imgNorthArrow, "gif", _outFile);
    }

    public void setPrintQuality(float _printQuality) {
        this.printQuality = _printQuality;
    }

    public void setPrintFileName(String _printFileName) {
        this.setPrintFile(new File(this.printDir, _printFileName));
    }

    public void setPrintDir(File _printDir) {
        this.printDir = _printDir;
    }

    public void addListener(ActionListener listener) {
        this.lstListeners.add(listener);
    }

    private void clearTempPrintDir() {
        try {
            if (this.printDir.isDirectory()) {
                for (File arrFile : this.printDir.listFiles()) {
                    try {
                        arrFile.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
        }
    }

    public void setMessage(String _strMessage) {
        this.strMessage = _strMessage;
        for (ActionListener listener : this.lstMessageListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, this.strMessage));
        }
    }

    public void addMessageListener(ActionListener listener) {
        this.lstMessageListeners.add(listener);
    }

    public String getMessage() {
        return this.strMessage;
    }

    public void setLegend(List<LegendModel> legends) {
        this.legend = new LegendModel("legend4Print");
        ArrayList<LegendEntryModel> legEntries = new ArrayList<LegendEntryModel>();
        for (LegendModel leg : legends) {
            legEntries.addAll(leg.getEntries());
        }
        this.legend.setEntries(legEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.pdfFile == null) {
            this.setPrintFile(new File(this.printDir, String.format("print_%d.pdf", System.currentTimeMillis())));
        }
        if (this.context != null) {
            this.context.getLayerManager().getBlackboard().put("print_envelope", new Envelope(this.env));
        }
        try {
            this.clearTempPrintDir();
            if (this.isInterrupted()) {
                return;
            }
            File northArrowFile = PrintThread.saveNorthArrowToFile(this.orientation);
            Object renderer = this.layerView != null ? new PrintRenderer(this.layerView, this.env, this.printDraft, this.orientation, this.printQuality, this, ScaleDetector.buildSingleScaleDetector(this.scale)) : EmptyJRRenderer.EMPTY_RENDERER;
            Object legendRenderer = this.layerView != null && this.legend != null ? new LegendRenderer(this.layerView, this.printDraft, this.legend, this.scale) : EmptyJRRenderer.EMPTY_RENDERER;
            this.parameters.put("MAP_IMAGE", renderer);
            this.parameters.put("MAP_SHOW_LEGEND", legendRenderer != EmptyJRRenderer.EMPTY_RENDERER);
            this.parameters.put("MAP_LEGEND", legendRenderer);
            this.parameters.put("MAP_NORTH_IMAGE", northArrowFile.getAbsolutePath());
            this.parameters.put("MAP_SCALE", Integer.toString((int)this.scale));
            ArrayList<File> reportSourceDirs = new ArrayList<File>();
            reportSourceDirs.add(this.printDir);
            if (this.printDraft.getOriginalReportFile() != null && this.printDraft.getOriginalReportFile().isFile()) {
                reportSourceDirs.add(this.printDraft.getOriginalReportFile().getParentFile());
            }
            JasperReport jasperReport = this.printDraft.getReport();
            try {
                Object currDataSource = this.datasource == null ? new JREmptyDataSource(1) : this.datasource;
                LocalJasperReportsContext jrcontext = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
                jrcontext.setClassLoader(this.getClass().getClassLoader());
                jrcontext.setFileResolver(JasperReportSupport.buildJRFileResolver(reportSourceDirs));
                JasperPrint jasperPrint = JasperFillManager.getInstance((JasperReportsContext)jrcontext).fill(jasperReport, this.parameters, currDataSource);
                JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)jrcontext);
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                File pdfTmpFile = File.createTempFile("printThread_", ".tmp.pdf");
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(pdfTmpFile));
                SimplePdfExporterConfiguration config = new SimplePdfExporterConfiguration();
                config.setPdfVersion(PdfVersionEnum.VERSION_1_7);
                config.setCompressed(Boolean.TRUE);
                config.setPrintScaling(PdfPrintScalingEnum.NONE);
                exporter.setConfiguration((ExporterConfiguration)config);
                exporter.exportReport();
                FileUtils.moveFile((File)pdfTmpFile, (File)this.pdfFile);
                FileUtils.deleteQuietly((File)northArrowFile);
                LOG.info(String.format("PDF-file saved: '%s'", this.pdfFile));
            }
            catch (Exception e) {
                ErrorBox.showException((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.error"), (String)I18N.get("ui.plugin.print.PrintThread.error"), (Throwable)e);
                if (this.context != null) {
                    this.context.getLayerManager().getBlackboard().remove("print_envelope");
                    WorkbenchContext.getInstance().getLayerViewPanel().repaint();
                    this.layerView.dispose();
                }
                for (ActionListener listener : this.lstListeners) {
                    listener.actionPerformed(new ActionEvent(this, 0, "ready"));
                }
                return;
            }
            if (this.isInterrupted()) {
                return;
            }
            System.gc();
            if (this.showAfterPrint) {
                PrintThread.showPrintedFile(this.pdfFile);
            }
            if (this.context != null) {
                this.context.getLayerManager().getBlackboard().remove("print_envelope");
                WorkbenchContext.getInstance().getLayerViewPanel().repaint();
                this.layerView.dispose();
            }
        }
        catch (Exception ex) {
            JUMPWorkbench.getFrame().handleThrowable(ex);
        }
        finally {
            if (this.context != null) {
                this.context.getLayerManager().getBlackboard().remove("print_envelope");
                WorkbenchContext.getInstance().getLayerViewPanel().repaint();
                this.layerView.dispose();
            }
            for (ActionListener listener : this.lstListeners) {
                listener.actionPerformed(new ActionEvent(this, 0, "ready"));
            }
        }
        for (ActionListener listener : this.lstListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "ready"));
        }
        this.bolReady = true;
    }

    private static final void showPrintedFile(final File pdfFile) {
        final String strPdfExe = PersistentBlackboardPlugIn.get().get("ExtProgramm - PDF", "");
        Runnable runner = StringUtils.isBlank((CharSequence)strPdfExe) ? new Runnable(){

            @Override
            public void run() {
                OSFile.showFile((File)pdfFile, (boolean)true);
            }
        } : new Runnable(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(String.format("\"%s\" \"%s\"", strPdfExe, pdfFile.getAbsolutePath()));
                }
                catch (Exception e) {
                    LOG.error("Error showing PDF file", (Throwable)e);
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)"Error showing PDF file.", (String)"Error");
                }
            }
        };
        Thread thOpenFile = new Thread(runner, "OpenPrinFile");
        thOpenFile.start();
    }

    @Override
    public void interrupt() {
        this.bolInterrupted = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.bolInterrupted;
    }

    public boolean isReady() {
        return this.bolReady;
    }

    public static void saveImage(RenderedImage image, String format, File file) throws IOException {
        boolean writerFound = ImageIO.write(image, format, file);
        Assert.isTrue((boolean)writerFound, (String)"invalid format");
    }

    public void setPrintFile(File _printFile) {
        this.pdfFile = _printFile;
    }

    public void setShowAfterPrint(boolean _showAfterPrint) {
        this.showAfterPrint = _showAfterPrint;
    }
}

