/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.task.PrintLayerView;
import com.vividsolutions.jump.util.ImageUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintAreaTile;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraftUtils;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintRendererUtils;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintThread;
import com.vividsolutions.jump.workbench.ui.plugin.print.PropertyStorage;
import com.vividsolutions.jump.workbench.ui.plugin.print.ScaleDetector;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityProfile;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.renderinterface.parameters.PrintAreaDefinition;
import de.riwagis.renderinterface.parameters.PrintAreaDefinitionLayerFilter;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.geom.Dimension2DDouble;
import de.riwagis.util.image.ImageSupport;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.renderers.AbstractRenderToImageDataRenderer;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRenderer
extends AbstractRenderToImageDataRenderer
implements JRRenderable {
    private static final Logger LOG = LoggerFactory.getLogger(PrintRenderer.class);
    private static final double OVERSIZE_FACTOR = 5.0;
    public static final int DEFAULT_MAXPIXEL = 1000;
    private final String strId;
    private final double orientation;
    private final LayerView lv;
    private final Envelope env;
    private final double printQuality;
    private final int maxPixel;
    private final PrintThread pThread;
    private boolean exceptionOnError = false;
    private final Dimension2D scaleBarMargins;
    private final ScaleDetector scaleDetector;
    private PrintAreaDefinition defRead;

    @Deprecated
    public PrintRenderer(LayerView _lv, Envelope _env, PrintDraft _printDraft, int _orientation, float _printQuality, PrintThread _pThread, ScaleDetector scaleDetector) {
        this(_lv, _env, _printDraft, _orientation, _printQuality, _pThread, 1000, scaleDetector);
    }

    @Deprecated
    public PrintRenderer(LayerView _lv, Envelope _env, PrintDraft _printDraft, int _orientation, float _printQuality, PrintThread _pThread, int maxPixel, ScaleDetector scaleDetector) {
        this(_lv, _env, _printDraft.getScaleBarMargins(), _orientation, (double)_printQuality, _pThread, maxPixel, scaleDetector);
    }

    public PrintRenderer(LayerView _lv, Envelope _env, Dimension2D scaleBarMargins, int _orientation, double _printQuality, PrintThread _pThread, ScaleDetector scaleDetector) {
        this(_lv, _env, scaleBarMargins, _orientation, _printQuality, _pThread, 1000, scaleDetector);
    }

    public PrintRenderer(LayerView _lv, Envelope _env, Dimension2D scaleBarMargins, int _orientation, double _printQuality, PrintThread _pThread, int maxPixel, ScaleDetector scaleDetector) {
        this.scaleBarMargins = scaleBarMargins;
        this.env = _env;
        this.orientation = _orientation;
        this.printQuality = _printQuality;
        this.lv = _lv;
        this.pThread = _pThread;
        this.maxPixel = maxPixel;
        this.strId = PrintRenderer.buildID();
        this.scaleDetector = scaleDetector;
    }

    public PrintRenderer(LayerView _lv, Envelope env, Dimension2D scaleBarMargins, int _orientation, float _printQuality, PrintThread _pThread, int maxPixel, PrintAreaDefinition defRead) {
        this(_lv, env, scaleBarMargins, _orientation, (double)_printQuality, _pThread, ScaleDetector.buildMultiScaleDetector(defRead.getScales()));
        this.defRead = defRead;
    }

    public static String buildID() {
        return System.currentTimeMillis() + "-" + Math.random();
    }

    public static AffineTransform buildLayerTransform(double oversizeFactor, double orientation, Dimension2D imageDimPx, Dimension2D imageDimPxRotated) {
        Point2D.Double imageCenter = new Point2D.Double((imageDimPxRotated.getWidth() - imageDimPx.getWidth()) / 2.0, (imageDimPxRotated.getHeight() - imageDimPx.getHeight()) / 2.0);
        AffineTransform trans = new AffineTransform();
        if (orientation != 0.0) {
            trans.translate(-((Point2D)imageCenter).getX(), -((Point2D)imageCenter).getY());
            trans.rotate(Math.toRadians(orientation), imageDimPxRotated.getWidth() / 2.0, imageDimPxRotated.getHeight() / 2.0);
        }
        trans.scale(1.0 / oversizeFactor, 1.0 / oversizeFactor);
        return trans;
    }

    public void setExceptionOnError(boolean b) {
        this.exceptionOnError = b;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public String getId() {
        return this.strId;
    }

    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        return null;
    }

    public static final Envelope calcPrintEnv(Envelope tmpEnv, Dimension2D imageDimRotatedPx, int scale2, DrawingUnit drawingUnit) {
        Envelope printEnv = new Envelope(tmpEnv.centre());
        Dimension2D x = PrintDraftUtils.getPrintAreaInUnit(imageDimRotatedPx, scale2, drawingUnit);
        printEnv.expandBy(x.getWidth() / 2.0, x.getHeight() / 2.0);
        return printEnv;
    }

    public int getMaxPixel() {
        return this.maxPixel;
    }

    public Envelope getPrintEnvelope() {
        return this.env != null ? new Envelope(this.env) : null;
    }

    public byte getType() {
        return 1;
    }

    public byte getImageType() {
        return ImageTypeEnum.UNKNOWN.getValue();
    }

    public Dimension2D getDimension() throws JRException {
        return null;
    }

    public byte[] getImageData() throws JRException {
        return new byte[0];
    }

    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(grx, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        block28: {
            grx.setRenderingHint(Viewport.KEY_IS4PRINT, Viewport.VALUE_IS4PRINT);
            Task task = this.lv.getLayerManager().getTask();
            double savedScale = task.getScale();
            LayerManager layerManager = task.getLayerManager();
            PrintLayerView layerView = new PrintLayerView(layerManager);
            PropertyStorage<VectorLayerContext, String> savedLayerFilter = new PropertyStorage<VectorLayerContext, String>();
            PropertyStorage<LayerContext, Boolean> savedLayerContextVisibility = new PropertyStorage<LayerContext, Boolean>();
            PropertyStorage<Layerable, Boolean> savedLayerVisibility = new PropertyStorage<Layerable, Boolean>();
            Map<String, Object> p = VisibilityProfile.createProfile(layerManager);
            try {
                PrintRenderer.assignFilters(this.defRead, layerManager, savedLayerVisibility, savedLayerContextVisibility, savedLayerFilter);
                Dimension2DDouble imageDimPx = new Dimension2DDouble(rectangle.getWidth(), rectangle.getHeight());
                Dimension2D imageDimRotatedPx = PrintRendererUtils.calculateRotatedImageDimension((Dimension2D)imageDimPx, this.orientation);
                imageDimRotatedPx.setSize(Math.round(imageDimRotatedPx.getWidth()), Math.round(imageDimRotatedPx.getHeight()));
                DrawingUnit drawingUnit = task.getDrawingUnit();
                int scale2 = this.scaleDetector.determineScale((Dimension2D)imageDimPx, this.orientation, this.env, drawingUnit);
                task.setScale(scale2);
                Envelope printEnv = PrintRenderer.calcPrintEnv(this.env, imageDimRotatedPx, scale2, drawingUnit);
                Collection<Layerable> lstRenderContent = layerManager.getContentIDsDescending();
                for (Layerable renderContent : lstRenderContent) {
                    if (!(renderContent instanceof Layerable)) continue;
                    Layerable layerableRenderContent = renderContent;
                    if (this.pThread != null && this.pThread.isInterrupted()) {
                        return;
                    }
                    Renderer renderer = RenderingManager.createRenderer(renderContent, layerView);
                    if (renderer == null) continue;
                    AffineTransform tmpTr = grx.getTransform();
                    try {
                        if (renderContent instanceof Layer) {
                            try {
                                if (this.pThread != null) {
                                    this.pThread.setMessage(layerableRenderContent.getName());
                                }
                                double oversizeFactor = 5.0;
                                LOG.info(String.format("renderLayer: env '%s', orientation: '%s' (oversize: %f)", printEnv, this.orientation, 5.0));
                                AffineTransform trans = PrintRenderer.buildLayerTransform(5.0, this.orientation, (Dimension2D)imageDimPx, imageDimRotatedPx);
                                grx.setTransform(trans);
                                layerView.setSize(new Dimension((int)(imageDimRotatedPx.getWidth() * 5.0) + 1, (int)(imageDimRotatedPx.getHeight() * 5.0) + 1));
                                layerView.getViewport().zoom(printEnv, false);
                                Runnable runner = renderer.createRunnable();
                                if (runner != null) {
                                    runner.run();
                                }
                                renderer.copyTo(grx);
                                grx.setTransform(new AffineTransform());
                                grx.clipRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
                            }
                            catch (Exception e) {
                                String errMsg = String.format("error rendering layer '%s': %s", layerableRenderContent.getKey(), e.getMessage());
                                if (this.exceptionOnError) {
                                    throw new JRException(errMsg, (Throwable)e);
                                }
                                LOG.warn(errMsg, (Throwable)e);
                            }
                            continue;
                        }
                        int intTilesDone = 0;
                        Collection<PrintAreaTile> printAreaTiles = PrintAreaTile.tilePrintArea(imageDimRotatedPx, (Dimension2D)imageDimPx, printEnv, this.maxPixel, this.printQuality, this.orientation);
                        LOG.info(String.format("rendering envelope %.2f/%.2f to image: %.2f/%.2f with rotation %.2f => pxls: %.2f/%.2f", printEnv.getWidth(), printEnv.getHeight(), rectangle.getWidth(), rectangle.getHeight(), this.orientation, imageDimPx.getWidth(), imageDimPx.getHeight()));
                        for (PrintAreaTile currPrintTile : printAreaTiles) {
                            if (this.pThread != null && this.pThread.isInterrupted()) {
                                return;
                            }
                            LOG.debug(String.format("rendering tile %03d/%03d (%s)", intTilesDone, printAreaTiles.size(), currPrintTile));
                            try {
                                layerView.setSize((int)Math.round(currPrintTile.getPrintLocationPx().getWidth()), (int)Math.round(currPrintTile.getPrintLocationPx().getHeight()));
                                layerView.getViewport().zoom(currPrintTile.getPrintEnv(), false);
                                Runnable runner = renderer.createRunnable();
                                if (runner != null) {
                                    runner.run();
                                }
                                BufferedImage bim = ImageUtil.createBlankPanelImage(layerView.getWidth(), layerView.getHeight());
                                renderer.copyTo((Graphics2D)bim.getGraphics());
                                if (!ImageSupport.adobeReaderBugFix((BufferedImage)bim)) {
                                    ImageSupport.adobeReaderBugFix2((BufferedImage)bim);
                                }
                                grx.setTransform(currPrintTile.getTransformation());
                                grx.drawImage((Image)bim, 0, 0, null);
                                if (renderer.getContentID() instanceof Layerable && StringUtils.isNotBlank((CharSequence)((Layerable)renderer.getContentID()).getRenderError())) {
                                    throw new Exception(((Layerable)renderer.getContentID()).getRenderError());
                                }
                            }
                            catch (Exception e) {
                                String errMsg = String.format("error rendering '%s': %s", currPrintTile, e.getMessage());
                                if (this.exceptionOnError) {
                                    throw new JRException(errMsg, (Throwable)e);
                                }
                                LOG.warn(errMsg, (Throwable)e);
                            }
                            ++intTilesDone;
                            if (this.pThread == null || !(renderContent instanceof Layerable)) continue;
                            this.pThread.setMessage(String.format("%s,%s,%s", renderContent.getName(), intTilesDone, printAreaTiles.size()));
                        }
                    }
                    finally {
                        grx.setTransform(tmpTr);
                    }
                }
                if (this.scaleBarMargins == null) break block28;
                try {
                    ScaleBarRenderer.setEnabled(true, layerView.getBlackboard());
                    ScaleBarRenderer sbR = new ScaleBarRenderer(layerView);
                    sbR.setHorizontalMargin((int)this.scaleBarMargins.getWidth());
                    sbR.setVerticalMargin((int)this.scaleBarMargins.getHeight());
                    sbR.paint(grx, imageDimRotatedPx.getWidth() / printEnv.getWidth());
                }
                finally {
                    ScaleBarRenderer.setEnabled(false, layerView.getBlackboard());
                }
            }
            finally {
                task.setScale(savedScale);
                layerView.setSize(10, 10);
                savedLayerVisibility.resetValues(PropertyStorage.RESET_LAYERVISIBILITY);
                savedLayerContextVisibility.resetValues(PropertyStorage.RESET_LAYERCONTEXTVISIBILITY);
                savedLayerFilter.resetValues(PropertyStorage.RESET_LAYERFILTER);
                VisibilityProfile.activateProfile(layerManager, p);
            }
        }
    }

    public static void assignFilters(PrintAreaDefinition defRead, LayerManager layerManager, PropertyStorage<Layerable, Boolean> savedLayerVisibility, PropertyStorage<LayerContext, Boolean> savedLayerContextVisibility, PropertyStorage<VectorLayerContext, String> savedLayerFilter) {
        if (defRead != null) {
            for (Layerable ly : layerManager.getLayerables()) {
                String layerKey = ly.getKey();
                savedLayerVisibility.storeValue(ly, ly.isVisible());
                LOG.debug(String.format("assign filters on layer '%s'", layerKey));
                for (PrintAreaDefinitionLayerFilter currFDef : defRead.getFilters()) {
                    if (!currFDef.matchesLayerMask(layerKey)) continue;
                    Boolean newVisibility = currFDef.getVisible();
                    if (newVisibility != null) {
                        ly.setVisible(newVisibility);
                    }
                    try {
                        LayerContext lyctx = PrintRenderer.getLayerContext(ly);
                        if (lyctx == null) continue;
                        if (newVisibility != null) {
                            savedLayerContextVisibility.storeValue(lyctx, lyctx.isVisible());
                            lyctx.setVisible(newVisibility.booleanValue());
                        }
                        if (!(lyctx instanceof VectorLayerContext)) continue;
                        VectorLayerContext vlyctx = (VectorLayerContext)lyctx;
                        try {
                            savedLayerFilter.storeValue(vlyctx, vlyctx.getFilter());
                        }
                        catch (Exception ex) {
                            LOG.error(String.format("error getting filter from '%s': %s", vlyctx.getName(), ex.getMessage()), (Throwable)ex);
                        }
                        vlyctx.setFilter(currFDef.getFilterExpression());
                    }
                    catch (Exception ex) {
                        LOG.info(String.format("error accessing layer '%s': %s", layerKey, ex.getMessage()), (Throwable)ex);
                    }
                }
            }
        }
    }

    public static final LayerContext getLayerContext(Layerable ly) {
        if (ly == null) {
            return null;
        }
        if (ly instanceof Layer) {
            return ((Layer)ly).getVectorLayerContext();
        }
        if (ly instanceof WMSLayer) {
            return ((WMSLayer)ly).getWMSLayerContext();
        }
        return null;
    }
}

