/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.geom.Dimension2DDouble;
import java.awt.geom.Dimension2D;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;

public class PrintDraftUtils {
    public static double ptToUnit(double ptValue, DrawingUnit drawingUnit) {
        return PrintDraftUtils.ptToUnit(ptValue, drawingUnit.getInchInUnit());
    }

    public static double ptToUnit(double ptValue, double inchInUnit) {
        return ptValue / 72.0 * inchInUnit;
    }

    public static double unitToPt(double unitValue, DrawingUnit drawingUnit) {
        return PrintDraftUtils.unitToPt(unitValue, drawingUnit.getInchInUnit());
    }

    public static double unitToPt(double unitValue, double inchInUnit) {
        return unitValue / inchInUnit * 72.0;
    }

    public static Dimension2D getPrintAreaInUnit(Dimension2D printArea, double scale, DrawingUnit drawingUnit) {
        return new Dimension2DDouble(PrintDraftUtils.ptToUnit(printArea.getWidth(), drawingUnit) * scale, PrintDraftUtils.ptToUnit(printArea.getHeight(), drawingUnit) * scale);
    }

    public static double calcScale(double printLengthPx, double realWorldLength, DrawingUnit drawingUnit) {
        return realWorldLength / PrintDraftUtils.ptToUnit(printLengthPx, drawingUnit.getInchInUnit());
    }

    public static final Integer findMatchingScale(Dimension2D printAreaPt, Envelope env, DrawingUnit drawingUnit, Collection<Integer> scales) {
        for (Integer scale : scales) {
            Dimension2D x = PrintDraftUtils.getPrintAreaInUnit(printAreaPt, scale.intValue(), drawingUnit);
            if (!(env.getWidth() <= x.getWidth()) || !(env.getHeight() <= x.getHeight())) continue;
            return scale;
        }
        return -1;
    }

    public static final Envelope findMatchingEnvelope(Dimension2D printAreaPt, Envelope env, DrawingUnit drawingUnit, Collection<Integer> scales) {
        for (Integer scale : scales) {
            Dimension2D x = PrintDraftUtils.getPrintAreaInUnit(printAreaPt, scale.intValue(), drawingUnit);
            if (!(env.getWidth() <= x.getWidth()) || !(env.getHeight() <= x.getHeight())) continue;
            Envelope resEnv = new Envelope(env.centre());
            resEnv.expandBy(x.getWidth() / 2.0, x.getHeight() / 2.0);
            return resEnv;
        }
        return new Envelope(env);
    }

    private PrintDraftUtils() {
    }
}

