/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraftUtils;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.geom.Dimension2DDouble;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;

public class PrintDraft {
    public static final String JUMP_PARAMETERS_PROP_TYPE = "type";
    public static final String JUMP_PARAMETERS_PROP_MAXLENGTH = "maxlength";
    public static final String JUMP_PARAMETERS_PROP_DEFAULTVALUE = "defaultvalue";
    public static final String PARAM_SCALEBAR_H_MARGIN = "MAP_SCALEBAR_H_MARGIN";
    public static final String PARAM_SCALEBAR_V_MARGIN = "MAP_SCALEBAR_V_MARGIN";
    public static final String DEFAULT_PRINTAREA_NAME = "map";
    public static final String DEFAULT_PARAMETERS_NAME = "parameters";
    public static final String DEFAULT_LEGEND_NAME = "legend";
    private static final Dimension2D EMPTY_PRINTAREA = new Dimension2DDouble(0.0, 0.0);
    private final JasperReport fJRReport;
    private final Map<String, Dimension2D> fPrintAreas = new LinkedHashMap<String, Dimension2D>();
    private final String fReportName;
    private final Map<String, JRParameter> mapParameters = new LinkedHashMap<String, JRParameter>();
    private final Map<String, JRParameter> mapJumpParameters = new LinkedHashMap<String, JRParameter>();
    private final Map<String, JRParameter> mapMapParameters = new LinkedHashMap<String, JRParameter>();
    private boolean showScaleBar = false;
    private final File fOriginalReportFile;

    private PrintDraft(JasperReport jrReport, File originalReportFile) {
        this.fJRReport = jrReport;
        this.fOriginalReportFile = originalReportFile;
        this.fReportName = this.fJRReport.getName().replaceAll("_", " ");
        for (JRParameter currParameter : this.fJRReport.getParameters()) {
            String strParaName = currParameter.getName();
            this.mapParameters.put(strParaName, currParameter);
            if (StringUtils.startsWithIgnoreCase((CharSequence)strParaName, (CharSequence)"jump_")) {
                this.mapJumpParameters.put(strParaName, currParameter);
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)strParaName, (CharSequence)"map_")) continue;
            this.mapMapParameters.put(strParaName, currParameter);
        }
        String initialMapName = DEFAULT_PRINTAREA_NAME;
        this.addPrintArea(DEFAULT_PRINTAREA_NAME);
    }

    public String toString() {
        return String.format("PrintDraft (report: '%s', areas: %d, reportfile: '%s')", this.fJRReport, this.fPrintAreas.size(), this.fOriginalReportFile);
    }

    @Deprecated
    public PrintDraft(String draftFile) throws JRException {
        this(new File(draftFile));
    }

    public PrintDraft(File draftFile) throws JRException {
        this((JasperReport)JRLoader.loadObject((File)draftFile), draftFile);
    }

    public PrintDraft(InputStream draftStream) throws JRException {
        this((JasperReport)JRLoader.loadObject((InputStream)draftStream), null);
    }

    public JRElement findElementByName(String elementKey) {
        return PrintDraft.findElementByName((JRReport)this.getReport(), elementKey);
    }

    public JRBand retrieveBandOfElement(String elementKey) {
        return PrintDraft.retrieveBandOfElement((JRReport)this.getReport(), elementKey);
    }

    public static final JRElement findElementByName(JRReport jrReport, String elementKey) {
        List<JRBand> possibleBands = PrintDraft.buildBandList(jrReport);
        for (JRBand currentBand : possibleBands) {
            JRElement foundElement;
            if (currentBand == null || (foundElement = currentBand.getElementByKey(elementKey)) == null) continue;
            return foundElement;
        }
        return null;
    }

    public static final JRBand retrieveBandOfElement(JRReport jrReport, String elementKey) {
        List<JRBand> possibleBands = PrintDraft.buildBandList(jrReport);
        for (JRBand possibleBand : possibleBands) {
            JRElement resElem;
            if (possibleBand == null || (resElem = possibleBand.getElementByKey(elementKey)) == null) continue;
            return possibleBand;
        }
        return null;
    }

    public static List<JRBand> buildBandList(JRReport jrReport) {
        ArrayList<JRBand> possibleBands = new ArrayList<JRBand>();
        PrintDraft.addAllBands(possibleBands, jrReport.getDetailSection());
        possibleBands.add(jrReport.getBackground());
        possibleBands.add(jrReport.getColumnFooter());
        possibleBands.add(jrReport.getColumnHeader());
        possibleBands.add(jrReport.getLastPageFooter());
        possibleBands.add(jrReport.getPageFooter());
        possibleBands.add(jrReport.getPageHeader());
        possibleBands.add(jrReport.getNoData());
        possibleBands.add(jrReport.getSummary());
        possibleBands.add(jrReport.getTitle());
        JRGroup[] groups = jrReport.getGroups();
        if (groups != null) {
            for (JRGroup currGroup : groups) {
                PrintDraft.addAllBands(possibleBands, currGroup.getGroupHeaderSection());
                PrintDraft.addAllBands(possibleBands, currGroup.getGroupFooterSection());
            }
        }
        return possibleBands;
    }

    public static void addAllBands(List<JRBand> possibleBandList, JRSection sectionToAdd) {
        JRBand[] bandsToAdd;
        if (sectionToAdd != null && (bandsToAdd = sectionToAdd.getBands()) != null) {
            possibleBandList.addAll(Arrays.asList(bandsToAdd));
        }
    }

    public JasperReport getReport() {
        return this.fJRReport;
    }

    public Rectangle2D getOverlappingAreaInUnit(String areaName1, String areaName2, double scale, DrawingUnit drawingUnit) {
        Rectangle2D overlappingArea = this.getOverlappingAreaInPt(areaName1, areaName2);
        return new Rectangle2D.Double(PrintDraftUtils.ptToUnit(overlappingArea.getX(), drawingUnit) * scale, PrintDraftUtils.ptToUnit(overlappingArea.getY(), drawingUnit) * scale, PrintDraftUtils.ptToUnit(overlappingArea.getWidth(), drawingUnit) * scale, PrintDraftUtils.ptToUnit(overlappingArea.getHeight(), drawingUnit) * scale);
    }

    public Rectangle2D getOverlappingAreaInPt(String areaName1, String areaName2) {
        Rectangle2D.Double area2;
        JRBand jrArea2Band;
        JRElement jrArea1 = this.findElementByName(areaName1);
        JRElement jrArea2 = this.findElementByName(areaName2);
        JRBand jrArea1Band = this.retrieveBandOfElement(areaName1);
        if (!ObjectUtils.equals((Object)jrArea1Band, (Object)(jrArea2Band = this.retrieveBandOfElement(areaName2)))) {
            return new Rectangle2D.Double();
        }
        if (jrArea1 == null || jrArea2 == null) {
            return new Rectangle2D.Double();
        }
        Rectangle2D.Double area1 = new Rectangle2D.Double(jrArea1.getX(), jrArea1.getY(), jrArea1.getWidth(), jrArea1.getHeight());
        Rectangle2D intersectionArea = ((Rectangle2D)area1).createIntersection(area2 = new Rectangle2D.Double(jrArea2.getX(), jrArea2.getY(), jrArea2.getWidth(), jrArea2.getHeight()));
        if (intersectionArea.getWidth() > 0.0 && intersectionArea.getHeight() > 0.0) {
            return new Rectangle2D.Double(intersectionArea.getX() - ((RectangularShape)area1).getX(), intersectionArea.getY() - ((RectangularShape)area1).getY(), intersectionArea.getWidth(), intersectionArea.getHeight());
        }
        return new Rectangle2D.Double();
    }

    public Dimension2D getPrintAreaInPt(String areaName) {
        return this.getPrintArea(areaName);
    }

    public Dimension2D getPrintAreaInUnit(String areaName, double scale, DrawingUnit drawingUnit) {
        return PrintDraftUtils.getPrintAreaInUnit(this.getPrintAreaInPt(areaName), scale, drawingUnit);
    }

    public double calcAspect(String name) {
        Dimension2D pa = this.getPrintArea(name);
        if (pa != null) {
            return pa.getHeight() / pa.getWidth();
        }
        return 0.0;
    }

    @Deprecated
    public double determineScaleByHeight(String areaName, double height, DrawingUnit drawingUnit) {
        return PrintDraftUtils.calcScale(this.getPrintAreaInPt(areaName).getHeight(), height, drawingUnit);
    }

    @Deprecated
    public double determineScaleByWidth(String areaName, double width, DrawingUnit drawingUnit) {
        return PrintDraftUtils.calcScale(this.getPrintAreaInPt(areaName).getWidth(), width, drawingUnit);
    }

    public final double determineMaxScaleByDim(String areaName, double width, double height, DrawingUnit drawingUnit) {
        return Math.max(this.determineScaleByHeight(areaName, height, drawingUnit), this.determineScaleByWidth(areaName, width, drawingUnit));
    }

    public final double determineMaxScaleByDim(String areaName, Dimension2D dim, DrawingUnit drawingUnit) {
        return this.determineMaxScaleByDim(areaName, dim.getWidth(), dim.getHeight(), drawingUnit);
    }

    public String getName() {
        return this.fReportName;
    }

    public Map<String, JRParameter> getParameters() {
        return new HashMap<String, JRParameter>(this.mapParameters);
    }

    public Map<String, Map<String, String>> getJumpParameters() {
        LinkedHashMap<String, Map<String, String>> mapJumpParameters2Return = new LinkedHashMap<String, Map<String, String>>();
        for (String key : this.mapJumpParameters.keySet()) {
            HashMap<String, String> mapProperties;
            block7: {
                JRParameter jrParam;
                block6: {
                    jrParam = this.mapJumpParameters.get(key);
                    mapProperties = new HashMap<String, String>();
                    if (jrParam.getPropertiesMap() != null && jrParam.getPropertiesMap().hasOwnProperties()) break block6;
                    if (StringUtils.isBlank((CharSequence)jrParam.getDescription())) break block7;
                    String[] arrDesc = jrParam.getDescription().split("\\|");
                    if (arrDesc.length > 0) {
                        if (arrDesc[0].equalsIgnoreCase("t")) {
                            mapProperties.put(JUMP_PARAMETERS_PROP_TYPE, "text");
                        } else {
                            mapProperties.put(JUMP_PARAMETERS_PROP_TYPE, "area");
                        }
                    }
                    if (arrDesc.length > 1) {
                        mapProperties.put(JUMP_PARAMETERS_PROP_MAXLENGTH, arrDesc[1]);
                    }
                    if (arrDesc.length <= 2) break block7;
                    mapProperties.put(JUMP_PARAMETERS_PROP_DEFAULTVALUE, arrDesc[2]);
                    break block7;
                }
                for (String propName : jrParam.getPropertiesMap().getPropertyNames()) {
                    String propValue = jrParam.getPropertiesMap().getProperty(propName);
                    mapProperties.put(propName, propValue);
                }
            }
            mapJumpParameters2Return.put(key, mapProperties);
        }
        return mapJumpParameters2Return;
    }

    public Map<String, Map<String, String>> getMapParameters() {
        LinkedHashMap<String, Map<String, String>> mapMapParameters2Return = new LinkedHashMap<String, Map<String, String>>();
        for (String key : this.mapMapParameters.keySet()) {
            JRParameter jrParam = this.mapMapParameters.get(key);
            HashMap<String, String> mapProperties = new HashMap<String, String>();
            JRPropertiesMap propMap = jrParam.getPropertiesMap();
            if (propMap != null) {
                for (String propName : propMap.getPropertyNames()) {
                    mapProperties.put(propName, propMap.getProperty(propName));
                }
            }
            mapMapParameters2Return.put(key, mapProperties);
        }
        return mapMapParameters2Return;
    }

    public Dimension2D getScaleBarMargins() {
        if (this.getShowScaleBar()) {
            return new Dimension2DDouble((double)this.getScaleBarHorizontalMargin(), (double)this.getScaleBarVerticalMargin());
        }
        return null;
    }

    @Deprecated
    public boolean getShowScaleBar() {
        return this.showScaleBar;
    }

    public void setShowScaleBar(boolean showScaleBar) {
        this.showScaleBar = showScaleBar;
    }

    @Deprecated
    public int getScaleBarHorizontalMargin() {
        try {
            if (this.mapMapParameters.containsKey(PARAM_SCALEBAR_H_MARGIN)) {
                return Integer.parseInt(this.mapMapParameters.get(PARAM_SCALEBAR_H_MARGIN).getDescription());
            }
            return 3;
        }
        catch (Exception e) {
            return 3;
        }
    }

    public int getScaleBarVerticalMargin() {
        try {
            if (this.mapMapParameters.containsKey(PARAM_SCALEBAR_V_MARGIN)) {
                return Integer.parseInt(this.mapMapParameters.get(PARAM_SCALEBAR_V_MARGIN).getDescription());
            }
            return 3;
        }
        catch (Exception e) {
            return 3;
        }
    }

    public static Envelope centerEnvelopeToPrintArea(Envelope env, Dimension2D printArea) {
        double dblNewWidth;
        double dblNewHeight;
        double aspectPrintArea = printArea.getHeight() / printArea.getWidth();
        if (env.getHeight() / env.getWidth() < aspectPrintArea) {
            dblNewHeight = env.getWidth() * aspectPrintArea;
            dblNewWidth = env.getWidth();
        } else {
            dblNewHeight = env.getHeight();
            dblNewWidth = env.getHeight() / aspectPrintArea;
        }
        return new Envelope(env.centre().x - dblNewWidth / 2.0, env.centre().x + dblNewWidth / 2.0, env.centre().y - dblNewHeight / 2.0, env.centre().y + dblNewHeight / 2.0);
    }

    public final Dimension2D addPrintArea(String areaName) {
        JRElement element = PrintDraft.findElementByName((JRReport)this.fJRReport, areaName);
        Dimension2D areaDimension = element != null ? new Dimension2DDouble((double)(element.getWidth() - 1), (double)(element.getHeight() - 1)) : EMPTY_PRINTAREA;
        this.addPrintArea(areaName, areaDimension);
        return areaDimension;
    }

    public final void addPrintArea(String areaName, Dimension2D dimension) {
        this.fPrintAreas.put(areaName, dimension);
    }

    public final Dimension2D getPrintArea(String mapName) {
        return this.fPrintAreas.get(mapName);
    }

    public File getOriginalReportFile() {
        return this.fOriginalReportFile;
    }
}

