/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDialogLegendTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendModel;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class PrintDialogLegendListTransferHandler
extends TransferHandler {
    private final DataFlavor dataFlavor;

    PrintDialogLegendListTransferHandler() {
        this(PrintDialogLegendTransferable.LEGEND_FLAVOR);
    }

    PrintDialogLegendListTransferHandler(DataFlavor dataFlavor) {
        this.dataFlavor = dataFlavor;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2 && source instanceof JList && data.isDataFlavorSupported(this.dataFlavor)) {
            Collection entries2Remove;
            JList legEntryList = (JList)source;
            ListListModel listModel = (ListListModel)legEntryList.getModel();
            try {
                entries2Remove = (Collection)data.getTransferData(this.dataFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                return;
            }
            catch (IOException ex) {
                return;
            }
            for (LegendModel legEntry : entries2Remove) {
                listModel.removeListObject((Object)legEntry);
            }
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JList) {
            JList legEntryList = (JList)c;
            List<LegendModel> selLegEntries = legEntryList.getSelectedValuesList();
            return new PrintDialogLegendTransferable(selLegEntries, this.dataFlavor);
        }
        ArrayList<LegendModel> lstEmpty = new ArrayList<LegendModel>();
        return new PrintDialogLegendTransferable(lstEmpty, this.dataFlavor);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.equals(this.dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public static final void addEntries2List(JList<LegendModel> list2Import, Collection<LegendModel> legends2import, int index) {
        int startIndex = index;
        for (LegendModel legendModel : legends2import) {
            ListListModel listModel = (ListListModel)list2Import.getModel();
            listModel.addListObject((Object)((LegendModel)legendModel.cloneModel()), Math.max(0, index));
            ++index;
        }
        list2Import.getSelectionModel().addSelectionInterval(startIndex, --index);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Component c = support.getComponent();
        if (c instanceof JList) {
            Collection entries2import;
            JList list2Import = (JList)c;
            Transferable legTransfer = support.getTransferable();
            try {
                entries2import = (Collection)legTransfer.getTransferData(PrintDialogLegendTransferable.LEGEND_FLAVOR);
            }
            catch (UnsupportedFlavorException ex) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
            if (list2Import == null || list2Import.getDropLocation() == null) {
                return false;
            }
            int index2drop = list2Import.getDropLocation().getIndex();
            PrintDialogLegendListTransferHandler.addEntries2List(list2Import, entries2import, index2drop);
            return true;
        }
        return false;
    }
}

