/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.LocaleAwareStringComparator;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.ChooseEnvelopeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.print.AreaTableCellEditor;
import com.vividsolutions.jump.workbench.ui.plugin.print.ChooseDraftDialog;
import com.vividsolutions.jump.workbench.ui.plugin.print.GeneratePrintDialog;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDialogLegendListTransferHandler;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDialogLegendTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraftUtils;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintThread;
import com.vividsolutions.jump.workbench.ui.plugin.print.SetCenterTool;
import com.vividsolutions.jump.workbench.ui.plugin.print.SetOrientationTool;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendIO;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendManagerDialog;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendModelListCellRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendModel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.Config;
import de.riwagis.util.DateSupport;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListComboBoxModel;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintDialog
extends JDialog
implements ChooseEnvelopeTool.EnvelopeConsumer {
    private final LocaleAwareStringComparator comparator = new LocaleAwareStringComparator();
    private static final int[] SCALES = new int[]{100, 250, 500, 1000, 2500, 5000, 10000, 25000, 50000, 100000, 250000, 500000};
    private static final Logger LOG = LoggerFactory.getLogger(PrintDialog.class);
    private static final String PBB_LOGO = String.valueOf(PrintDialog.class) + " - LOGO";
    static final String PBB_DRAFTS = String.valueOf(PrintDialog.class) + "_PARAMETER_DRAFTS";
    private static final String PBB_PRINTED_REGIONS = String.valueOf(PrintDialog.class) + "_PRINTED_REGIONS";
    static final String PBB_SHOW_PARAMETERS = String.valueOf(PrintDialog.class) + "_SHOW_PARAMETERS";
    private static final String PBB_SHOW_SCALEBAR = String.valueOf(PrintDialog.class) + "_SHOW_SCALEBAR";
    static final String PBB_SHOW_LEGEND = String.valueOf(PrintDialog.class) + "_SHOW_LEGEND";
    private static final String PBB_LEGENDS = String.valueOf(PrintDialog.class) + "_LEGENDS";
    private static final String PBB_PRINT_QUALITY = String.valueOf(PrintDialog.class) + "_QUALITY";
    private static final float PRINT_QUALITY_SCREEN = 1.33f;
    private static final float PRINT_QUALITY_LOW = 1.66f;
    private static final float PRINT_QUALITY_MEDIUM = 2.5f;
    private static final float PRINT_QUALITY_HIGH = 4.16f;
    private static final String PRINT_PREVIEW = "PREVIEW_PRINT";
    private static final String BLACKBOARD_PRINTED_REGIONS = "PRINTED_REGIONS";
    private PlugInContext context;
    private PrintDraft printDraft = null;
    private double scale = 1000.0;
    private Coordinate coordCenter = null;
    private int orientation = 0;
    private final NumberFormat df = new DecimalFormat();
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private final GeometryFactory gfac = new GeometryFactory();
    private boolean bolDisableComponentUpdate = false;
    private boolean bolShowPrintedRegions = true;
    private final SetCenterTool centerTool = new SetCenterTool(this);
    private final SetOrientationTool oriTool = new SetOrientationTool(this);
    private final ChooseEnvelopeTool regionTool = new ChooseEnvelopeTool(this);
    private boolean active = false;
    private CursorTool oldCursorTool;
    private float printQuality = 1.66f;
    private final JFrame owner;
    private final Blackboard pBB;
    private final Map<String, Object> mapParamDrafts = new HashMap<String, Object>();
    private final List<Geometry> lstPrintedRegions = new ArrayList<Geometry>();
    private final ListComboBoxModel<String> logoModel = new ListComboBoxModel(new ArrayList(), false, null);
    private final ListComboBoxModel<String> parameterModel = new ListComboBoxModel(new ArrayList(), true, (Comparator)this.comparator);
    private final ListListModel<LegendModel> legendsAvailableModel = new ListListModel(new ArrayList(), true, null);
    private final ListListModel<LegendModel> legendsSelectedModel = new ListListModel(new ArrayList(), false, null);
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 27) {
                PrintDialog.this.closePrint(true);
            } else if (code == 10) {
                PrintDialog.this.updateComponents();
            }
        }
    };
    public static final Map<String, String> specialTreatmentParameters = new LinkedHashMap<String, String>();
    private JButton butCancel;
    private JButton butChoosOri;
    private JButton butChooseCenter;
    private JButton butChooseDraft;
    private JButton butChooseRegion;
    private JButton butDelete;
    private JButton butDown;
    private JButton butInsert;
    private JButton butLeft;
    private JButton butLegendAdd;
    private JButton butLegendDown;
    private JButton butLegendManager;
    private JButton butLegendRemove;
    private JButton butLegendUp;
    private JButton butPrint;
    private JButton butResetPrintedRegions;
    private JButton butRight;
    private JButton butUp;
    private JButton butUpdate;
    private JComboBox<String> cboScale;
    private JCheckBox cboShowLegend;
    private JCheckBox cboShowParameters;
    private JCheckBox cboShowPrintedRegions;
    private JCheckBox cboShowScaleBar;
    private JComboBox<String> cmbLogo;
    private JComboBox<String> cmbParameter;
    private JComboBox<String> cmbQuality;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JLabel lblDegree;
    private JLabel lblDraft;
    private JLabel lblDraftName;
    private JLabel lblHeight;
    private JLabel lblLogo;
    private JLabel lblQuality;
    private JLabel lblScale;
    private JLabel lblWidth;
    private JList<LegendModel> lstLegends;
    private JList<LegendModel> lstLegendsSelected;
    private JPanel pnlCenter;
    private JPanel pnlLegend;
    private JPanel pnlOkCancel;
    private JPanel pnlParameter;
    private JPanel pnlPosition;
    private JTabbedPane tabPane;
    private JTable tblParameter;
    private JFormattedTextField txtHeight;
    private JFormattedTextField txtOrientation;
    private JFormattedTextField txtWidth;

    public PrintDialog(JFrame _owner, PlugInContext _context) {
        super((Frame)_owner, false);
        this.owner = _owner;
        this.context = _context;
        this.pBB = PersistentBlackboardPlugIn.get();
        this.initComponents();
        this.setSize(330, 620);
        this.i18n();
        this.init();
        this.setContext(_context);
        GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)this.keyListener);
        this.setFocusable(false);
    }

    public final void setContext(PlugInContext _context) {
        this.context = _context;
        this.setScaleByScreenScale();
        String strUnit = _context.getTask().getDrawingUnit().getUnitAbbreviation();
        this.lblWidth.setText(String.format("%s (%s):", I18N.get("ui.plugin.print.PrintDialog.width"), strUnit));
        this.lblHeight.setText(String.format("%s (%s):", I18N.get("ui.plugin.print.PrintDialog.height"), strUnit));
        this.updateComponents();
    }

    protected Map<String, Geometry> readGeomsFromBlackboard(Blackboard _blackboard, String _blackboardEntry, Map<String, Geometry> _defaultValue) {
        return (Map)_blackboard.get(_blackboardEntry, _defaultValue);
    }

    private void i18n() {
        this.lblDraft.setText(I18N.get("ui.plugin.print.PrintDialog.draft"));
        this.butChooseDraft.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.choosedraft"));
        this.lblLogo.setText(I18N.get("ui.plugin.print.PrintDialog.logo"));
        this.butCancel.setText(I18N.get("ui.plugin.print.PrintDialog.cancel"));
        this.butPrint.setText(I18N.get("ui.plugin.print.PrintDialog.print"));
        this.lblScale.setText(I18N.get("ui.plugin.print.PrintDialog.scale"));
        this.butChoosOri.setText(I18N.get("ui.plugin.print.PrintDialog.orientation"));
        this.butChooseCenter.setText(I18N.get("ui.plugin.print.PrintDialog.center"));
        this.butChooseRegion.setText(I18N.get("ui.plugin.print.PrintDialog.printregion"));
        this.lblQuality.setText(I18N.get("ui.plugin.print.PrintDialog.quality"));
        this.lblQuality.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.quality-tooltip"));
        this.cmbQuality.removeAllItems();
        this.cmbQuality.addItem(I18N.get("ui.plugin.print.PrintDialog.quality-screen"));
        this.cmbQuality.addItem(I18N.get("ui.plugin.print.PrintDialog.quality-low"));
        this.cmbQuality.addItem(I18N.get("ui.plugin.print.PrintDialog.quality-medium"));
        this.cmbQuality.addItem(I18N.get("ui.plugin.print.PrintDialog.quality-high"));
        this.cmbQuality.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.quality-tooltip"));
        this.cboShowParameters.setText(I18N.get("ui.plugin.print.PrintDialog.show-parameters"));
        this.cboShowScaleBar.setText(I18N.get("ui.plugin.print.PrintDialog.show-scalebar"));
        this.cboShowPrintedRegions.setText(I18N.get("ui.plugin.print.PrintDialog.printed-regions"));
        this.cboShowPrintedRegions.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.printed-regions-tooltip"));
        this.butResetPrintedRegions.setText(I18N.get("ui.plugin.print.PrintDialog.reset-printed-regions"));
        this.butLegendManager.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.legend-manager-tooltip"));
        this.tabPane.setTitleAt(0, I18N.get("ui.plugin.print.PrintDialog.parameters"));
        this.tabPane.setTitleAt(1, I18N.get("ui.plugin.print.PrintDialog.legend"));
        this.setTitle(I18N.get("ui.plugin.print.PrintDialog.title"));
    }

    private DrawingUnit getDrawingUnit() {
        return this.context.getTask().getDrawingUnit();
    }

    private void init() {
        this.comparator.setLocale(Config.LOCALE);
        this.setScaleByScreenScale();
        this.printDraft = ChooseDraftDialog.getLastPrintDraft();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (PrintDialog.this.printDraft == null) {
                    PrintDialog.this.butChooseDraft_onClick(null);
                } else {
                    PrintDialog.this.updateComponents();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PrintDialog.this.closePrint(true);
            }
        });
        this.df.setMaximumFractionDigits(2);
        this.df.setGroupingUsed(false);
        this.nf.setGroupingUsed(false);
        this.txtWidth.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtHeight.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtOrientation.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
        this.butLeft.setIcon(IconLoader.svgIcon((String)"common_arrow_left.svg"));
        this.butRight.setIcon(IconLoader.svgIcon((String)"common_arrow_right.svg"));
        this.butUp.setIcon(IconLoader.svgIcon((String)"common_arrow_up.svg"));
        this.butDown.setIcon(IconLoader.svgIcon((String)"common_arrow_down.svg"));
        this.butInsert.setIcon(IconLoader.svgIconSmall((String)"common_add.svg"));
        this.butInsert.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.new-parameter-draft"));
        this.butUpdate.setIcon(IconLoader.svgIconSmall((String)"common_save.svg"));
        this.butUpdate.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.update-parameter-draft"));
        this.butDelete.setIcon(IconLoader.svgIconSmall((String)"common_delete.svg"));
        this.butDelete.setToolTipText(I18N.get("ui.plugin.print.PrintDialog.delete-parameter-draft"));
        this.printQuality = (float)this.pBB.get(PBB_PRINT_QUALITY, 1.66f);
        this.publishPrintQuality2CmbQuality();
        this.mapParamDrafts.clear();
        this.mapParamDrafts.putAll((Map)this.pBB.get(PBB_DRAFTS, new HashMap()));
        ArrayList<String> lstParamDrafts = new ArrayList<String>();
        Iterator<String> iParamDraft = this.mapParamDrafts.keySet().iterator();
        while (iParamDraft.hasNext()) {
            lstParamDrafts.add(iParamDraft.next());
        }
        this.parameterModel.setList(lstParamDrafts);
        this.bolShowPrintedRegions = this.pBB.get(PBB_PRINTED_REGIONS, true);
        this.cboShowLegend.setSelected(this.pBB.get(PBB_SHOW_LEGEND, false));
        this.cboShowParameters.setSelected(this.pBB.get(PBB_SHOW_PARAMETERS, true));
        this.cboShowScaleBar.setSelected(this.pBB.get(PBB_SHOW_SCALEBAR, false));
        this.butLegendRemove.setText("");
        this.butLegendRemove.setMargin(new Insets(0, 0, 0, 0));
        this.butLegendRemove.setIcon(IconLoader.svgIconSmall((String)"show_previous.svg"));
        this.butLegendAdd.setText("");
        this.butLegendAdd.setMargin(new Insets(0, 0, 0, 0));
        this.butLegendAdd.setIcon(IconLoader.svgIconSmall((String)"show_next.svg"));
        this.butLegendUp.setText("");
        this.butLegendUp.setMargin(new Insets(0, 0, 0, 0));
        this.butLegendUp.setIcon(IconLoader.svgIconSmall((String)"common_triangle_up.svg"));
        this.butLegendDown.setText("");
        this.butLegendDown.setMargin(new Insets(0, 0, 0, 0));
        this.butLegendDown.setIcon(IconLoader.svgIconSmall((String)"common_triangle_down.svg"));
        this.lstLegends.setCellRenderer(new LegendModelListCellRenderer());
        this.lstLegends.setTransferHandler(new PrintDialogLegendListTransferHandler(PrintDialogLegendTransferable.LEGEND_FLAVOR_LEFT){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (support.getDataFlavors()[0] == PrintDialogLegendTransferable.LEGEND_FLAVOR_LEFT) {
                    return false;
                }
                return super.canImport(support);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                boolean dataImported = super.importData(support);
                if (dataImported) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PrintDialog.this.lstLegends.getSelectionModel().clearSelection();
                        }
                    });
                }
                return dataImported;
            }
        });
        this.lstLegendsSelected.setCellRenderer(new LegendModelListCellRenderer());
        this.lstLegendsSelected.setTransferHandler(new PrintDialogLegendListTransferHandler(PrintDialogLegendTransferable.LEGEND_FLAVOR_RIGHT));
        this.refillLogoList();
        this.refillLegendList(null);
        this.updateParameters();
        this.updateComponents();
    }

    public void refillLogoList() {
        try {
            if (JUMPWorkbench.GIS_CONTEXT != null) {
                String[] arrLogo = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFileList("logo");
                Arrays.sort(arrLogo, String.CASE_INSENSITIVE_ORDER);
                int idxLogo = this.pBB.get(PBB_LOGO, Math.max(this.cmbLogo.getSelectedIndex(), 1));
                ArrayList<String> logoItems = new ArrayList<String>();
                logoItems.add(I18N.get("ui.plugin.print.PrintDialog.no-logo"));
                logoItems.addAll(Arrays.asList(arrLogo));
                this.logoModel.setList(logoItems);
                if (this.cmbLogo.getItemCount() > idxLogo) {
                    this.cmbLogo.setSelectedIndex(idxLogo);
                }
            } else {
                this.cmbLogo.setVisible(false);
                this.lblLogo.setVisible(false);
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    public void refillLegendList(List<String> legendsNameSelected) {
        List legendsNameSelectedX = legendsNameSelected == null ? (List)this.pBB.get(PBB_LEGENDS, new ArrayList()) : legendsNameSelected;
        List<LegendModel> allLegends = LegendIO.getInstance().getUserLegends();
        ArrayList<LegendModel> legendsNotSelected = new ArrayList<LegendModel>();
        for (LegendModel currentLegendModel : allLegends) {
            boolean found = this.containsIgnoreCase(legendsNameSelectedX, currentLegendModel.getName());
            if (found) continue;
            legendsNotSelected.add(currentLegendModel);
        }
        ArrayList<LegendModel> legendsSelected = new ArrayList<LegendModel>();
        block1: for (String legName : legendsNameSelectedX) {
            for (LegendModel currentLegendModel : allLegends) {
                if (!currentLegendModel.getName().equalsIgnoreCase(legName)) continue;
                legendsSelected.add(currentLegendModel);
                continue block1;
            }
        }
        this.legendsAvailableModel.setList(legendsNotSelected);
        this.legendsSelectedModel.setList(legendsSelected);
    }

    public boolean containsIgnoreCase(List<String> legendsNameSelectedX, String searchName) {
        for (String legName : legendsNameSelectedX) {
            if (!searchName.equalsIgnoreCase(legName)) continue;
            return true;
        }
        return false;
    }

    private void setScaleByScreenScale() {
        Coordinate newCenter = this.getNewCenter();
        if (this.coordCenter != null && newCenter.equals((Object)this.coordCenter)) {
            return;
        }
        this.scale = this.context.getTask().getScale();
        double diff = Double.MAX_VALUE;
        double newScale = this.scale;
        for (int tmpScale : SCALES) {
            double tmpdiff = this.scale - (double)tmpScale;
            if (tmpdiff < 0.0 || !(tmpdiff < diff)) continue;
            newScale = tmpScale;
            diff = tmpdiff;
        }
        this.scale = newScale;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void updateComponents() {
        this.coordCenter = this.getNewCenter();
        if (this.printDraft == null) {
            this.butCancel.setEnabled(true);
            this.butChooseCenter.setEnabled(false);
            this.butChooseDraft.setEnabled(true);
            this.butPrint.setEnabled(false);
            this.cboScale.setEnabled(false);
            this.lblDraftName.setText(I18N.get("ui.plugin.print.PrintDialog.choosedraft"));
            this.tblParameter.setEnabled(false);
            this.txtHeight.setEnabled(false);
            this.txtOrientation.setEnabled(false);
            this.txtWidth.setEnabled(false);
            this.cmbLogo.setEnabled(false);
            this.cboShowScaleBar.setEnabled(false);
            this.cboShowPrintedRegions.setEnabled(false);
            this.butResetPrintedRegions.setEnabled(false);
            this.cboShowLegend.setEnabled(false);
            this.lstLegends.setEnabled(false);
            this.lstLegendsSelected.setEnabled(false);
            this.butLegendAdd.setEnabled(false);
            this.butLegendDown.setEnabled(false);
            this.butLegendRemove.setEnabled(false);
            this.butLegendUp.setEnabled(false);
            this.butLegendManager.setEnabled(false);
            this.tabPane.setTitleAt(0, I18N.get("ui.plugin.print.PrintDialog.parameters"));
            this.tabPane.setTitleAt(1, I18N.get("ui.plugin.print.PrintDialog.legend"));
        } else {
            if (this.bolDisableComponentUpdate) {
                return;
            }
            this.bolDisableComponentUpdate = true;
            this.butCancel.setEnabled(true);
            this.butChooseCenter.setEnabled(true);
            this.butChooseDraft.setEnabled(true);
            this.butPrint.setEnabled(true);
            this.cboScale.setEnabled(true);
            this.lblDraftName.setText(this.printDraft.getName());
            this.lblDraftName.setToolTipText(this.printDraft.getName());
            this.tblParameter.setEnabled(true);
            this.txtHeight.setEnabled(true);
            this.txtOrientation.setEnabled(true);
            this.txtWidth.setEnabled(true);
            this.cboShowScaleBar.setEnabled(true);
            this.cboShowPrintedRegions.setEnabled(true);
            this.butResetPrintedRegions.setEnabled(true);
            if (JUMPWorkbench.GIS_CONTEXT != null && this.printDraft.getMapParameters().containsKey("MAP_LOGO") && this.cmbLogo.getItemCount() > 1) {
                this.cmbLogo.setEnabled(true);
            }
            this.cboScale.setSelectedItem("1 : " + this.nf.format(this.scale));
            try {
                this.txtOrientation.setText(this.nf.format(this.orientation));
                Dimension2D printDim = this.printDraft.getPrintAreaInUnit("map", this.scale, this.getDrawingUnit());
                this.txtWidth.setText(this.df.format(printDim.getWidth()));
                this.txtHeight.setText(this.df.format(printDim.getHeight()));
            }
            catch (Exception e) {
                LOG.error("Error formating numbers.", (Throwable)e);
            }
            this.bolDisableComponentUpdate = false;
            if (this.cboShowParameters.isSelected()) {
                this.tabPane.setTitleAt(0, "<html><b>" + I18N.get("ui.plugin.print.PrintDialog.parameters") + "</b></html>");
                this.tblParameter.setEnabled(true);
                this.pnlParameter.setEnabled(true);
                this.cmbParameter.setEnabled(true);
                this.butDelete.setEnabled(true);
                this.butInsert.setEnabled(true);
                this.butUpdate.setEnabled(true);
            } else {
                this.tabPane.setTitleAt(0, I18N.get("ui.plugin.print.PrintDialog.parameters"));
                this.tblParameter.setEnabled(false);
                this.pnlParameter.setEnabled(false);
                this.cmbParameter.setEnabled(false);
                this.butDelete.setEnabled(false);
                this.butInsert.setEnabled(false);
                this.butUpdate.setEnabled(false);
            }
            this.cboShowPrintedRegions.setSelected(this.bolShowPrintedRegions);
            if (this.printDraft.getMapParameters().containsKey("MAP_LEGEND")) {
                this.cboShowLegend.setEnabled(true);
                if (this.cboShowLegend.isSelected()) {
                    this.tabPane.setTitleAt(1, "<html><b>" + I18N.get("ui.plugin.print.PrintDialog.legend") + "</b></html>");
                    this.lstLegends.setEnabled(true);
                    this.lstLegendsSelected.setEnabled(true);
                    this.butLegendAdd.setEnabled(true);
                    this.butLegendDown.setEnabled(true);
                    this.butLegendRemove.setEnabled(true);
                    this.butLegendUp.setEnabled(true);
                    this.butLegendManager.setEnabled(true);
                } else {
                    this.tabPane.setTitleAt(1, I18N.get("ui.plugin.print.PrintDialog.legend"));
                    this.lstLegends.setEnabled(false);
                    this.lstLegendsSelected.setEnabled(false);
                    this.butLegendAdd.setEnabled(false);
                    this.butLegendDown.setEnabled(false);
                    this.butLegendRemove.setEnabled(false);
                    this.butLegendUp.setEnabled(false);
                    this.butLegendManager.setEnabled(false);
                }
            } else {
                this.tabPane.setTitleAt(1, I18N.get("ui.plugin.print.PrintDialog.legend"));
                this.cboShowLegend.setEnabled(false);
                this.lstLegends.setEnabled(false);
                this.lstLegendsSelected.setEnabled(false);
                this.butLegendAdd.setEnabled(false);
                this.butLegendDown.setEnabled(false);
                this.butLegendRemove.setEnabled(false);
                this.butLegendUp.setEnabled(false);
                this.butLegendManager.setEnabled(false);
            }
            try {
                this.drawPreview();
            }
            catch (Exception e) {
                ChooseDraftDialog.removeLastPrintDraft();
                this.printDraft = null;
                this.coordCenter = null;
                this.setScaleByScreenScale();
                this.updateComponents();
                ErrorBox.showException((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.error"), (String)I18N.get("ui.plugin.print.PrintDialog.preview-error"), (Throwable)e);
            }
        }
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int ori) {
        this.orientation = ori;
        this.txtOrientation.setText(this.nf.format(this.orientation));
        this.drawPreview();
    }

    private Coordinate getNewCenter() {
        Viewport vp = this.context.getLayerViewPanel().getViewport();
        Envelope env = vp.getEnvelopeInModelCoordinates();
        Coordinate coord = new Coordinate();
        coord.x = (env.getMaxX() + env.getMinX()) / 2.0;
        coord.y = (env.getMaxY() + env.getMinY()) / 2.0;
        return coord;
    }

    Coordinate getCenter() {
        if (this.coordCenter == null) {
            this.coordCenter = this.getNewCenter();
        }
        return this.coordCenter;
    }

    void setCenter(Coordinate coord) {
        this.coordCenter = coord;
        LayerViewPanel lvp = this.context.getLayerViewPanel();
        boolean repaint = lvp.isRepainting();
        lvp.setRepaint(false);
        try {
            lvp.getViewport().zoomToViewPoint(lvp.getViewport().toViewPoint(this.coordCenter), 1.0);
            this.updateComponents();
        }
        catch (Exception e) {
            LOG.error("Error zooming new print center", (Throwable)e);
        }
        lvp.setRepaint(repaint);
        lvp.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnvelope(Envelope env) {
        if (!this.isActive()) {
            return;
        }
        this.coordCenter = env.centre();
        LayerViewPanel lvp = this.context.getLayerViewPanel();
        this.orientation = 0;
        boolean repaint = lvp.isRepainting();
        try {
            lvp.setRepaint(false);
            Dimension2D dim = this.printDraft.getPrintAreaInPt("map");
            double d1 = dim.getHeight() / env.getHeight();
            double d2 = dim.getWidth() / env.getWidth();
            if (d2 > d1) {
                double hu = PrintDraftUtils.ptToUnit(dim.getHeight(), this.getDrawingUnit());
                this.scale = env.getHeight() / hu;
            } else {
                double wu = PrintDraftUtils.ptToUnit(dim.getWidth(), this.getDrawingUnit());
                this.scale = env.getWidth() / wu;
            }
            lvp.getViewport().zoomToViewPoint(lvp.getViewport().toViewPoint(this.coordCenter), 1.0);
            this.updateComponents();
        }
        catch (Exception exception) {
        }
        finally {
            lvp.setRepaint(repaint);
            lvp.repaint();
        }
    }

    public GeometryCollection getPreview(boolean bolArea) {
        this.coordCenter = this.getCenter();
        return this.getPreview(this.coordCenter, this.orientation, bolArea);
    }

    public GeometryCollection getPreview(Coordinate coord, int ori, boolean bolArea) {
        double xc = coord.x;
        double yc = coord.y;
        AffineTransform rotationTransform = AffineTransform.getRotateInstance(Math.toRadians(ori), xc, yc);
        Point2D[] arrRectPrintArea = new Point2D[5];
        Point2D[] arrRectLegend = new Point2D[5];
        Point2D[] arrRectParameters = new Point2D[5];
        Point2D[] arrRectPrintAreaDest = new Point2D[5];
        Point2D[] arrRectLegendDest = new Point2D[5];
        Point2D[] arrRectParametersDest = new Point2D[5];
        Point2D[] arrCorner = new Point2D[2];
        Point2D[] arrCornerDest = new Point2D[2];
        Dimension2D printAreaInM = this.printDraft.getPrintAreaInUnit("map", this.scale, this.getDrawingUnit());
        double w = printAreaInM.getWidth() / 2.0;
        double h = printAreaInM.getHeight() / 2.0;
        arrRectPrintArea[0] = new Point2D.Double(xc - w, yc + h);
        arrRectPrintArea[1] = new Point2D.Double(xc + w, yc + h);
        arrRectPrintArea[2] = new Point2D.Double(xc + w, yc - h);
        arrRectPrintArea[3] = new Point2D.Double(xc - w, yc - h);
        arrRectPrintArea[4] = new Point2D.Double(xc - w, yc + h);
        Rectangle2D legendAreaInUnit = new Rectangle2D.Double();
        if (this.cboShowLegend.isEnabled() && this.cboShowLegend.isSelected()) {
            legendAreaInUnit = this.printDraft.getOverlappingAreaInUnit("map", "legend", this.scale, this.getDrawingUnit());
        }
        double xOrigin = xc + w;
        double yOrigin = yc + h;
        arrRectLegend[0] = new Point2D.Double(xOrigin - legendAreaInUnit.getWidth(), yOrigin);
        arrRectLegend[1] = new Point2D.Double(xOrigin, yOrigin);
        arrRectLegend[2] = new Point2D.Double(xOrigin, yOrigin - legendAreaInUnit.getHeight());
        arrRectLegend[3] = new Point2D.Double(xOrigin - legendAreaInUnit.getWidth(), yOrigin - legendAreaInUnit.getHeight());
        arrRectLegend[4] = new Point2D.Double(xOrigin - legendAreaInUnit.getWidth(), yOrigin);
        Rectangle2D parametersAreaInUnit = new Rectangle2D.Double();
        if (this.cboShowParameters.isSelected()) {
            parametersAreaInUnit = this.printDraft.getOverlappingAreaInUnit("map", "parameters", this.scale, this.getDrawingUnit());
        }
        xOrigin = xc + w;
        yOrigin = yc - h;
        arrRectParameters[0] = new Point2D.Double(xOrigin - parametersAreaInUnit.getWidth(), yOrigin + parametersAreaInUnit.getHeight());
        arrRectParameters[1] = new Point2D.Double(xOrigin, yOrigin + parametersAreaInUnit.getHeight());
        arrRectParameters[2] = new Point2D.Double(xOrigin, yOrigin);
        arrRectParameters[3] = new Point2D.Double(xOrigin - parametersAreaInUnit.getWidth(), yOrigin);
        arrRectParameters[4] = new Point2D.Double(xOrigin - parametersAreaInUnit.getWidth(), yOrigin + parametersAreaInUnit.getHeight());
        arrCorner[0] = new Point2D.Double(xc - w + w * 0.1, yc + h);
        arrCorner[1] = new Point2D.Double(xc - w, yc + h - w * 0.1);
        rotationTransform.transform(arrRectPrintArea, 0, arrRectPrintAreaDest, 0, 5);
        rotationTransform.transform(arrRectLegend, 0, arrRectLegendDest, 0, 5);
        rotationTransform.transform(arrRectParameters, 0, arrRectParametersDest, 0, 5);
        rotationTransform.transform(arrCorner, 0, arrCornerDest, 0, 2);
        Geometry gBorder = this.createPreviewGeometry(arrRectPrintAreaDest, bolArea);
        Geometry lCorner = this.createPreviewGeometry(arrCornerDest, false);
        Geometry gLegend = this.createPreviewGeometry(arrRectLegendDest, true);
        Geometry gParameters = this.createPreviewGeometry(arrRectParametersDest, true);
        Point2D[] arrCross = new Point2D[2];
        Point2D[] arrCrossDest = new Point2D[2];
        arrCross[0] = new Point2D.Double(xc, yc - w / 15.0);
        arrCross[1] = new Point2D.Double(xc, yc + w / 15.0);
        rotationTransform.transform(arrCross, 0, arrCrossDest, 0, 2);
        Geometry lineVert = this.createPreviewGeometry(arrCrossDest, false);
        arrCross[0] = new Point2D.Double(xc - w / 15.0, yc);
        arrCross[1] = new Point2D.Double(xc + w / 15.0, yc);
        rotationTransform.transform(arrCross, 0, arrCrossDest, 0, 2);
        Geometry lineHor = this.createPreviewGeometry(arrCrossDest, false);
        GeometryCollection gcol = new GeometryCollection(new Geometry[]{gBorder, lCorner, gLegend, gParameters, lineVert, lineHor}, this.gfac);
        return gcol;
    }

    private Geometry createPreviewGeometry(Point2D[] arrPoints, boolean bolArea) {
        CoordinateList lstCoord = new CoordinateList();
        for (Point2D currPoint : arrPoints) {
            Coordinate coordTemp = new Coordinate(currPoint.getX(), currPoint.getY());
            lstCoord.add(coordTemp, false);
        }
        CoordinateSequence seqCoord = this.gfac.getCoordinateSequenceFactory().create(lstCoord.toCoordinateArray());
        Object geom = bolArea ? (seqCoord.size() < 4 ? this.gfac.createPoint((Coordinate)null) : this.gfac.createPolygon(new LinearRing(seqCoord, this.gfac), null)) : (seqCoord.size() < 2 ? this.gfac.createPoint((Coordinate)null) : new LineString(seqCoord, this.gfac));
        return geom;
    }

    private void drawPreview() {
        this.drawPreview(true);
    }

    private void drawPreview(boolean bolZoom) {
        Viewport vp = this.context.getLayerViewPanel().getViewport();
        GeometryCollection geom = this.getPreview(false);
        if (this.lstPrintedRegions.size() > 0 && this.bolShowPrintedRegions) {
            GeometryCollection geomRegions = new GeometryCollection(this.lstPrintedRegions.toArray(new Geometry[this.lstPrintedRegions.size()]), this.gfac);
            GenericOverlayFeature fRegions = new GenericOverlayFeature((Geometry)geomRegions, (Stroke)new BasicStroke(2.0f), Color.GREEN, (Stroke)new BasicStroke(), GUIUtil.alphaColor(Color.GREEN, 100));
            GenericOverlayPlugin.addFeature(BLACKBOARD_PRINTED_REGIONS, fRegions);
        } else {
            GenericOverlayPlugin.removeFeature(BLACKBOARD_PRINTED_REGIONS);
        }
        GenericOverlayFeature fPreview = new GenericOverlayFeature((Geometry)geom, (Stroke)new BasicStroke(2.0f), Color.BLACK, (Stroke)new BasicStroke(1.0f), GUIUtil.alphaColor(Color.WHITE, 150));
        GenericOverlayPlugin.addFeature(PRINT_PREVIEW, fPreview);
        if (bolZoom) {
            try {
                Envelope env = new Envelope(geom.getEnvelopeInternal());
                env.expandBy((env.getMaxX() - env.getMinX()) * 0.1, (env.getMaxX() - env.getMinX()) * 0.1);
                vp.zoom(env);
            }
            catch (Exception e) {
                LOG.error("Error zooming print preview", (Throwable)e);
            }
        } else {
            this.context.getLayerViewPanel().copyTo();
        }
    }

    private void removePreview() {
        GenericOverlayPlugin.removeFeature(PRINT_PREVIEW);
        GenericOverlayPlugin.removeFeature(BLACKBOARD_PRINTED_REGIONS);
        this.context.getLayerViewPanel().copyTo();
    }

    private Map<String, Object> getParameters() {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        for (int rowIdx = 0; rowIdx < this.tblParameter.getRowCount(); ++rowIdx) {
            String strKey = ObjectUtils.toString((Object)this.tblParameter.getValueAt(rowIdx, 0));
            String strValue = ObjectUtils.toString((Object)this.tblParameter.getValueAt(rowIdx, 1), (String)"");
            for (Map.Entry<String, String> specialTreatmentParamEntry : specialTreatmentParameters.entrySet()) {
                if (!StringUtils.equals((CharSequence)strKey, (CharSequence)specialTreatmentParamEntry.getValue())) continue;
                strKey = specialTreatmentParamEntry.getKey();
            }
            mapParam.put("JUMP_" + strKey, strValue);
        }
        try {
            if (JUMPWorkbench.GIS_CONTEXT != null) {
                if (this.cmbLogo.isEnabled() && this.cmbLogo.getSelectedIndex() > 0) {
                    File logoFile = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFile("logo", this.cmbLogo.getSelectedItem().toString());
                    mapParam.put("MAP_LOGO", logoFile.toString());
                }
                mapParam.putAll(JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo());
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
        mapParam.put("JUMP_SHOW_PARAMETERS", this.cboShowParameters.isSelected());
        mapParam.put("MAP_SHOW_LEGEND", this.cboShowLegend.isSelected());
        return mapParam;
    }

    public void updateParameters() {
        Object[] arrColums = new String[]{I18N.get("ui.plugin.print.PrintDialog.tblparameter"), I18N.get("ui.plugin.print.PrintDialog.tblvalue")};
        this.tblParameter.removeAll();
        if (this.printDraft != null) {
            Map<String, Map<String, String>> mapParameter = this.printDraft.getJumpParameters();
            if (mapParameter.containsKey("JUMP_SHOW_PARAMETERS")) {
                this.cboShowParameters.setEnabled(true);
            } else {
                this.cboShowParameters.setEnabled(false);
                this.cboShowParameters.setSelected(true);
            }
            ArrayList<Object> lstParameter = new ArrayList<Object>();
            for (String strParameter : mapParameter.keySet()) {
                Map mapUser;
                String[] arrRow = new String[2];
                if (!strParameter.startsWith("JUMP_")) continue;
                arrRow[0] = strParameter.substring(5);
                Map<String, String> map = mapParameter.get(strParameter);
                if (map.containsKey("defaultvalue")) {
                    arrRow[1] = ObjectUtils.toString((Object)map.get("defaultvalue"));
                }
                if (((String)arrRow[0]).equals("SHOW_PARAMETERS")) continue;
                if (((String)arrRow[0]).equals("PRINT_DATE")) {
                    arrRow[0] = I18N.get("ui.plugin.print.PrintDialog.print-date");
                    arrRow[1] = DateSupport.toString((Date)new Date());
                    lstParameter.add(0, arrRow);
                    continue;
                }
                if (((String)arrRow[0]).equals("PRINT_USER_COMPANY")) {
                    arrRow[0] = I18N.get("ui.plugin.print.PrintDialog.print-user-company");
                    if (JUMPWorkbench.GIS_CONTEXT != null) {
                        try {
                            mapUser = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo();
                            arrRow[1] = ObjectUtils.toString(mapUser.get("usr_company")).trim();
                        }
                        catch (Exception ex) {
                            LOG.warn("Error setting company on print: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                if (((String)arrRow[0]).equals("PRINT_USER")) {
                    arrRow[0] = I18N.get("ui.plugin.print.PrintDialog.print-user");
                    if (JUMPWorkbench.GIS_CONTEXT != null) {
                        try {
                            mapUser = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo();
                            String strUserName = ObjectUtils.toString(mapUser.get("usr_first_name")) + " " + ObjectUtils.toString(mapUser.get("usr_name"));
                            String strDep = ObjectUtils.toString(mapUser.get("dep_name")).trim();
                            if (StringUtils.isNotBlank((CharSequence)strDep)) {
                                strUserName = strUserName + ", " + strDep;
                            }
                            arrRow[1] = strUserName;
                        }
                        catch (Exception ex) {
                            LOG.warn("Error setting user on print: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    lstParameter.add(0, arrRow);
                    continue;
                }
                lstParameter.add(arrRow);
            }
            Object[][] arrParameter = new String[lstParameter.size()][arrColums.length];
            int counter = 0;
            for (String[] stringArray : lstParameter) {
                arrParameter[counter][0] = stringArray[0];
                arrParameter[counter][1] = stringArray[1];
                ++counter;
            }
            DefaultTableModel tblModel = new DefaultTableModel(arrParameter, arrColums){
                private final String strParameterColumn;
                {
                    this.strParameterColumn = I18N.get("ui.plugin.print.PrintDialog.tblparameter");
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    String strName = this.getColumnName(column);
                    return !strName.equals(this.strParameterColumn);
                }
            };
            this.tblParameter.setModel(tblModel);
            TableColumn tableColumn = this.tblParameter.getColumn(arrColums[0]);
            DefaultTableCellRenderer colRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lbl = new JLabel((String)value);
                    lbl.setFont(lbl.getFont().deriveFont(1));
                    if (!table.isEnabled()) {
                        lbl.setForeground(Color.GRAY);
                    }
                    return lbl;
                }
            };
            tableColumn.setCellRenderer(colRenderer);
            TableColumn tblColValue = this.tblParameter.getColumn(arrColums[1]);
            tblColValue.setCellEditor(new AreaTableCellEditor(this.printDraft.getJumpParameters()));
            DefaultTableCellRenderer colValueRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lbl = new JLabel((String)value);
                    if (table.getRowHeight(row) != 20) {
                        table.setRowHeight(row, 20);
                    }
                    return lbl;
                }
            };
            tblColValue.setCellRenderer(colValueRenderer);
        }
    }

    @Override
    public void deactivate() {
    }

    public void stopTableCellEditing() {
        if (this.tblParameter.getCellEditor() != null) {
            this.tblParameter.getCellEditor().stopCellEditing();
        }
    }

    public void closePrint(boolean bolcancel) {
        this.removePreview();
        this.setActive(false);
        this.setVisible(false);
        if (this.oldCursorTool != null) {
            this.context.getLayerViewPanel().setCurrentCursorTool(this.oldCursorTool);
            this.oldCursorTool = null;
        }
        this.stopTableCellEditing();
        this.pBB.put(PBB_PRINTED_REGIONS, this.bolShowPrintedRegions);
        this.pBB.put(PBB_SHOW_LEGEND, this.cboShowLegend.isSelected());
        this.pBB.put(PBB_SHOW_PARAMETERS, this.cboShowParameters.isSelected());
        this.pBB.put(PBB_SHOW_SCALEBAR, this.cboShowScaleBar.isSelected());
        this.pBB.put(PBB_PRINT_QUALITY, this.printQuality);
        List lstLegsSel = ((ListListModel)this.lstLegendsSelected.getModel()).getList();
        if (!lstLegsSel.isEmpty()) {
            ArrayList<String> lstLegsSelNames = new ArrayList<String>();
            for (LegendModel legSel : lstLegsSel) {
                lstLegsSelNames.add(legSel.getName());
            }
            this.pBB.put(PBB_LEGENDS, lstLegsSelNames);
        } else {
            this.pBB.remove(PBB_LEGENDS);
        }
        if (!bolcancel) {
            this.printDraft.setShowScaleBar(this.cboShowScaleBar.isSelected());
            Envelope env = this.getPreview(false).getEnvelopeInternal();
            PrintThread printThread = new PrintThread(this.scale, this.orientation, env, this.printDraft, this.getParameters(), this.context.getWorkbenchContext());
            printThread.setPrintQuality(this.printQuality);
            if (this.cboShowLegend.isEnabled() && this.cboShowLegend.isSelected() && !lstLegsSel.isEmpty()) {
                printThread.setLegend(lstLegsSel);
            }
            final GeneratePrintDialog genPrint = new GeneratePrintDialog((Frame)this.owner, this.context, printThread);
            GUIUtil.centreOnScreen(genPrint);
            GeometryCollection gRegion = this.getPreview(true);
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ Geometry val$gRegion;
                {
                    this.val$gRegion = geometry;
                }

                @Override
                public void run() {
                    genPrint.setVisible(true);
                    PrintDialog.this.lstPrintedRegions.add(this.val$gRegion);
                }
            });
        }
    }

    private void setCenter(double rotation, double left, double up) {
        Coordinate centerOld = this.getCenter();
        AffineTransform trans = AffineTransform.getRotateInstance(Math.toRadians(rotation), centerOld.x, centerOld.y);
        trans.translate(left, up);
        double[] arrCenterOld = new double[]{centerOld.x, centerOld.y};
        double[] arrCenterNew = new double[2];
        trans.transform(arrCenterOld, 0, arrCenterNew, 0, 1);
        Coordinate centerNew = new Coordinate();
        centerNew.x = arrCenterNew[0];
        centerNew.y = arrCenterNew[1];
        this.setCenter(centerNew);
    }

    private void deleteParameterDraft(String strName) {
        this.mapParamDrafts.remove(strName);
        this.parameterModel.removeListObject((Object)strName);
        PersistentBlackboardPlugIn.get().put(PBB_DRAFTS, new HashMap<String, Object>(this.mapParamDrafts));
        PersistentBlackboardPlugIn.saveState();
    }

    private void updateParameterDraft(String strName) {
        Map<String, Object> mapParam = this.getParameters();
        LinkedHashSet<String> lst2remove = new LinkedHashSet<String>();
        for (String mapParamKey : mapParam.keySet()) {
            if (!mapParamKey.startsWith("JUMP")) {
                lst2remove.add(mapParamKey);
            }
            if (!mapParamKey.equals("JUMP_PRINT_DATE")) continue;
            lst2remove.add(mapParamKey);
        }
        for (String removeKey : lst2remove) {
            mapParam.remove(removeKey);
        }
        this.mapParamDrafts.put(strName, mapParam);
        PersistentBlackboardPlugIn.get().put(PBB_DRAFTS, new HashMap<String, Object>(this.mapParamDrafts));
        PersistentBlackboardPlugIn.saveState();
    }

    void setPrintDraft(PrintDraft printDraft) {
        this.printDraft = printDraft;
    }

    private void initComponents() {
        this.lblDraft = new JLabel();
        this.butChooseDraft = new JButton();
        this.lblScale = new JLabel();
        this.lblWidth = new JLabel();
        this.lblHeight = new JLabel();
        this.cboScale = new JComboBox();
        this.lblDraftName = new JLabel();
        this.txtWidth = new JFormattedTextField();
        this.txtHeight = new JFormattedTextField();
        this.pnlOkCancel = new JPanel();
        this.butPrint = new JButton();
        this.butCancel = new JButton();
        this.lblLogo = new JLabel();
        this.cmbLogo = new JComboBox();
        this.tabPane = new JTabbedPane();
        this.pnlParameter = new JPanel();
        this.jPanel1 = new JPanel();
        this.butInsert = new JButton();
        this.butUpdate = new JButton();
        this.butDelete = new JButton();
        this.cmbParameter = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.tblParameter = new JTable();
        this.cboShowScaleBar = new JCheckBox();
        this.cboShowParameters = new JCheckBox();
        this.pnlLegend = new JPanel();
        this.butLegendManager = new JButton();
        this.cboShowLegend = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.lstLegends = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.lstLegendsSelected = new JList();
        this.butLegendDown = new JButton();
        this.butLegendAdd = new JButton();
        this.butLegendRemove = new JButton();
        this.butLegendUp = new JButton();
        this.pnlPosition = new JPanel();
        this.butChoosOri = new JButton();
        this.butChooseRegion = new JButton();
        this.butChooseCenter = new JButton();
        this.txtOrientation = new JFormattedTextField();
        this.lblDegree = new JLabel();
        this.pnlCenter = new JPanel();
        this.butLeft = new JButton();
        this.butUp = new JButton();
        this.butRight = new JButton();
        this.butDown = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.cmbQuality = new JComboBox();
        this.lblQuality = new JLabel();
        this.jPanel2 = new JPanel();
        this.cboShowPrintedRegions = new JCheckBox();
        this.butResetPrintedRegions = new JButton();
        this.jSeparator6 = new JSeparator();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrintDialog.this.this_onMouseClicked(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                PrintDialog.this.this_windowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblDraft.setHorizontalAlignment(4);
        this.lblDraft.setText("Vorlage:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblDraft, gridBagConstraints);
        this.butChooseDraft.setText("...");
        this.butChooseDraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butChooseDraft_onClick(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.getContentPane().add((Component)this.butChooseDraft, gridBagConstraints);
        this.lblScale.setHorizontalAlignment(4);
        this.lblScale.setText("Ma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblScale, gridBagConstraints);
        this.lblWidth.setHorizontalAlignment(4);
        this.lblWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblWidth, gridBagConstraints);
        this.lblHeight.setHorizontalAlignment(4);
        this.lblHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblHeight, gridBagConstraints);
        this.cboScale.setEditable(true);
        this.cboScale.setModel(new DefaultComboBoxModel<String>(new String[]{"1 : 100", "1 : 250", "1 : 500", "1 : 1000", "1 : 2500", "1 : 5000", "1 : 10000", "1 : 25000", "1 : 50000", "1 : 100000", "1 : 250000", "1 : 500000"}));
        this.cboScale.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PrintDialog.this.cboScale_onFocusLost(evt);
            }
        });
        this.cboScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cboScale_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cboScale, gridBagConstraints);
        this.lblDraftName.setBackground(new Color(255, 255, 255));
        this.lblDraftName.setFont(this.lblDraftName.getFont().deriveFont(this.lblDraftName.getFont().getStyle() | 1, this.lblDraftName.getFont().getSize() + 1));
        this.lblDraftName.setText("draftName");
        this.lblDraftName.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
        this.lblDraftName.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblDraftName, gridBagConstraints);
        this.txtWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PrintDialog.this.txtWidth_onFocusLost(evt);
            }
        });
        this.txtWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintDialog.this.txtWidth_onKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.txtWidth, gridBagConstraints);
        this.txtHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PrintDialog.this.txtHeight_onFocusLost(evt);
            }
        });
        this.txtHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PrintDialog.this.txtHeight_onKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.txtHeight, gridBagConstraints);
        this.butPrint.setText("drucken");
        this.butPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butPrint_onClick(evt);
            }
        });
        this.pnlOkCancel.add(this.butPrint);
        this.butCancel.setText("abbrechen");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butCancel_onClick(evt);
            }
        });
        this.pnlOkCancel.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.pnlOkCancel, gridBagConstraints);
        this.lblLogo.setHorizontalAlignment(4);
        this.lblLogo.setText("Logo:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblLogo, gridBagConstraints);
        this.cmbLogo.setModel((ComboBoxModel<String>)this.logoModel);
        this.cmbLogo.setEnabled(false);
        this.cmbLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cmbLogo_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbLogo, gridBagConstraints);
        this.tabPane.setName("");
        this.pnlParameter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pnlParameter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrintDialog.this.pnlParameter_onMouseClicked(evt);
            }
        });
        this.pnlParameter.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 23));
        this.jPanel1.setPreferredSize(new Dimension(280, 23));
        this.jPanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrintDialog.this.jPanel1_onMouseClicked(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.butInsert.setMaximumSize(new Dimension(22, 22));
        this.butInsert.setMinimumSize(new Dimension(22, 22));
        this.butInsert.setPreferredSize(new Dimension(22, 22));
        this.butInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butInsert_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.butInsert, gridBagConstraints);
        this.butUpdate.setMaximumSize(new Dimension(22, 22));
        this.butUpdate.setMinimumSize(new Dimension(22, 22));
        this.butUpdate.setPreferredSize(new Dimension(22, 22));
        this.butUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butUpdate_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.butUpdate, gridBagConstraints);
        this.butDelete.setMaximumSize(new Dimension(22, 22));
        this.butDelete.setMinimumSize(new Dimension(22, 22));
        this.butDelete.setPreferredSize(new Dimension(22, 22));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butDelete_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.butDelete, gridBagConstraints);
        this.cmbParameter.setModel((ComboBoxModel<String>)this.parameterModel);
        this.cmbParameter.setPreferredSize(new Dimension(130, 22));
        this.cmbParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cmbParameter_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add(this.cmbParameter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 1, 3);
        this.pnlParameter.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.tblParameter.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter", "Wert"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblParameter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PrintDialog.this.tblParameter_onFocusGained(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tblParameter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlParameter.add((Component)this.jScrollPane2, gridBagConstraints);
        this.cboShowScaleBar.setText("Ma\u00dfstabsbalken anzeigen");
        this.cboShowScaleBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboShowScaleBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cboShowScaleBarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlParameter.add((Component)this.cboShowScaleBar, gridBagConstraints);
        this.cboShowParameters.setText("Stempelfeld anzeigen");
        this.cboShowParameters.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboShowParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cboShowParametersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.pnlParameter.add((Component)this.cboShowParameters, gridBagConstraints);
        this.tabPane.addTab("Stempelfeld", this.pnlParameter);
        this.pnlLegend.setLayout(new GridBagLayout());
        this.butLegendManager.setText("...");
        this.butLegendManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butLegendManagerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.butLegendManager, gridBagConstraints);
        this.cboShowLegend.setText("Legende anzeigen");
        this.cboShowLegend.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cboShowLegendActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlLegend.add((Component)this.cboShowLegend, gridBagConstraints);
        this.lstLegends.setModel((ListModel<LegendModel>)this.legendsAvailableModel);
        this.lstLegends.setDragEnabled(true);
        this.lstLegends.setDropMode(DropMode.INSERT);
        this.lstLegends.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrintDialog.this.lstLegendsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstLegends);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lstLegendsSelected.setModel((ListModel<LegendModel>)this.legendsSelectedModel);
        this.lstLegendsSelected.setDragEnabled(true);
        this.lstLegendsSelected.setDropMode(DropMode.INSERT);
        this.lstLegendsSelected.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrintDialog.this.lstLegendsSelectedMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstLegendsSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.jScrollPane3, gridBagConstraints);
        this.butLegendDown.setText("down");
        this.butLegendDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butLegendDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.butLegendDown, gridBagConstraints);
        this.butLegendAdd.setText(">");
        this.butLegendAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butLegendAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.butLegendAdd, gridBagConstraints);
        this.butLegendRemove.setText("<");
        this.butLegendRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butLegendRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.butLegendRemove, gridBagConstraints);
        this.butLegendUp.setText("up");
        this.butLegendUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butLegendUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegend.add((Component)this.butLegendUp, gridBagConstraints);
        this.tabPane.addTab("Legende", this.pnlLegend);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.pnlPosition.setLayout(new GridBagLayout());
        this.butChoosOri.setText("Ausrichtung...");
        this.butChoosOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butChoosOri_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.pnlPosition.add((Component)this.butChoosOri, gridBagConstraints);
        this.butChooseRegion.setText("Bereich...");
        this.butChooseRegion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butChooseRegion_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.pnlPosition.add((Component)this.butChooseRegion, gridBagConstraints);
        this.butChooseCenter.setText("Bildmitte...");
        this.butChooseCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butChooseCenter_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.pnlPosition.add((Component)this.butChooseCenter, gridBagConstraints);
        this.txtOrientation.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PrintDialog.this.txtOrientation_onFocusLost(evt);
            }
        });
        this.txtOrientation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PrintDialog.this.txtOrientation_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPosition.add((Component)this.txtOrientation, gridBagConstraints);
        this.lblDegree.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPosition.add((Component)this.lblDegree, gridBagConstraints);
        this.pnlCenter.setLayout(new GridBagLayout());
        this.butLeft.setMinimumSize(new Dimension(26, 26));
        this.butLeft.setPreferredSize(new Dimension(26, 26));
        this.butLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butLeft_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        this.pnlCenter.add((Component)this.butLeft, gridBagConstraints);
        this.butUp.setMinimumSize(new Dimension(26, 26));
        this.butUp.setPreferredSize(new Dimension(26, 26));
        this.butUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butUp_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.pnlCenter.add((Component)this.butUp, gridBagConstraints);
        this.butRight.setMinimumSize(new Dimension(26, 26));
        this.butRight.setPreferredSize(new Dimension(26, 26));
        this.butRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butRight_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        this.pnlCenter.add((Component)this.butRight, gridBagConstraints);
        this.butDown.setMinimumSize(new Dimension(26, 26));
        this.butDown.setPreferredSize(new Dimension(26, 26));
        this.butDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butDown_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.pnlCenter.add((Component)this.butDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlPosition.add((Component)this.pnlCenter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlPosition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator5, gridBagConstraints);
        this.cmbQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cmbQuality_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbQuality, gridBagConstraints);
        this.lblQuality.setHorizontalAlignment(4);
        this.lblQuality.setText("Qualit\u00e4t:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.getContentPane().add((Component)this.lblQuality, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.cboShowPrintedRegions.setText("bisher gedruckte Bereiche");
        this.cboShowPrintedRegions.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboShowPrintedRegions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.cboShowPrintedRegions_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.jPanel2.add((Component)this.cboShowPrintedRegions, gridBagConstraints);
        this.butResetPrintedRegions.setText(" l\u00f6schen");
        this.butResetPrintedRegions.setMinimumSize(new Dimension(81, 23));
        this.butResetPrintedRegions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.butResetPrintedRegions_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 6);
        this.jPanel2.add((Component)this.butResetPrintedRegions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator6, gridBagConstraints);
    }

    private void txtOrientation_onKeyReleased(KeyEvent evt) {
        try {
            this.orientation = this.df.parse(this.txtOrientation.getText()).intValue();
        }
        catch (Exception e) {
            LOG.error("Error parsing number for orientation", (Throwable)e);
        }
    }

    private void butRight_onActionPerformed(ActionEvent evt) {
        Dimension2D d = this.printDraft.getPrintAreaInUnit("map", this.scale, this.getDrawingUnit());
        this.setCenter(this.orientation, d.getWidth(), 0.0);
    }

    private void butDown_onActionPerformed(ActionEvent evt) {
        Dimension2D d = this.printDraft.getPrintAreaInUnit("map", this.scale, this.getDrawingUnit());
        this.setCenter(this.orientation, 0.0, -d.getHeight());
    }

    private void butLeft_onActionPerformed(ActionEvent evt) {
        Dimension2D d = this.printDraft.getPrintAreaInUnit("map", this.scale, this.getDrawingUnit());
        this.setCenter(this.orientation, -d.getWidth(), 0.0);
    }

    private void cmbQuality_onActionPerformed(ActionEvent evt) {
        switch (this.cmbQuality.getSelectedIndex()) {
            case 0: {
                this.printQuality = 1.33f;
                break;
            }
            case 1: {
                this.printQuality = 1.66f;
                break;
            }
            case 2: {
                this.printQuality = 2.5f;
                break;
            }
            case 3: {
                this.printQuality = 4.16f;
            }
        }
    }

    private void publishPrintQuality2CmbQuality() {
        if (this.printQuality >= 4.1499996f) {
            this.cmbQuality.setSelectedIndex(3);
        } else if (this.printQuality >= 2.49f) {
            this.cmbQuality.setSelectedIndex(2);
        } else if (this.printQuality >= 1.65f) {
            this.cmbQuality.setSelectedIndex(1);
        } else {
            this.cmbQuality.setSelectedIndex(0);
        }
    }

    private void butUp_onActionPerformed(ActionEvent evt) {
        Dimension2D d = this.printDraft.getPrintAreaInUnit("map", this.scale, this.getDrawingUnit());
        this.setCenter(this.orientation, 0.0, d.getHeight());
    }

    private void butChooseCenter_onActionPerformed(ActionEvent evt) {
        CursorTool tempCursor = this.context.getLayerViewPanel().getCurrentCursorTool();
        if (this.oldCursorTool == null) {
            this.oldCursorTool = tempCursor;
        }
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.centerTool);
        this.context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
        WorkbenchContext.getFrame().requestFocus();
    }

    private void cboScale_onActionPerformed(ActionEvent evt) {
        String strScale = (String)this.cboScale.getSelectedItem();
        String[] arrScale = strScale.split("\\:");
        if (arrScale.length > 2) {
            this.scale = 1000.0;
            this.updateComponents();
        }
        if (arrScale.length == 2) {
            strScale = arrScale[1];
        }
        if (arrScale.length == 1) {
            strScale = arrScale[0];
        }
        try {
            this.scale = this.df.parse(strScale.trim()).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateComponents();
    }

    private void cboScale_onFocusLost(FocusEvent evt) {
    }

    private void txtOrientation_onFocusLost(FocusEvent evt) {
        try {
            this.orientation = this.df.parse(this.txtOrientation.getText()).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateComponents();
    }

    private void txtHeight_onFocusLost(FocusEvent evt) {
        try {
            double printAreaHeight = this.printDraft.getPrintAreaInPt("map").getHeight();
            this.scale = PrintDraftUtils.calcScale(printAreaHeight, this.df.parse(this.txtHeight.getText()).doubleValue(), this.getDrawingUnit());
        }
        catch (Exception e) {
            LOG.error("Error computing scale by height.", (Throwable)e);
        }
        this.updateComponents();
    }

    private void txtWidth_onFocusLost(FocusEvent evt) {
        try {
            double printAreaHeight = this.printDraft.getPrintAreaInPt("map").getHeight();
            this.scale = PrintDraftUtils.calcScale(printAreaHeight, this.df.parse(this.txtWidth.getText()).doubleValue(), this.getDrawingUnit());
        }
        catch (Exception e) {
            LOG.error("Error computing scale by width.", (Throwable)e);
        }
        this.updateComponents();
    }

    private void butChooseDraft_onClick(ActionEvent evt) {
        ChooseDraftDialog dlgDraft = new ChooseDraftDialog(this, this.context);
        GUIUtil.centreOnScreen(dlgDraft);
        dlgDraft.setVisible(true);
        PrintDraft tmpDraft = dlgDraft.getDraft();
        if (tmpDraft == null) {
            return;
        }
        this.printDraft = tmpDraft;
        this.updateParameters();
        this.updateComponents();
        dlgDraft.dispose();
    }

    private void butPrint_onClick(ActionEvent evt) {
        this.closePrint(false);
    }

    private void butCancel_onClick(ActionEvent evt) {
        this.closePrint(true);
    }

    private void butChooseRegion_onActionPerformed(ActionEvent evt) {
        CursorTool tempCursor = this.context.getLayerViewPanel().getCurrentCursorTool();
        if (this.oldCursorTool == null) {
            this.oldCursorTool = tempCursor;
        }
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.regionTool);
        this.context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
        WorkbenchContext.getFrame().requestFocus();
    }

    private void butInsert_onActionPerformed(ActionEvent evt) {
        try {
            this.stopTableCellEditing();
            String strName = GUISupport.inputbox((Component)this, (String)I18N.get("ui.plugin.print.PrintDialog.new-draft-message"));
            if (StringUtils.isNotBlank((CharSequence)strName)) {
                if (this.mapParamDrafts.containsKey(strName)) {
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.plugin.print.PrintDialog.parameter-draft-already-exists"), (String)I18N.get("common.error"));
                } else {
                    this.updateParameterDraft(strName);
                    this.parameterModel.addListObject((Object)strName);
                    this.cmbParameter.setSelectedItem(strName);
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        try {
            this.stopTableCellEditing();
            if (this.cmbParameter.getSelectedItem() == null) {
                return;
            }
            boolean bolDelete = GUISupport.yesnobox((Component)this, (String)I18N.get("ui.plugin.print.PrintDialog.delete-draft-question"), (String)I18N.get("common.message"));
            if (!bolDelete) {
                return;
            }
            this.deleteParameterDraft(this.cmbParameter.getSelectedItem().toString());
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void cmbParameter_onActionPerformed(ActionEvent evt) {
        try {
            this.stopTableCellEditing();
            if (this.cmbParameter.getSelectedItem() == null) {
                return;
            }
            String strName = this.cmbParameter.getSelectedItem().toString();
            Map mapParam = (Map)this.mapParamDrafts.get(strName);
            TableModel tblModel = this.tblParameter.getModel();
            for (String strParamName : mapParam.keySet()) {
                for (int i = 0; i < tblModel.getRowCount(); ++i) {
                    String strParamNameTbl = (String)tblModel.getValueAt(i, 0);
                    boolean specialTreatmentDone = false;
                    for (String specialTreatmentParamName : specialTreatmentParameters.keySet()) {
                        if (!StringUtils.equals((CharSequence)("JUMP_" + specialTreatmentParamName), (CharSequence)strParamName)) continue;
                        specialTreatmentDone = true;
                        if (!StringUtils.equals((CharSequence)specialTreatmentParameters.get(specialTreatmentParamName), (CharSequence)strParamNameTbl)) continue;
                        tblModel.setValueAt(mapParam.get(strParamName), i, 1);
                    }
                    if (specialTreatmentDone || !strParamName.equals("JUMP_" + strParamNameTbl)) continue;
                    tblModel.setValueAt(mapParam.get(strParamName), i, 1);
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void pnlParameter_onMouseClicked(MouseEvent evt) {
        this.stopTableCellEditing();
    }

    private void jPanel1_onMouseClicked(MouseEvent evt) {
        this.stopTableCellEditing();
    }

    private void this_onMouseClicked(MouseEvent evt) {
        this.stopTableCellEditing();
    }

    private void tblParameter_onFocusGained(FocusEvent evt) {
    }

    private void butUpdate_onActionPerformed(ActionEvent evt) {
        this.stopTableCellEditing();
        if (this.cmbParameter.getSelectedItem() != null) {
            String strName = this.cmbParameter.getSelectedItem().toString();
            if (!this.mapParamDrafts.containsKey(strName)) {
                LOG.warn("Given print draft for update does not exist.");
            } else {
                this.updateParameterDraft(strName);
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.print.PrintDialog.draft-updated"), (String)I18N.get("common.message"));
            }
        }
    }

    private void cboShowParametersActionPerformed(ActionEvent evt) {
        this.stopTableCellEditing();
        this.updateComponents();
    }

    private void cboShowScaleBarActionPerformed(ActionEvent evt) {
    }

    private void butChoosOri_onActionPerformed(ActionEvent evt) {
        CursorTool tempCursor = this.context.getLayerViewPanel().getCurrentCursorTool();
        if (this.oldCursorTool == null) {
            this.oldCursorTool = tempCursor;
        }
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.oriTool);
        this.context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
        WorkbenchContext.getFrame().requestFocus();
    }

    private void butResetPrintedRegions_onActionPerformed(ActionEvent evt) {
        this.lstPrintedRegions.clear();
        this.drawPreview(false);
    }

    private void cboShowPrintedRegions_onActionPerformed(ActionEvent evt) {
        this.bolShowPrintedRegions = this.cboShowPrintedRegions.isSelected();
        this.drawPreview(false);
    }

    private void txtHeight_onKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                double printAreaHeight = this.printDraft.getPrintAreaInPt("map").getHeight();
                this.scale = PrintDraftUtils.calcScale(printAreaHeight, this.df.parse(this.txtHeight.getText()).doubleValue(), this.getDrawingUnit());
            }
            catch (Exception e) {
                LOG.error("Error computing scale by height.", (Throwable)e);
            }
        }
    }

    private void txtWidth_onKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                double printAreaWidth = this.printDraft.getPrintAreaInPt("map").getWidth();
                this.scale = PrintDraftUtils.calcScale(printAreaWidth, this.df.parse(this.txtWidth.getText()).doubleValue(), this.getDrawingUnit());
            }
            catch (Exception e) {
                LOG.error("Error computing scale by width.", (Throwable)e);
            }
        }
    }

    private void cmbLogo_onActionPerformed(ActionEvent evt) {
        this.pBB.put(PBB_LOGO, this.cmbLogo.getSelectedIndex());
    }

    private void this_windowGainedFocus(WindowEvent evt) {
        WorkbenchContext.getFrame().activateDefaultCT();
    }

    private void cboShowLegendActionPerformed(ActionEvent evt) {
        this.updateComponents();
    }

    private void butLegendManagerActionPerformed(ActionEvent evt) {
        LegendManagerDialog dlg = new LegendManagerDialog((Frame)WorkbenchContext.getFrame(), this.context.getTask());
        dlg.setScale(this.scale);
        List lstLegsSel = this.lstLegendsSelected.getSelectedValuesList();
        if (lstLegsSel == null || lstLegsSel.isEmpty()) {
            List tmpLegendModel;
            lstLegsSel = tmpLegendModel = ((ListListModel)this.lstLegendsSelected.getModel()).getList();
        }
        if (!lstLegsSel.isEmpty()) {
            dlg.setLegendModelSelected((LegendModel)lstLegsSel.get(0));
        }
        dlg.setVisible(true);
        List lstLegendsInList = ((ListListModel)this.lstLegendsSelected.getModel()).getList();
        ArrayList<String> lstLegsSelNames = new ArrayList<String>();
        for (LegendModel legInList : lstLegendsInList) {
            lstLegsSelNames.add(legInList.getName());
        }
        this.refillLegendList(lstLegsSelNames);
    }

    private void butLegendAddActionPerformed(ActionEvent evt) {
        List<LegendModel> legs2Select = this.lstLegends.getSelectedValuesList();
        for (LegendModel leg2Sel : legs2Select) {
            ((ListListModel)this.lstLegends.getModel()).removeListObject((Object)leg2Sel);
            ((ListListModel)this.lstLegendsSelected.getModel()).addListObject((Object)leg2Sel);
        }
    }

    private void butLegendRemoveActionPerformed(ActionEvent evt) {
        List<LegendModel> legs2Select = this.lstLegendsSelected.getSelectedValuesList();
        for (LegendModel leg2Sel : legs2Select) {
            ((ListListModel)this.lstLegendsSelected.getModel()).removeListObject((Object)leg2Sel);
            ((ListListModel)this.lstLegends.getModel()).addListObject((Object)leg2Sel);
        }
    }

    private void butLegendUpActionPerformed(ActionEvent evt) {
        int index;
        ListListModel listModel = (ListListModel)this.lstLegendsSelected.getModel();
        int[] arrSelectionIndex = this.lstLegendsSelected.getSelectedIndices();
        if (arrSelectionIndex.length == 0) {
            return;
        }
        List<LegendModel> lstSelection = this.lstLegendsSelected.getSelectedValuesList();
        for (LegendModel entry : lstSelection) {
            listModel.removeListObject((Object)entry);
        }
        Arrays.sort(arrSelectionIndex);
        int indexStart = index = Math.max(0, arrSelectionIndex[0] - 1);
        for (LegendModel entry : lstSelection) {
            listModel.addListObject((Object)entry, index);
            ++index;
        }
        int indexEnd = --index;
        this.lstLegendsSelected.getSelectionModel().addSelectionInterval(indexStart, indexEnd);
    }

    private void butLegendDownActionPerformed(ActionEvent evt) {
        int index;
        ListListModel listModel = (ListListModel)this.lstLegendsSelected.getModel();
        int[] arrSelectionIndex = this.lstLegendsSelected.getSelectedIndices();
        if (arrSelectionIndex.length == 0) {
            return;
        }
        List<LegendModel> lstSelection = this.lstLegendsSelected.getSelectedValuesList();
        for (LegendModel entry : lstSelection) {
            listModel.removeListObject((Object)entry);
        }
        Arrays.sort(arrSelectionIndex);
        int indexStart = index = Math.min(this.lstLegendsSelected.getModel().getSize(), arrSelectionIndex[0] + 1);
        for (LegendModel entry : lstSelection) {
            listModel.addListObject((Object)entry, index);
            ++index;
        }
        int indexEnd = --index;
        this.lstLegendsSelected.getSelectionModel().addSelectionInterval(indexStart, indexEnd);
    }

    private void lstLegendsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butLegendAddActionPerformed(null);
        }
    }

    private void lstLegendsSelectedMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butLegendRemoveActionPerformed(null);
        }
    }

    static {
        specialTreatmentParameters.put("PRINT_USER", I18N.get("ui.plugin.print.PrintDialog.print-user"));
        specialTreatmentParameters.put("PRINT_USER_COMPANY", I18N.get("ui.plugin.print.PrintDialog.print-user-company"));
        specialTreatmentParameters.put("PRINT_DATE", I18N.get("ui.plugin.print.PrintDialog.print-date"));
    }
}

