/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import de.riwagis.util.geom.Dimension2DDouble;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintAreaTile {
    private static final Logger LOG = LoggerFactory.getLogger(PrintAreaTile.class);
    private static final MathContext mathContext = MathContext.DECIMAL64;
    public static final double PRINT_BUFFER = 0.0;
    private final Envelope printLocationPx;
    private final Envelope printEnv;
    private final Point tileIdx;
    private final AffineTransform transformation;

    public PrintAreaTile(Envelope printLocationPx, Envelope printEnv, Point tileIdx, AffineTransform transformation) {
        this.printLocationPx = printLocationPx;
        this.printEnv = printEnv;
        this.tileIdx = tileIdx;
        this.transformation = transformation;
    }

    public Envelope getPrintLocationPx() {
        return this.printLocationPx;
    }

    public Point getTileIdx() {
        return this.tileIdx;
    }

    public Envelope getPrintEnv() {
        return this.printEnv;
    }

    public String toString() {
        return String.format("Tile %f/%f, dimension %.2f/%.2f, env: %.2f/%.2f", this.tileIdx.getX(), this.tileIdx.getY(), this.printLocationPx.getWidth(), this.printLocationPx.getHeight(), this.printEnv.getWidth(), this.printEnv.getHeight());
    }

    public static Collection<PrintAreaTile> tilePrintArea(Dimension2D imageDimPxRotated, Dimension2D imageDimPx, Envelope env, int perTilePx, double printQuality, double orientation) {
        return PrintAreaTile.tilePrintArea(imageDimPxRotated, imageDimPx, env, perTilePx, printQuality, orientation, 0.0);
    }

    public static Collection<PrintAreaTile> tilePrintArea(Dimension2D imageDimPxRotated, Dimension2D imageDimPx, Envelope env, int perTilePx, double printQuality, double orientation, double printBuffer) {
        Dimension2DDouble printAreaPxRotated = new Dimension2DDouble((double)((int)imageDimPxRotated.getWidth()) * printQuality, (double)((int)imageDimPxRotated.getHeight()) * printQuality);
        ArrayList<PrintAreaTile> printAreaTiles = new ArrayList<PrintAreaTile>();
        if (env.getArea() > 0.0) {
            BigDecimal meterPerPixel;
            int tileCountX = (int)Math.ceil(printAreaPxRotated.getWidth() / (double)perTilePx);
            int tileCountY = (int)Math.ceil(printAreaPxRotated.getHeight() / (double)perTilePx);
            BigDecimal meterPerPixelX = BigDecimal.valueOf(env.getHeight()).divide(BigDecimal.valueOf(printAreaPxRotated.getHeight()), mathContext);
            BigDecimal meterPerPixelY = BigDecimal.valueOf(env.getWidth()).divide(BigDecimal.valueOf(printAreaPxRotated.getWidth()), mathContext);
            BigDecimal bigDecimal = meterPerPixel = env.getHeight() > env.getWidth() ? meterPerPixelX : meterPerPixelY;
            if (meterPerPixelX.subtract(meterPerPixelY).abs().doubleValue() > 0.01) {
                LOG.warn(String.format("scale mismatch: %.3f m/px != %.3f m/px", meterPerPixelX, meterPerPixelY));
            }
            BigDecimal minX = BigDecimal.valueOf(env.getMinX());
            BigDecimal minY = BigDecimal.valueOf(env.getMinY());
            double bufferPx = (int)Math.round((double)perTilePx * printBuffer);
            for (int idxX = 0; idxX < tileCountX; ++idxX) {
                for (int idxY = 0; idxY < tileCountY; ++idxY) {
                    Point tileIndex = new Point(idxX, idxY);
                    Envelope printLocationPx = new Envelope(Math.max((double)((idxX + 0) * perTilePx) - bufferPx, 0.0), Math.min((double)((idxX + 1) * perTilePx) + bufferPx, printAreaPxRotated.getWidth()), Math.max((double)((idxY + 0) * perTilePx) - bufferPx, 0.0), Math.min((double)((idxY + 1) * perTilePx) + bufferPx, printAreaPxRotated.getHeight()));
                    Envelope currEnv = new Envelope(minX.add(BigDecimal.valueOf(printLocationPx.getMinX()).multiply(meterPerPixel)).doubleValue(), minX.add(BigDecimal.valueOf(printLocationPx.getMaxX()).multiply(meterPerPixel)).doubleValue(), minY.add(BigDecimal.valueOf(printLocationPx.getMinY()).multiply(meterPerPixel)).doubleValue(), minY.add(BigDecimal.valueOf(printLocationPx.getMaxY()).multiply(meterPerPixel)).doubleValue());
                    if (!PrintAreaTile.isWithin(env, currEnv)) {
                        LOG.warn(String.format("envelope '%s' not within print range '%s'", currEnv, env));
                    }
                    AffineTransform tileTransformation = PrintAreaTile.buildTileTransformation(orientation, imageDimPx, imageDimPxRotated, printLocationPx, printQuality);
                    printAreaTiles.add(new PrintAreaTile(printLocationPx, currEnv, tileIndex, tileTransformation));
                }
            }
        }
        return printAreaTiles;
    }

    public static AffineTransform buildTileTransformation(double orientation, Dimension2D imageDimPx, Dimension2D imageDimPxRotated, Envelope printLocationPx, double printQuality) {
        AffineTransform tr = new AffineTransform();
        Point2D.Double rotationCenter = new Point2D.Double(imageDimPx.getWidth() / 2.0, imageDimPx.getHeight() / 2.0);
        tr.rotate(Math.toRadians(orientation), ((Point2D)rotationCenter).getX(), ((Point2D)rotationCenter).getY());
        Dimension2DDouble offset = new Dimension2DDouble((imageDimPxRotated.getWidth() - imageDimPx.getWidth()) / 2.0, (imageDimPxRotated.getHeight() - imageDimPx.getHeight()) / 2.0);
        tr.translate(-offset.getWidth(), -offset.getHeight());
        tr.scale(1.0 / printQuality, 1.0 / printQuality);
        tr.translate(printLocationPx.getMinX(), imageDimPxRotated.getHeight() * printQuality - printLocationPx.getMaxY());
        return tr;
    }

    public final AffineTransform getTransformation() {
        return this.transformation;
    }

    public static boolean isWithin(Envelope envEnclosing, Envelope envTest) {
        if (envEnclosing == null || envTest == null) {
            return false;
        }
        double deltaWidth = envEnclosing.getWidth() * 1.0E-8;
        double deltaHeight = envEnclosing.getHeight() * 1.0E-8;
        Envelope envMaximum = new Envelope(envEnclosing.getMinX() - deltaWidth, envEnclosing.getMaxX() + deltaWidth, envEnclosing.getMinY() - deltaHeight, envEnclosing.getMaxY() + deltaHeight);
        return envMaximum.covers(envTest);
    }
}

