/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.unit.UnitFactory;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import org.apache.commons.collections4.CollectionUtils;
import org.locationtech.jts.geom.Envelope;

public class JasperReportSupport {
    public static final DrawingUnit DU_METER = UnitFactory.getUnit((String)"meter");
    public static final double JR_DPI = 72.0;
    public static final double DOTS_PER_METER = 72.0 / DU_METER.getInchInUnit();

    public static final FileResolver buildJRFileResolver(List<File> _dir) {
        SimpleFileResolver res = new SimpleFileResolver(_dir);
        res.setResolveAbsolutePath(true);
        return res;
    }

    public static int findMatchingScale(PrintDraft pd, Envelope env, Collection<Integer> allowedScales) {
        return JasperReportSupport.findMatchingScaleUnsorted(pd, env, JasperReportSupport.sortScales(allowedScales));
    }

    public static Collection<Integer> sortScales(Collection<Integer> allowedScales) {
        TreeSet<Integer> internalAllowedScales = new TreeSet<Integer>();
        if (allowedScales != null) {
            internalAllowedScales.addAll(allowedScales);
        }
        return internalAllowedScales;
    }

    public static int findMatchingScaleUnsorted(PrintDraft pd, Envelope env, Collection<Integer> allowedScales) {
        if (env != null) {
            double minScale = pd.determineMaxScaleByDim("map", env.getWidth(), env.getHeight(), DU_METER);
            for (Integer currScale : allowedScales) {
                if (!((double)currScale.intValue() > minScale)) continue;
                return currScale;
            }
        }
        return allowedScales.isEmpty() ? -1 : (Integer)CollectionUtils.get(allowedScales, (int)(allowedScales.size() - 1));
    }

    public static final double calcPtInMeter(double ptValue) {
        return ptValue / DOTS_PER_METER;
    }

    public static final double calcMeterInPt(double meterValue) {
        return meterValue * DOTS_PER_METER;
    }

    private JasperReportSupport() {
    }
}

