/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintThread;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.thread.ThreadUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePrintDialog
extends JDialog {
    private final PlugInContext context;
    private final PrintThread printThread;
    private static final Logger LOG = LoggerFactory.getLogger(GeneratePrintDialog.class);
    private JButton butCancel;
    private JLabel lblIcon;
    private JLabel lblMessage;
    private JLabel lblProgress;

    private GeneratePrintDialog(Window owner, PlugInContext _context, PrintThread _printThread) {
        super(owner, Dialog.DEFAULT_MODALITY_TYPE);
        this.context = _context;
        this.printThread = _printThread;
        this.init();
        this.setSize(350, 130);
    }

    public GeneratePrintDialog(Frame owner, PlugInContext _context, PrintThread _printThread) {
        this((Window)owner, _context, _printThread);
    }

    public GeneratePrintDialog(Dialog owner, PlugInContext _context, PrintThread _printThread) {
        this((Window)owner, _context, _printThread);
    }

    private void init() {
        this.initComponents();
        this.i18n();
        this.lblIcon.setIcon(IconLoader.icon((String)"wait.gif"));
        final String strProgress = I18N.get("ui.plugin.print.GeneratePrintDialog.progress");
        final String strOf = I18N.get("common.of");
        this.printThread.addListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneratePrintDialog.this.setVisible(false);
            }
        });
        this.printThread.addMessageListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] arrProgress = e.getActionCommand().split(",");
                if (arrProgress.length == 3) {
                    GeneratePrintDialog.this.lblProgress.setText("<html>" + arrProgress[0] + "<br>" + strProgress + " " + arrProgress[1] + " " + strOf + " " + arrProgress[2] + "</html>");
                } else {
                    GeneratePrintDialog.this.lblProgress.setText("<html>" + e.getActionCommand() + "</html>");
                }
            }
        });
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.print.GeneratePrintDialog.title"));
        this.lblMessage.setText(I18N.get("ui.plugin.print.GeneratePrintDialog.message"));
        this.butCancel.setText(I18N.get("common.cancel"));
    }

    public void execute() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeneratePrintDialog.this.printThread.start();
            }
        });
    }

    private void initComponents() {
        this.lblIcon = new JLabel();
        this.lblMessage = new JLabel();
        this.lblProgress = new JLabel();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                GeneratePrintDialog.this.this_onWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.lblIcon, gridBagConstraints);
        this.lblMessage.setText("Bitte warten. Ihr Ausdruck wird erzeugt...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblMessage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblProgress, gridBagConstraints);
        this.butCancel.setInheritsPopupMenu(true);
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneratePrintDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        this.pack();
    }

    private void this_onWindowOpened(WindowEvent evt) {
        this.execute();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        if (this.printThread.isInterrupted()) {
            return;
        }
        this.printThread.interrupt();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (int count = 0; !GeneratePrintDialog.this.printThread.isReady() && count <= 1000; ++count) {
                    ThreadUtils.sleepQuietly((long)30L);
                }
                GeneratePrintDialog.this.setVisible(false);
            }
        };
        Thread thInterrupt = new Thread(runner);
        thInterrupt.start();
    }
}

