/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChooseDraftDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ChooseDraftDialog.class);
    public static final String CURRENT_FILE_KEY = String.valueOf(ChooseDraftDialog.class) + " - FILE";
    public static final String LAST_DRAFT_KEY = String.valueOf(ChooseDraftDialog.class) + " - LASTDRAFT";
    private final PlugInContext context;
    private PrintDraft printDraft = null;
    private JButton butCancel;
    private JButton butOpen;
    private JScrollPane jScrollPane1;
    private JLabel lblPrintDraft;
    private JList<String> lstPrintDraft;
    private JPanel pnlDefaultDraft;
    private JFileChooser pnlLocalDraft;
    private JTabbedPane tabPanel;

    public ChooseDraftDialog(JDialog owner, PlugInContext _context) {
        super((Dialog)owner, true);
        this.context = _context;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.print.ChooseDraftDialog.title"));
        this.tabPanel.setTitleAt(0, I18N.get("ui.plugin.print.ChooseDraftDialog.default"));
        this.tabPanel.setTitleAt(1, I18N.get("ui.plugin.print.ChooseDraftDialog.local"));
        this.lblPrintDraft.setText(I18N.get("ui.plugin.print.ChooseDraftDialog.print-drafts"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOpen.setText(I18N.get("common.open"));
    }

    private void init() {
        FileFilter jasperFilter = new FileFilter(this){

            @Override
            public String getDescription() {
                return I18N.get("ui.plugin.print.ChooseDraftDialog.FileFilterName");
            }

            @Override
            public boolean accept(File f) {
                return f.exists() && f.isFile() && f.getName().toLowerCase().endsWith(".jasper") || f.isDirectory();
            }
        };
        this.pnlLocalDraft.setFileFilter(jasperFilter);
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (bb.contains(CURRENT_FILE_KEY)) {
            String strPath = (String)bb.get(CURRENT_FILE_KEY);
            this.pnlLocalDraft.setSelectedFile(new File(strPath));
        }
        this.pnlLocalDraft.setMultiSelectionEnabled(false);
        if (JUMPWorkbench.GIS_CONTEXT == null) {
            this.tabPanel.setEnabledAt(0, false);
            this.tabPanel.setSelectedIndex(1);
        } else {
            try {
                this.tabPanel.setEnabledAt(0, true);
                String[] arrFiles = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFileList("print");
                Arrays.sort(arrFiles, String.CASE_INSENSITIVE_ORDER);
                ArrayList<String> lstFiles = new ArrayList<String>();
                for (String currFilename : arrFiles) {
                    lstFiles.add(FilenameUtils.getBaseName((String)currFilename));
                }
                ListListModel lstModel = new ListListModel(lstFiles);
                this.lstPrintDraft.setModel((ListModel<String>)lstModel);
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
                this.tabPanel.getTabComponentAt(0).setVisible(false);
                this.tabPanel.getTabComponentAt(0).setEnabled(false);
            }
        }
    }

    public PrintDraft getDraft() {
        return this.printDraft;
    }

    public static PrintDraft processDraftFile(File file) throws Exception {
        try {
            return new PrintDraft(file);
        }
        catch (Exception e) {
            WorkbenchContext.getFrame().warnUser(I18N.get("ui.plugin.print.ChooseDraftDialog.error"));
            return null;
        }
    }

    public static File getGisContextDraftFile(String strFileName) throws Exception {
        if (JUMPWorkbench.GIS_CONTEXT != null) {
            return JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFile("print", strFileName);
        }
        LOG.error("ChooseDraftDialog. GIS_CONTEXT is not initialised.");
        return null;
    }

    public static PrintDraft getLastPrintDraft() {
        try {
            String strDraftFile = (String)PersistentBlackboardPlugIn.get().get(LAST_DRAFT_KEY);
            if (strDraftFile == null) {
                return null;
            }
            File draftFile = new File(strDraftFile);
            if (draftFile.exists()) {
                return ChooseDraftDialog.processDraftFile(draftFile);
            }
            if (JUMPWorkbench.GIS_CONTEXT != null) {
                File gcDraftFile = ChooseDraftDialog.getGisContextDraftFile(strDraftFile);
                return ChooseDraftDialog.processDraftFile(gcDraftFile);
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving last PrintDraft.");
            return null;
        }
    }

    public static void removeLastPrintDraft() {
        PersistentBlackboardPlugIn.get().remove(LAST_DRAFT_KEY);
    }

    private void initComponents() {
        this.tabPanel = new JTabbedPane();
        this.pnlDefaultDraft = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstPrintDraft = new JList();
        this.lblPrintDraft = new JLabel();
        this.butCancel = new JButton();
        this.butOpen = new JButton();
        this.pnlLocalDraft = new JFileChooser();
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDefaultDraft.setLayout(new GridBagLayout());
        this.lstPrintDraft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChooseDraftDialog.this.lstPrintDraft_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstPrintDraft);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlDefaultDraft.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblPrintDraft.setText("Druckvorlagen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlDefaultDraft.add((Component)this.lblPrintDraft, gridBagConstraints);
        this.butCancel.setText("Abbrechen");
        this.butCancel.setPreferredSize(new Dimension(120, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseDraftDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.pnlDefaultDraft.add((Component)this.butCancel, gridBagConstraints);
        this.butOpen.setText("\u00d6ffnen");
        this.butOpen.setPreferredSize(new Dimension(120, 23));
        this.butOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseDraftDialog.this.butOpen_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 9);
        this.pnlDefaultDraft.add((Component)this.butOpen, gridBagConstraints);
        this.tabPanel.addTab("Allgemein\n", this.pnlDefaultDraft);
        this.pnlLocalDraft.setAcceptAllFileFilterUsed(false);
        this.pnlLocalDraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseDraftDialog.this.pnlLocalDraft_actionPerformed(evt);
            }
        });
        this.tabPanel.addTab("Datei", this.pnlLocalDraft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 117;
        gridBagConstraints.ipady = 85;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPanel, gridBagConstraints);
        this.pack();
    }

    private void lstPrintDraft_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butOpen_onActionPerformed(null);
        }
    }

    private void butOpen_onActionPerformed(ActionEvent evt) {
        try {
            if (this.lstPrintDraft.getSelectedValue() == null) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.print.ChooseDraftDialog.no-draft-selected"), (String)I18N.get("common.message"));
                return;
            }
            String strFileName = this.lstPrintDraft.getSelectedValue().toString();
            File tempFile = ChooseDraftDialog.getGisContextDraftFile(strFileName);
            this.printDraft = ChooseDraftDialog.processDraftFile(tempFile);
            PersistentBlackboardPlugIn.get().put(LAST_DRAFT_KEY, strFileName);
            this.setVisible(false);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.printDraft = null;
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pnlLocalDraft_actionPerformed(ActionEvent evt) {
        try {
            if (evt.getActionCommand().equals("CancelSelection") || !this.pnlLocalDraft.getSelectedFile().exists()) {
                this.printDraft = null;
                this.setVisible(false);
                return;
            }
            String strPath = this.pnlLocalDraft.getSelectedFile().getAbsolutePath();
            String strDraftFile = this.pnlLocalDraft.getSelectedFile().getAbsolutePath();
            this.printDraft = ChooseDraftDialog.processDraftFile(new File(strDraftFile));
            Blackboard bb = PersistentBlackboardPlugIn.get();
            bb.put(CURRENT_FILE_KEY, strPath);
            bb.put(LAST_DRAFT_KEY, strPath);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
        finally {
            this.setVisible(false);
        }
    }
}

