/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print;

import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDialog;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AreaTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final Logger LOG = LoggerFactory.getLogger(AreaTableCellEditor.class);
    private JTextComponent editorComponent = null;
    private final Map<String, Map<String, String>> mapParameter;
    private final JTextField textEditor;
    private final JTextArea areaEditor;
    private final JScrollPane scrollPaneForArea;

    public AreaTableCellEditor(Map<String, Map<String, String>> mapParameter) {
        this.mapParameter = mapParameter;
        this.textEditor = new JTextField();
        this.areaEditor = new JTextArea();
        this.areaEditor.setFont(UIManager.getFont("TextField.font"));
        this.scrollPaneForArea = new JScrollPane(this.areaEditor);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorComponent.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Map<String, String> properties;
        String jumpParameter = this.computeSourceParameterKey(table, row);
        if (this.useTextField(jumpParameter, properties = this.mapParameter.get(jumpParameter))) {
            this.editorComponent = this.textEditor;
            this.setupEditorComponent(value, properties, jumpParameter, table, row, 20);
            return this.textEditor;
        }
        this.editorComponent = this.areaEditor;
        this.setupEditorComponent(value, properties, jumpParameter, table, row, 40);
        return this.scrollPaneForArea;
    }

    private void setupEditorComponent(Object value, Map<String, String> properties, String jumpParameter, JTable table, int row, int rowHeight) {
        this.configureMaximumLengthForField(properties, jumpParameter);
        this.editorComponent.setText((String)value);
        this.updateRowHeightJavaBugfix(table, row, rowHeight);
    }

    private boolean useTextField(String jumpParameter, Map<String, String> properties) {
        return this.mapParameter.containsKey(jumpParameter) && !properties.isEmpty() && properties.containsKey("type") && Objects.toString(properties.get("type")).equalsIgnoreCase("text");
    }

    private void configureMaximumLengthForField(Map<String, String> mapProperties, String jumpParameter) {
        try {
            if (mapProperties == null || mapProperties.isEmpty() || !mapProperties.containsKey("maxlength")) {
                this.editorComponent.setDocument(null);
                return;
            }
            int maxLength = Integer.parseInt(Objects.toString(mapProperties.get("maxlength")));
            this.editorComponent.setDocument(new LengthLimitedPlainDocument(maxLength));
        }
        catch (Exception e) {
            LOG.warn(String.format("Error finding out length limit of print draft parameter %s.", jumpParameter), (Throwable)e);
        }
    }

    private String computeSourceParameterKey(JTable table, int row) {
        String strParameter = Objects.toString(table.getValueAt(row, 0), null);
        for (Map.Entry<String, String> specialTreatmentParamEntry : PrintDialog.specialTreatmentParameters.entrySet()) {
            if (!StringUtils.equals((CharSequence)strParameter, (CharSequence)specialTreatmentParamEntry.getValue())) continue;
            strParameter = specialTreatmentParamEntry.getKey();
        }
        return "JUMP_" + strParameter;
    }

    private void updateRowHeightJavaBugfix(JTable table, int row, int height) {
        if (table.getRowHeight(row) != height) {
            table.setRowHeight(row, height);
        }
    }

    private static class LengthLimitedPlainDocument
    extends PlainDocument {
        private final int maxLength;

        public LengthLimitedPlainDocument(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (this.getLength() + str.length() > this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.insertString(offset, str, a);
            }
        }
    }
}

