/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.DataSourceOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.DemOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.InitialViewOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.OverviewOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.SearchOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.SymbolSourceOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.task.TaskOptionPanel;
import de.riwagis.icons.IconLoader;
import javax.swing.ImageIcon;

public class TaskOptionsPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.dialog(context).setSize(600, 550);
        this.dialog(context).setResizable(false);
        GUIUtil.centreOnWindow(this.dialog(context));
        this.dialog(context).setVisible(true);
        if (this.dialog(context).wasOKPressed()) {
            WorkbenchContext.getTask().reinitCachedObjects();
            WorkbenchContext.getTask().firePropertiesChanged();
            WorkbenchContext.getTask().setModified(true);
        }
        return this.dialog(context).wasOKPressed();
    }

    private OptionsDialog dialog(PlugInContext context) {
        return OptionsDialog.instance(WorkbenchContext.getWorkbench(), OptionsDialog.TASK_DIALOG_KEY);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.options.task.TaskOptionsPlugIn.name");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"file_options.svg");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.dialog(context).setTitle(this.getName());
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.TaskOptionPanel.titel"), new TaskOptionPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.titel"), new InitialViewOptionPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.OverviewOptionPanel.titel"), new OverviewOptionPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.DemOptionPanel.titel"), new DemOptionPanel());
        DataSourceOptionPanel dsOptionPanel = new DataSourceOptionPanel(context.getWorkbenchContext());
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.DataSourceOptionPanel.titel"), dsOptionPanel);
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.SymbolSourceOptionPanel.titel"), new SymbolSourceOptionPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.task.SearchOptionPanel.titel"), new SearchOptionPanel(context.getWorkbenchContext(), dsOptionPanel));
    }
}

