/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.unit.UnitFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class TaskOptionPanel
extends JPanel
implements OptionsPanel {
    private final WorkbenchContext workbenchContext;
    private Task task = null;
    private Blackboard BB = null;
    private final Font uiFont = UIManager.getFont("Label.font").deriveFont(1);
    private final CRSUnitLookup unitLookup = new CRSUnitLookup();
    private JTextArea areaDesc;
    private JComboBox<CRSDefinition> cboCRS;
    private JComboBox<DrawingUnit> cboUnit;
    private JCheckBox chkUTMProjectionAndHightCorrection;
    private Box.Filler filler3;
    private JLabel lblCRS;
    private JLabel lblDesc;
    private JLabel lblMidGroundLevel;
    private JLabel lblName;
    private JLabel lblUnit;
    private JPanel pnlUTM;
    private JScrollPane scrDesc;
    private JTextField tfiMidGroundLevel;
    private JTextField txtName;

    public TaskOptionPanel(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.initComponents();
        this.i18n();
        this.fillLists();
    }

    private void i18n() {
        this.lblName.setText(I18N.get("ui.plugin.options.task.TaskOptionPanel.name"));
        this.lblDesc.setText(I18N.get("ui.plugin.options.task.TaskOptionPanel.desc"));
        this.lblUnit.setText(I18N.get("ui.plugin.options.task.TaskOptionPanel.unit"));
        this.lblCRS.setText(I18N.get("ui.plugin.options.task.TaskOptionPanel.crs"));
    }

    private void fillLists() {
        List lstUnit = UnitFactory.getUnitList();
        for (DrawingUnit unit : lstUnit) {
            this.cboUnit.addItem(unit);
        }
        ArrayList lstCRS = new ArrayList(CRSDefFactory.getCRSDefinitionList());
        Collections.sort(lstCRS);
        for (CRSDefinition crsDef : lstCRS) {
            this.cboCRS.addItem(crsDef);
        }
    }

    @Override
    public void init() {
        this.task = WorkbenchContext.getTask();
        this.BB = this.task.getBlackboard();
        this.txtName.setText((String)this.BB.get("NAME"));
        this.areaDesc.setText((String)this.BB.get("DESC"));
        this.cboUnit.setSelectedItem(this.task.getDrawingUnit());
        this.cboCRS.setSelectedItem(this.task.getCRSDefinition());
        this.chkUTMProjectionAndHightCorrection.setSelected(this.BB.get("UTM_PROJECTION_AND_HIGHT_REDUCTION_ACTIVE", true));
        this.tfiMidGroundLevel.setText(this.BB.get("UTM_MID_GROUND_LEVEL", "0"));
    }

    @Override
    public void okPressed() {
        this.BB.put("NAME", this.txtName.getText());
        this.BB.put("DESC", this.areaDesc.getText());
        DrawingUnit unit = (DrawingUnit)this.cboUnit.getSelectedItem();
        CRSDefinition crsDef = (CRSDefinition)this.cboCRS.getSelectedItem();
        this.BB.put("UNIT", UnitFactory.getKey((DrawingUnit)unit));
        this.BB.put("CRS", CRSDefFactory.getKey((CRSDefinition)crsDef));
        this.BB.put("UTM_PROJECTION_AND_HIGHT_REDUCTION_ACTIVE", this.chkUTMProjectionAndHightCorrection.isSelected());
        String utmMidGroundLevel = this.tfiMidGroundLevel.getText();
        try {
            Double.parseDouble(utmMidGroundLevel);
        }
        catch (NumberFormatException e) {
            utmMidGroundLevel = "0";
        }
        this.BB.put("UTM_MID_GROUND_LEVEL", utmMidGroundLevel);
    }

    @Override
    public String validateInput() {
        return null;
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblDesc = new JLabel();
        this.scrDesc = new JScrollPane();
        this.areaDesc = new JTextArea();
        this.lblCRS = new JLabel();
        this.cboCRS = new JComboBox();
        this.lblUnit = new JLabel();
        this.cboUnit = new JComboBox();
        this.pnlUTM = new JPanel();
        this.chkUTMProjectionAndHightCorrection = new JCheckBox();
        this.filler3 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.lblMidGroundLevel = new JLabel();
        this.tfiMidGroundLevel = new JTextField();
        this.setMinimumSize(new Dimension(420, 270));
        this.setPreferredSize(new Dimension(420, 270));
        this.setLayout(new GridBagLayout());
        this.lblName.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setMinimumSize(new Dimension(105, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.txtName, gridBagConstraints);
        this.lblDesc.setText("Beschreibung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblDesc, gridBagConstraints);
        this.scrDesc.setHorizontalScrollBarPolicy(31);
        this.scrDesc.setMinimumSize(new Dimension(24, 40));
        this.areaDesc.setColumns(20);
        this.areaDesc.setFont(this.txtName.getFont());
        this.areaDesc.setLineWrap(true);
        this.areaDesc.setRows(5);
        this.scrDesc.setViewportView(this.areaDesc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.scrDesc, gridBagConstraints);
        this.lblCRS.setText("Koordinatensystem:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblCRS, gridBagConstraints);
        this.cboCRS.setMinimumSize(new Dimension(105, 22));
        this.cboCRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskOptionPanel.this.cboCRSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add(this.cboCRS, gridBagConstraints);
        this.lblUnit.setText("Einheiten:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblUnit, gridBagConstraints);
        this.cboUnit.setMinimumSize(new Dimension(105, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add(this.cboUnit, gridBagConstraints);
        this.pnlUTM.setBorder(BorderFactory.createTitledBorder(new MatteBorder(1, 0, 0, 0, Color.BLACK), I18N.get("ui.plugin.options.common.CommonOptionsPanel.utm-projection-reduction"), 4, 0, this.uiFont));
        this.pnlUTM.setMinimumSize(new Dimension(149, 70));
        this.pnlUTM.setPreferredSize(new Dimension(416, 70));
        this.pnlUTM.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.chkUTMProjectionAndHightCorrection.setText(bundle.getString("ui.plugin.options.common.CommonOptionsPanel.utm-projection-and-hight-correction"));
        this.chkUTMProjectionAndHightCorrection.setToolTipText(bundle.getString("ui.plugin.options.common.CommonOptionsPanel.utm-projection-and-hight-correction-tooltip"));
        this.chkUTMProjectionAndHightCorrection.setMargin(new Insets(0, 0, 0, 0));
        this.chkUTMProjectionAndHightCorrection.setMinimumSize(new Dimension(250, 19));
        this.chkUTMProjectionAndHightCorrection.setPreferredSize(new Dimension(250, 19));
        this.chkUTMProjectionAndHightCorrection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskOptionPanel.this.chkUTMProjectionAndHightCorrectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlUTM.add((Component)this.chkUTMProjectionAndHightCorrection, gridBagConstraints);
        this.pnlUTM.add((Component)this.filler3, new GridBagConstraints());
        this.lblMidGroundLevel.setHorizontalAlignment(11);
        this.lblMidGroundLevel.setText(bundle.getString("ui.plugin.options.common.CommonOptionsPanel.utm-mid-ground-level"));
        this.lblMidGroundLevel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.pnlUTM.add((Component)this.lblMidGroundLevel, gridBagConstraints);
        this.tfiMidGroundLevel.setHorizontalAlignment(11);
        this.tfiMidGroundLevel.setMinimumSize(new Dimension(30, 20));
        this.tfiMidGroundLevel.setName("test");
        this.tfiMidGroundLevel.setPreferredSize(new Dimension(30, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlUTM.add((Component)this.tfiMidGroundLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.pnlUTM, gridBagConstraints);
    }

    private void chkUTMProjectionAndHightCorrectionActionPerformed(ActionEvent evt) {
        this.tfiMidGroundLevel.setEnabled(this.chkUTMProjectionAndHightCorrection.isSelected());
    }

    private void cboCRSActionPerformed(ActionEvent evt) {
        CRSDefinition crsDefinition = (CRSDefinition)this.cboCRS.getSelectedItem();
        Optional<DrawingUnit> detectedUnit = this.unitLookup.extractUnitFromCRS(crsDefinition);
        this.cboUnit.setEnabled(detectedUnit.isEmpty());
        detectedUnit.ifPresent(this.cboUnit::setSelectedItem);
    }

    static class CRSUnitLookup {
        private final Map<String, String> wktUnitToRiwaUnit = Map.of("m", "meter", "metre", "meter", "degree", "degree");
        private final Pattern unitPattern = Pattern.compile("\\s*UNIT\\[\"([\\d\\w\\s]*)\".*].*");

        CRSUnitLookup() {
        }

        public Optional<DrawingUnit> extractUnitFromCRS(CRSDefinition crsDef) {
            return Optional.ofNullable(crsDef).map(crsDefinition -> crsDefinition.getCRS()).map(crs -> crs.toWKT()).stream().flatMap(wkt -> Arrays.stream(wkt.split(System.lineSeparator()))).filter(line -> line.startsWith("  UNIT[")).findFirst().map(unitLine -> this.unitPattern.matcher((CharSequence)unitLine)).filter(match -> match.matches() && match.groupCount() == 1).map(match -> match.group(1)).map(unit -> UnitFactory.getUnit((String)this.wktUnitToRiwaUnit.get(unit)));
        }
    }
}

