/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSLayerPanel;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.ows.wms.BoundingBox;
import com.vividsolutions.ows.wms.MapRequest;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public class OverviewOptionPanel
extends JPanel
implements OptionsPanel {
    private WorkbenchContext workbenchContext = null;
    private Task task = null;
    private Blackboard BB = null;
    private boolean bolBlockEvents = false;
    private JButton butPicture;
    private JComboBox cmbSource;
    private JLabel lblPicture;
    private JLabel lblSource;
    private JPanel pnlPicture;
    private JPanel pnlSpacer;
    private JTextField txtPicture;
    private WMSLayerPanel wmsLayerPanel;

    public OverviewOptionPanel(WorkbenchContext _workbenchContext) {
        this.workbenchContext = _workbenchContext;
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        this.bolBlockEvents = true;
        try {
            this.lblSource.setText(I18N.get("ui.plugin.options.task.OverviewOptionPanel.source"));
            this.lblPicture.setText(I18N.get("ui.plugin.options.task.OverviewOptionPanel.picture"));
            this.butPicture.setText(I18N.get("ui.plugin.options.task.OverviewOptionPanel.picture-choose"));
            this.cmbSource.removeAllItems();
            this.cmbSource.addItem(I18N.get("ui.plugin.options.task.OverviewOptionPanel.source-none"));
            this.cmbSource.addItem(I18N.get("ui.plugin.options.task.OverviewOptionPanel.source-wms"));
            this.cmbSource.addItem(I18N.get("ui.plugin.options.task.OverviewOptionPanel.source-picture"));
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    @Override
    public void init() {
        this.task = WorkbenchContext.getTask();
        this.BB = this.task.getBlackboard();
        Object objOverview = this.BB.get("OVERVIEW");
        if (objOverview == null) {
            this.cmbSource.setSelectedIndex(0);
        } else if (objOverview instanceof WMSStyleModel) {
            WMSStyleModel wmsStyle = (WMSStyleModel)objOverview;
            this.cmbSource.setSelectedIndex(1);
            this.wmsLayerPanel.setWMSStyle(wmsStyle);
        } else {
            this.cmbSource.setSelectedIndex(2);
            this.txtPicture.setText(objOverview.toString());
        }
    }

    @Override
    public void okPressed() {
        try {
            if (this.cmbSource.getSelectedIndex() == 0) {
                this.BB.remove("OVERVIEW");
            } else if (this.cmbSource.getSelectedIndex() == 1) {
                WMSStyleModel wmsStyle = this.wmsLayerPanel.getWMSStyle();
                this.BB.put("OVERVIEW", wmsStyle.clone());
            } else {
                this.BB.put("OVERVIEW", this.txtPicture.getText());
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
        }
    }

    @Override
    public String validateInput() {
        if (this.cmbSource.getSelectedIndex() == 0) {
            return null;
        }
        if (this.cmbSource.getSelectedIndex() == 1) {
            return this.wmsLayerPanel.validateInput();
        }
        String strRasterFile = this.txtPicture.getText();
        File flRaster = new File(strRasterFile);
        if (!flRaster.exists() || flRaster.isDirectory()) {
            return strRasterFile + " does not exist.";
        }
        return null;
    }

    public static Image getImage(Task task, Envelope env, int width, int height) throws IOException {
        Object objOverview = task.getBlackboard().get("OVERVIEW");
        if (objOverview == null) {
            return null;
        }
        if (objOverview instanceof WMSStyleModel) {
            WMSStyleModel style = (WMSStyleModel)objOverview;
            MapRequest request = RenderUtil.getRenderer(style).getWMService().createMapRequest();
            request.setBoundingBox(new BoundingBox(style.getSRS(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY()));
            request.setFormat(style.getFormat());
            request.setImageWidth(WorkbenchContext.getInstance().getLayerViewPanel().scale(width));
            request.setImageHeight(WorkbenchContext.getInstance().getLayerViewPanel().scale(height));
            request.setLayerNames(style.getLstLayerNames());
            request.setTransparent(true);
            return request.getImage(null);
        }
        BufferedImage img = ImageIO.read(new File(objOverview.toString()));
        return img.getScaledInstance(width, height, 4);
    }

    private void initComponents() {
        this.lblSource = new JLabel();
        this.cmbSource = new JComboBox();
        this.wmsLayerPanel = new WMSLayerPanel();
        this.pnlPicture = new JPanel();
        this.lblPicture = new JLabel();
        this.txtPicture = new JTextField();
        this.butPicture = new JButton();
        this.pnlSpacer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblSource.setText("Quelle:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.lblSource, gridBagConstraints);
        this.cmbSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewOptionPanel.this.cmbSource_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 9);
        this.add((Component)this.cmbSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.wmsLayerPanel, gridBagConstraints);
        this.pnlPicture.setLayout(new FlowLayout(0));
        this.lblPicture.setText("Pfad zum \u00dcbersichtsbild:");
        this.pnlPicture.add(this.lblPicture);
        this.txtPicture.setPreferredSize(new Dimension(200, 20));
        this.pnlPicture.add(this.txtPicture);
        this.butPicture.setText("w\u00e4hlen...");
        this.butPicture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewOptionPanel.this.butPicture_onActionPerformed(evt);
            }
        });
        this.pnlPicture.add(this.butPicture);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlPicture, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSpacer, gridBagConstraints);
    }

    private void cmbSource_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        if (this.cmbSource.getSelectedIndex() == 0) {
            this.pnlPicture.setEnabled(false);
            this.pnlPicture.setVisible(false);
            this.wmsLayerPanel.setEnabled(false);
            this.wmsLayerPanel.setVisible(false);
        } else if (this.cmbSource.getSelectedIndex() == 1) {
            this.pnlPicture.setEnabled(false);
            this.pnlPicture.setVisible(false);
            this.wmsLayerPanel.setEnabled(true);
            this.wmsLayerPanel.setVisible(true);
        } else {
            this.pnlPicture.setEnabled(true);
            this.pnlPicture.setVisible(true);
            this.wmsLayerPanel.setEnabled(false);
            this.wmsLayerPanel.setVisible(false);
        }
    }

    private void butPicture_onActionPerformed(ActionEvent evt) {
        String strPicture = this.txtPicture.getText();
        File selFile = new File(strPicture);
        FileFilter dataFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.plugin.options.task.OverviewOptionPanel.picture-data"), (String[])new String[]{"jpg", "png"});
        JFileChooser dataFileChooser = GUISupport.createJFileChooser();
        dataFileChooser.setFileFilter(dataFileFilter);
        dataFileChooser.setAcceptAllFileFilterUsed(false);
        dataFileChooser.setMultiSelectionEnabled(false);
        dataFileChooser.setCurrentDirectory(selFile.getParentFile());
        int intOption = dataFileChooser.showOpenDialog(this);
        if (intOption == 1) {
            return;
        }
        File dataFile = dataFileChooser.getSelectedFile();
        this.txtPicture.setText(dataFile.toString());
    }
}

