/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public class InitialViewOptionPanel
extends JPanel
implements OptionsPanel {
    private WorkbenchContext workbenchContext = null;
    private Task task = null;
    private Blackboard BB = null;
    private final DecimalFormat df = new DecimalFormat();
    private JButton butUseZoom;
    private JLabel lblDesc;
    private JLabel lblDescMinZoom;
    private JLabel lblDescWrapAround;
    private JLabel lblHeight;
    private JLabel lblMiddle;
    private JLabel lblMinZoom;
    private JLabel lblWidth;
    private JLabel lblWrapAround;
    private JLabel lblX;
    private JLabel lblY;
    private JFormattedTextField txtHeight;
    private JFormattedTextField txtMinZoom;
    private JFormattedTextField txtWidth;
    private JFormattedTextField txtWrapAround;
    private JFormattedTextField txtX;
    private JFormattedTextField txtY;

    public InitialViewOptionPanel(WorkbenchContext _workbenchContext) {
        this.workbenchContext = _workbenchContext;
        this.initComponents();
        this.i18n();
        this.df.setMaximumFractionDigits(7);
        this.df.setGroupingUsed(false);
        this.txtX.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtY.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtWidth.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtHeight.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtWrapAround.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtMinZoom.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
    }

    private void i18n() {
        this.lblDesc.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.desc"));
        this.lblMiddle.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.middle"));
        this.lblX.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.x"));
        this.lblY.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.y"));
        this.lblWidth.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.width"));
        this.lblHeight.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.height"));
        this.lblDescWrapAround.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.desc-wrap-around"));
        this.lblWrapAround.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.wrap-around"));
        this.lblDescMinZoom.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.desc-min-zoom"));
        this.lblMinZoom.setText(I18N.get("ui.plugin.options.task.InitialViewOptionPanel.min-zoom"));
    }

    @Override
    public void init() {
        this.task = WorkbenchContext.getTask();
        this.BB = this.task.getBlackboard();
        Object objEnv = this.BB.get("INITIAL_VIEW");
        Envelope env = null;
        env = objEnv == null ? this.workbenchContext.getLayerViewPanel().fullExtent() : (Envelope)objEnv;
        this.setEnvelope(env);
        Object objWrapAround = this.BB.get("WRAP_AROUND");
        double dblWrapAround = 1.0;
        if (objWrapAround != null) {
            dblWrapAround = (Double)objWrapAround;
        }
        this.txtWrapAround.setText(this.df.format(dblWrapAround));
        Object objMinZoom = this.BB.get("MIN_ZOOM");
        double dblMinZoom = 0.01;
        if (objMinZoom != null) {
            dblMinZoom = (Double)objMinZoom;
        }
        this.txtMinZoom.setText(this.df.format(dblMinZoom));
    }

    private void setEnvelope(Envelope env) {
        this.txtHeight.setText(this.df.format(env.getHeight()));
        this.txtWidth.setText(this.df.format(env.getWidth()));
        double x = (env.getMaxX() + env.getMinX()) / 2.0;
        double y = (env.getMaxY() + env.getMinY()) / 2.0;
        this.txtX.setText(this.df.format(x));
        this.txtY.setText(this.df.format(y));
    }

    @Override
    public void okPressed() {
        try {
            double x = this.df.parse(this.txtX.getText()).doubleValue();
            double y = this.df.parse(this.txtY.getText()).doubleValue();
            double width = this.df.parse(this.txtWidth.getText()).doubleValue();
            double height = this.df.parse(this.txtHeight.getText()).doubleValue();
            double xmin = x - width / 2.0;
            double xmax = x + width / 2.0;
            double ymin = y - height / 2.0;
            double ymax = y + height / 2.0;
            Envelope env = new Envelope(xmin, xmax, ymin, ymax);
            this.BB.put("INITIAL_VIEW", env);
            double dblWrapAround = this.df.parse(this.txtWrapAround.getText()).doubleValue();
            this.BB.put("WRAP_AROUND", new Double(dblWrapAround));
            double dblMinZoom = this.df.parse(this.txtMinZoom.getText()).doubleValue();
            this.BB.put("MIN_ZOOM", new Double(dblMinZoom));
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
        }
    }

    @Override
    public String validateInput() {
        return null;
    }

    private void initComponents() {
        this.lblMiddle = new JLabel();
        this.lblWidth = new JLabel();
        this.lblX = new JLabel();
        this.lblHeight = new JLabel();
        this.lblY = new JLabel();
        this.txtX = new JFormattedTextField();
        this.txtY = new JFormattedTextField();
        this.txtHeight = new JFormattedTextField();
        this.txtWidth = new JFormattedTextField();
        this.butUseZoom = new JButton();
        this.lblDesc = new JLabel();
        this.lblDescWrapAround = new JLabel();
        this.lblWrapAround = new JLabel();
        this.txtWrapAround = new JFormattedTextField();
        this.lblDescMinZoom = new JLabel();
        this.txtMinZoom = new JFormattedTextField();
        this.lblMinZoom = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblMiddle.setText("Mittelpunkt:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.add((Component)this.lblMiddle, gridBagConstraints);
        this.lblWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblWidth, gridBagConstraints);
        this.lblX.setText("X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.lblX, gridBagConstraints);
        this.lblHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblHeight, gridBagConstraints);
        this.lblY.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.lblY, gridBagConstraints);
        this.txtX.setMinimumSize(new Dimension(120, 20));
        this.txtX.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.txtX, gridBagConstraints);
        this.txtY.setMinimumSize(new Dimension(120, 20));
        this.txtY.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.txtY, gridBagConstraints);
        this.txtHeight.setMinimumSize(new Dimension(120, 20));
        this.txtHeight.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.add((Component)this.txtHeight, gridBagConstraints);
        this.txtWidth.setMinimumSize(new Dimension(120, 20));
        this.txtWidth.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtWidth, gridBagConstraints);
        this.butUseZoom.setText("aktuelle Zoomeinstellungen \u00fcbernehmen");
        this.butUseZoom.setMaximumSize(new Dimension(9999, 99));
        this.butUseZoom.setMinimumSize(new Dimension(284, 23));
        this.butUseZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InitialViewOptionPanel.this.butUseZoomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.add((Component)this.butUseZoom, gridBagConstraints);
        this.lblDesc.setText("<html>Mittelpunkt und Gr\u00f6\u00dfe des maximalen Kartenbereiches. <br>Alle Angaben in Zeicheneinheiten.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.lblDesc, gridBagConstraints);
        this.lblDescWrapAround.setText("<html>Damit Symbole/Texte auch im Randbereich auch dann angezeigt werden, wenn diese Ihren Einf\u00fcgepunkt nicht im sichbaren Bereich haben, definiert der Umgriff den Wert, welcher zus\u00e4tzlich zum sichtbaren Kartenausschnitt geladen wird.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.lblDescWrapAround, gridBagConstraints);
        this.lblWrapAround.setText("Umgiff");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 9, 3);
        this.add((Component)this.lblWrapAround, gridBagConstraints);
        this.txtWrapAround.setMinimumSize(new Dimension(120, 20));
        this.txtWrapAround.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 3);
        this.add((Component)this.txtWrapAround, gridBagConstraints);
        this.lblDescMinZoom.setText("<html>Seitenl\u00e4nge des minimal zul\u00e4ssigen Zoomausschnittes in Zeicheneinheiten.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.lblDescMinZoom, gridBagConstraints);
        this.txtMinZoom.setMinimumSize(new Dimension(120, 20));
        this.txtMinZoom.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 3);
        this.add((Component)this.txtMinZoom, gridBagConstraints);
        this.lblMinZoom.setText("Seitenl\u00e4nge");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 3);
        this.add((Component)this.lblMinZoom, gridBagConstraints);
    }

    private void butUseZoomActionPerformed(ActionEvent evt) {
        Envelope env = this.workbenchContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        this.setEnvelope(env);
    }
}

