/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wmts.WMTSLayerPanel;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.locationtech.jts.util.Assert;

public class DemOptionPanel
extends JPanel
implements OptionsPanel {
    private Task task = null;
    private Blackboard BB = null;
    private boolean bolBlockEvents = false;
    private JComboBox cmbSource;
    private JLabel lblSource;
    private JPanel pnlSpacer;
    private WMTSLayerPanel wmtsLayerPanel;

    public DemOptionPanel() {
        this.initComponents();
        this.i18n();
        this.wmtsLayerPanel.setOptionsTabEnabled(false);
    }

    private void i18n() {
        this.bolBlockEvents = true;
        try {
            this.lblSource.setText(I18N.get("ui.plugin.options.task.DemOptionPanel.source"));
            this.cmbSource.removeAllItems();
            this.cmbSource.addItem(I18N.get("ui.plugin.options.task.DemOptionPanel.source-none"));
            this.cmbSource.addItem(I18N.get("ui.plugin.options.task.DemOptionPanel.source-wmts"));
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    @Override
    public void init() {
        this.task = WorkbenchContext.getTask();
        this.BB = this.task.getBlackboard();
        Object objDEM = this.BB.get("DEM");
        if (objDEM == null) {
            this.cmbSource.setSelectedIndex(0);
        } else if (objDEM instanceof WMTSStyleModel) {
            WMTSStyleModel wmtsStyle = (WMTSStyleModel)objDEM;
            this.cmbSource.setSelectedIndex(1);
            this.wmtsLayerPanel.setWMTSStyle(wmtsStyle);
        } else {
            this.cmbSource.setSelectedIndex(0);
        }
    }

    @Override
    public void okPressed() {
        try {
            if (this.cmbSource.getSelectedIndex() == 0) {
                this.BB.remove("DEM");
            } else if (this.cmbSource.getSelectedIndex() == 1) {
                WMTSStyleModel wmtsStyle = this.wmtsLayerPanel.getWMTSStyle();
                this.BB.put("DEM", wmtsStyle.clone());
            } else {
                this.BB.remove("DEM");
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
        }
    }

    @Override
    public String validateInput() {
        if (this.cmbSource.getSelectedIndex() == 0) {
            return null;
        }
        if (this.cmbSource.getSelectedIndex() == 1) {
            return this.wmtsLayerPanel.validateInput();
        }
        return null;
    }

    private void initComponents() {
        this.lblSource = new JLabel();
        this.cmbSource = new JComboBox();
        this.wmtsLayerPanel = new WMTSLayerPanel();
        this.pnlSpacer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblSource.setText("Quelle:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 9);
        this.add((Component)this.lblSource, gridBagConstraints);
        this.cmbSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemOptionPanel.this.cmbSource_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 9);
        this.add((Component)this.cmbSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.wmtsLayerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSpacer, gridBagConstraints);
    }

    private void cmbSource_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        if (this.cmbSource.getSelectedIndex() == 0) {
            this.wmtsLayerPanel.setEnabled(false);
            this.wmtsLayerPanel.setVisible(false);
        } else if (this.cmbSource.getSelectedIndex() == 1) {
            this.wmtsLayerPanel.setEnabled(true);
            this.wmtsLayerPanel.setVisible(true);
        } else {
            this.wmtsLayerPanel.setEnabled(false);
            this.wmtsLayerPanel.setVisible(false);
        }
    }
}

