/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.task;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import de.riwagis.riwajump.data.gui.DatastoreListPanel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.locationtech.jts.util.Assert;

public class DataSourceOptionPanel
extends JPanel
implements OptionsPanel {
    private WorkbenchContext workbenchContext = null;
    private Task task = null;
    private Blackboard BB = null;
    private DMDCollection dmdOriginal = null;
    private DMDCollection dmdClone = null;
    private DatastoreListPanel pnlDatastoreList;

    public DataSourceOptionPanel(WorkbenchContext _workbenchContext) {
        try {
            Config.LOCALE = I18N.getLocale((String)JUMPWorkbench.I18N_SETLOCALE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.workbenchContext = _workbenchContext;
        this.initComponents();
    }

    @Override
    public void init() {
        this.task = WorkbenchContext.getTask();
        this.BB = this.task.getBlackboard();
        this.setDatastoreList((DMDCollection)this.BB.get("LOCAL_DATASOURCES", new DMDCollection(this.task)));
    }

    public void setDatastoreList(DMDCollection _dmdDatastores) {
        this.dmdOriginal = _dmdDatastores;
        this.dmdClone = new DMDCollection(this.task, this.dmdOriginal.getCloneList());
        this.pnlDatastoreList.setDMDCollection(this.dmdClone);
    }

    public DMDCollection getDatastoreList() {
        DMDCollection dmdNew = new DMDCollection(this.task, this.dmdClone.getCloneList());
        return dmdNew;
    }

    @Override
    public void okPressed() {
        try {
            List<DatastoreMetadata> lstOriginal = this.dmdOriginal.getInternalList();
            for (DatastoreMetadata dmdOri : lstOriginal) {
                dmdOri.dispose();
            }
            lstOriginal.clear();
            Iterator<DatastoreMetadata> i = this.dmdClone.iterator();
            while (i.hasNext()) {
                lstOriginal.add(i.next());
            }
            this.BB.put("LOCAL_DATASOURCES", this.dmdOriginal);
            this.task.clearCachedLabelDefs();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    @Override
    public String validateInput() {
        return null;
    }

    private void initComponents() {
        this.pnlDatastoreList = new DatastoreListPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlDatastoreList, gridBagConstraints);
    }
}

