/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesOp;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.snap.GridRenderer;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToIntersectionPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import de.riwagis.icons.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SnapOptionPanel
extends JPanel
implements OptionsPanel {
    private WorkbenchContext workbenchContext = null;
    private Blackboard pBB = null;
    private final DecimalFormat df = new DecimalFormat();
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private ButtonGroup buttonGroup1;
    private JCheckBox cboGrid;
    private JCheckBox cboSnapGrid;
    private JCheckBox cboSnapIntersection;
    private JCheckBox cboSnapLine;
    private JCheckBox cboSnapPoint;
    private JCheckBox cboTopoUnionPoint;
    private JLabel jLabel4;
    private JLabel lblGridUnit;
    private JLabel lblSnapPixel;
    private JLabel lblSnapTolerance;
    private JPanel pnlFiller;
    private JPanel pnlGrid;
    private JPanel pnlSnap;
    private JPanel pnlTopo;
    private JRadioButton rdoGridLine;
    private JRadioButton rdoGridPoint;
    private JFormattedTextField txtGridSize;
    private JFormattedTextField txtSnapTolerance;

    public SnapOptionPanel(WorkbenchContext _workbenchContext) {
        this.workbenchContext = _workbenchContext;
        this.pBB = PersistentBlackboardPlugIn.get();
        this.initComponents();
        this.i18n();
        this.df.setMaximumFractionDigits(5);
        this.df.setGroupingUsed(false);
        this.nf.setGroupingUsed(false);
        this.txtSnapTolerance.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
        this.txtGridSize.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
    }

    private void i18n() {
        ((TitledBorder)this.pnlSnap.getBorder()).setTitle(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap"));
        ((TitledBorder)this.pnlGrid.getBorder()).setTitle(I18N.get("ui.plugin.options.common.SnapOptionPanel.grid"));
        ((TitledBorder)this.pnlTopo.getBorder()).setTitle(I18N.get("ui.plugin.options.common.SnapOptionPanel.topo"));
        this.lblSnapTolerance.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap-tolerance"));
        this.lblSnapPixel.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap-pixel"));
        this.cboSnapPoint.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap-point"));
        this.cboSnapIntersection.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap-intersection"));
        this.cboSnapLine.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap-line"));
        this.cboSnapGrid.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.snap-grid"));
        this.cboGrid.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.show-grid"));
        this.lblGridUnit.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.unit"));
        this.rdoGridPoint.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.grid-point"));
        this.rdoGridLine.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.grid-line"));
        this.cboTopoUnionPoint.setText(I18N.get("ui.plugin.options.common.SnapOptionPanel.topo-union-point-generate"));
    }

    @Override
    public void init() {
        this.pnlTopo.setVisible(false);
        this.txtSnapTolerance.setText(this.nf.format(SnapManager.getToleranceInPixels(this.pBB)));
        this.cboSnapPoint.setSelected(this.pBB.get(SnapToVerticesPolicy.ENABLED_KEY, true));
        this.cboSnapIntersection.setSelected(this.pBB.get(SnapToIntersectionPolicy.ENABLED_KEY, true));
        this.cboSnapLine.setSelected(this.pBB.get(SnapToFeaturesPolicy.ENABLED_KEY, false));
        this.cboSnapGrid.setSelected(this.pBB.get(SnapToGridPolicy.ENABLED_KEY, false));
        this.txtGridSize.setText(this.df.format(this.pBB.get(SnapToGridPolicy.GRID_SIZE_KEY, 20.0)));
        this.cboGrid.setSelected(this.pBB.get(GridRenderer.ENABLED_KEY, false));
        this.rdoGridPoint.setSelected(this.pBB.get(GridRenderer.DOTS_ENABLED_KEY, false));
        this.rdoGridLine.setSelected(this.pBB.get(GridRenderer.LINES_ENABLED_KEY, true));
        this.cboTopoUnionPoint.setSelected(this.pBB.get(SnapVerticesOp.INSERT_VERTICES_IF_NECESSARY_KEY, true));
        this.updateEnabled();
    }

    @Override
    public void okPressed() {
        try {
            SnapManager.setToleranceInPixels(this.nf.parse(this.txtSnapTolerance.getText()).intValue(), this.pBB);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pBB.put(SnapToVerticesPolicy.ENABLED_KEY, this.cboSnapPoint.isSelected());
        this.pBB.put(SnapToIntersectionPolicy.ENABLED_KEY, this.cboSnapIntersection.isSelected());
        this.pBB.put(SnapToFeaturesPolicy.ENABLED_KEY, this.cboSnapLine.isSelected());
        this.pBB.put(SnapToGridPolicy.ENABLED_KEY, this.cboSnapGrid.isSelected());
        try {
            this.pBB.put(SnapToGridPolicy.GRID_SIZE_KEY, this.df.parse(this.txtGridSize.getText()).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pBB.put(GridRenderer.DOTS_ENABLED_KEY, this.rdoGridPoint.isSelected());
        this.pBB.put(GridRenderer.LINES_ENABLED_KEY, this.rdoGridLine.isSelected());
        this.pBB.put(GridRenderer.ENABLED_KEY, this.cboGrid.isSelected());
        this.pBB.put(SnapVerticesOp.INSERT_VERTICES_IF_NECESSARY_KEY, this.cboTopoUnionPoint.isSelected());
    }

    @Override
    public String validateInput() {
        return null;
    }

    private void updateEnabled() {
        if (this.cboSnapGrid.isSelected() || this.cboSnapPoint.isSelected() || this.cboSnapLine.isSelected()) {
            this.txtSnapTolerance.setEnabled(true);
        } else {
            this.txtSnapTolerance.setEnabled(false);
        }
        if (this.cboGrid.isSelected()) {
            this.txtGridSize.setEnabled(true);
            this.rdoGridLine.setEnabled(true);
            this.rdoGridPoint.setEnabled(true);
        } else {
            this.txtGridSize.setEnabled(false);
            this.rdoGridLine.setEnabled(false);
            this.rdoGridPoint.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.pnlSnap = new JPanel();
        this.cboSnapPoint = new JCheckBox();
        this.lblSnapTolerance = new JLabel();
        this.cboSnapLine = new JCheckBox();
        this.cboSnapGrid = new JCheckBox();
        this.lblSnapPixel = new JLabel();
        this.txtSnapTolerance = new JFormattedTextField();
        this.cboSnapIntersection = new JCheckBox();
        this.pnlGrid = new JPanel();
        this.cboGrid = new JCheckBox();
        this.lblGridUnit = new JLabel();
        this.rdoGridPoint = new JRadioButton();
        this.rdoGridLine = new JRadioButton();
        this.txtGridSize = new JFormattedTextField();
        this.pnlTopo = new JPanel();
        this.cboTopoUnionPoint = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.pnlFiller = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pnlSnap.setBorder(BorderFactory.createTitledBorder("Punkt- / Linienfang"));
        this.pnlSnap.setLayout(new GridBagLayout());
        this.cboSnapPoint.setText("Fangfunktion zu Punkten");
        this.cboSnapPoint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboSnapPoint.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapOptionPanel.this.cboSnapPoint_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSnap.add((Component)this.cboSnapPoint, gridBagConstraints);
        this.lblSnapTolerance.setText("Toleranz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 9, 3, 3);
        this.pnlSnap.add((Component)this.lblSnapTolerance, gridBagConstraints);
        this.cboSnapLine.setText("Fangfunktion zu Linien");
        this.cboSnapLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboSnapLine.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapOptionPanel.this.cboSnapLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSnap.add((Component)this.cboSnapLine, gridBagConstraints);
        this.cboSnapGrid.setText("Fangfunktion auf Gitter");
        this.cboSnapGrid.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboSnapGrid.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapOptionPanel.this.cboSnapGridActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.pnlSnap.add((Component)this.cboSnapGrid, gridBagConstraints);
        this.lblSnapPixel.setText("Pixel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 3, 3, 3);
        this.pnlSnap.add((Component)this.lblSnapPixel, gridBagConstraints);
        this.txtSnapTolerance.setMinimumSize(new Dimension(60, 20));
        this.txtSnapTolerance.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlSnap.add((Component)this.txtSnapTolerance, gridBagConstraints);
        this.cboSnapIntersection.setText("Fangfunktion zu Schnittpunkten");
        this.cboSnapIntersection.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboSnapIntersection.setMargin(new Insets(0, 0, 0, 0));
        this.cboSnapIntersection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapOptionPanel.this.cboSnapIntersection_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSnap.add((Component)this.cboSnapIntersection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.pnlSnap, gridBagConstraints);
        this.pnlGrid.setBorder(BorderFactory.createTitledBorder("Gitterdarstellung"));
        this.pnlGrid.setLayout(new GridBagLayout());
        this.cboGrid.setText("Zeige Gitter");
        this.cboGrid.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboGrid.setMargin(new Insets(0, 0, 0, 0));
        this.cboGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapOptionPanel.this.cboGrid_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(13, 9, 3, 3);
        this.pnlGrid.add((Component)this.cboGrid, gridBagConstraints);
        this.lblGridUnit.setText("Zeicheneinheiten");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(13, 3, 3, 9);
        this.pnlGrid.add((Component)this.lblGridUnit, gridBagConstraints);
        this.buttonGroup1.add(this.rdoGridPoint);
        this.rdoGridPoint.setText("Gitter als Punkte");
        this.rdoGridPoint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdoGridPoint.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlGrid.add((Component)this.rdoGridPoint, gridBagConstraints);
        this.buttonGroup1.add(this.rdoGridLine);
        this.rdoGridLine.setText("Gitter als Linien");
        this.rdoGridLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdoGridLine.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 6, 3);
        this.pnlGrid.add((Component)this.rdoGridLine, gridBagConstraints);
        this.txtGridSize.setMinimumSize(new Dimension(80, 20));
        this.txtGridSize.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlGrid.add((Component)this.txtGridSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.pnlGrid, gridBagConstraints);
        this.pnlTopo.setBorder(BorderFactory.createTitledBorder("Topologie"));
        this.pnlTopo.setLayout(new GridBagLayout());
        this.cboTopoUnionPoint.setText("<html>Punkt einf\u00fcgen bei der Zusammenfassung zu einem topologischem Knoten<br> (falls keiner im Segment vorhanden ist)</html>");
        this.cboTopoUnionPoint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboTopoUnionPoint.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.pnlTopo.add((Component)this.cboTopoUnionPoint, gridBagConstraints);
        this.jLabel4.setIcon(IconLoader.svgIcon((String)"geometry_catch_points.svg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.pnlTopo.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.add((Component)this.pnlTopo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFiller, gridBagConstraints);
    }

    private void cboSnapGridActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }

    private void cboSnapLine_onActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }

    private void cboSnapPoint_onActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }

    private void cboGrid_onActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }

    private void cboSnapIntersection_onActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }
}

