/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.SaveRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;

public class RedlineLayerOptionsPanel
extends JPanel
implements OptionsPanel {
    private ListModel<ListObject> listModel = null;
    private JButton butAdd;
    private JButton butDelete;
    private JButton butEdit;
    private JPanel jPanel1;
    private JLabel lblCategory;
    private JLabel lblRedlineLayers;
    private JList<ListObject> lstRedlineLayers;
    private JScrollPane scrRedlineLayers;
    private JTextField tfCategory;

    public RedlineLayerOptionsPanel() {
        this.initComponents();
        this.i18n();
        this.listModel = new DefaultListModel<ListObject>();
        this.lstRedlineLayers.setModel(this.listModel);
        this.lstRedlineLayers.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ListObject lo = (ListObject)value;
                StringBuilder sb = new StringBuilder();
                if (lo.getName() != null) {
                    sb.append(lo.getName()).append(" - ");
                }
                sb.append(lo.getFile().getAbsolutePath());
                this.setText(sb.toString());
                this.setToolTipText(sb.toString());
                return this;
            }
        });
    }

    private void i18n() {
        this.lblRedlineLayers.setText(I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.redlinelayers"));
        this.lblCategory.setText(I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.category-label"));
        this.butAdd.setText(I18N.get("common.new"));
        this.butEdit.setText(I18N.get("common.change"));
        this.butDelete.setText(I18N.get("common.delete"));
    }

    private void initComponents() {
        this.lblRedlineLayers = new JLabel();
        this.scrRedlineLayers = new JScrollPane();
        this.lstRedlineLayers = new JList();
        this.jPanel1 = new JPanel();
        this.butAdd = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.lblCategory = new JLabel();
        this.tfCategory = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblRedlineLayers.setText("Zeichenebenen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.lblRedlineLayers, gridBagConstraints);
        this.scrRedlineLayers.setMinimumSize(new Dimension(150, 200));
        this.scrRedlineLayers.setPreferredSize(new Dimension(150, 200));
        this.lstRedlineLayers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RedlineLayerOptionsPanel.this.lstRedlineLayers_onMouseClicked(evt);
            }
        });
        this.scrRedlineLayers.setViewportView(this.lstRedlineLayers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 3);
        this.add((Component)this.scrRedlineLayers, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(3, 1, 3, 4));
        this.butAdd.setText("neu");
        this.butAdd.setMinimumSize(new Dimension(80, 23));
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedlineLayerOptionsPanel.this.butAdd_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butAdd);
        this.butEdit.setText("\u00e4ndern");
        this.butEdit.setMinimumSize(new Dimension(80, 23));
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedlineLayerOptionsPanel.this.butEdit_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butEdit);
        this.butDelete.setText("l\u00f6schen");
        this.butDelete.setMinimumSize(new Dimension(80, 23));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RedlineLayerOptionsPanel.this.butDelete_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lblCategory.setText("Ebenengruppenname:");
        this.lblCategory.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.add((Component)this.lblCategory, gridBagConstraints);
        this.tfCategory.setText("Meine Zeichenebenen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.tfCategory, gridBagConstraints);
    }

    private void lstRedlineLayers_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butEdit_onActionPerformed(null);
        }
    }

    private void butAdd_onActionPerformed(ActionEvent evt) {
        File newRedlineLayer = this.showFileDialog(null);
        if (newRedlineLayer != null) {
            ListObject newListObject = new ListObject(this, newRedlineLayer);
            ((DefaultListModel)this.listModel).addElement(newListObject);
            this.lstRedlineLayers.setSelectedValue(newListObject, true);
        }
    }

    private void butEdit_onActionPerformed(ActionEvent evt) {
        List<ListObject> selectedValues = this.lstRedlineLayers.getSelectedValuesList();
        if (selectedValues.size() != 1) {
            return;
        }
        ListObject oldListObject = this.lstRedlineLayers.getSelectedValue();
        File oldRedlineLayer = oldListObject.getFile();
        File newRedlineLayer = this.showFileDialog(oldRedlineLayer);
        if (newRedlineLayer != null) {
            ListObject newListObject = new ListObject(this, newRedlineLayer);
            int idx = ((DefaultListModel)this.listModel).indexOf(oldListObject);
            ((DefaultListModel)this.listModel).removeElement(oldListObject);
            ((DefaultListModel)this.listModel).add(idx, newListObject);
            this.lstRedlineLayers.setSelectedValue(newListObject, true);
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        List<ListObject> selectedValues = this.lstRedlineLayers.getSelectedValuesList();
        if (selectedValues.isEmpty()) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(this, I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.delete-question"), I18N.get("common.message"), 0);
        if (option == 0) {
            for (ListObject lo : selectedValues) {
                ((DefaultListModel)this.listModel).removeElement(lo);
            }
        }
    }

    @Override
    public String validateInput() {
        Enumeration iter = ((DefaultListModel)this.listModel).elements();
        while (iter.hasMoreElements()) {
            ListObject lo = (ListObject)iter.nextElement();
            File file = lo.getFile();
            if (file.exists()) continue;
            return String.format(I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.file-does-not-exists"), file.getAbsolutePath());
        }
        String category = this.tfCategory.getText();
        if (StringUtils.isBlank((CharSequence)category)) {
            return I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.category-not-valid");
        }
        return null;
    }

    @Override
    public void okPressed() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        ArrayList<File> redlineLayers = new ArrayList<File>(((DefaultListModel)this.listModel).size());
        Enumeration iter = ((DefaultListModel)this.listModel).elements();
        while (iter.hasMoreElements()) {
            File file = ((ListObject)iter.nextElement()).getFile();
            redlineLayers.add(file);
        }
        bb.put("MY_REDLINELAYERS", redlineLayers);
        String category = this.tfCategory.getText();
        bb.put("MY_REDLINELAYERS_CATEGORY", category);
    }

    @Override
    public void init() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (bb.contains("MY_REDLINELAYERS")) {
            List redlineLayers = (List)bb.get("MY_REDLINELAYERS");
            ((DefaultListModel)this.listModel).clear();
            for (File redlineLayer : redlineLayers) {
                ((DefaultListModel)this.listModel).addElement(new ListObject(this, redlineLayer));
            }
        }
    }

    private File showFileDialog(File oldRedlineLayer) {
        FileFilter rlyFilter = GUIUtil.createFileFilter(I18N.get("ui.plugin.io.layer.SaveRedlineLayerPlugIn.FileFilterName"), new String[]{"rly"});
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        fileChooser.setDialogTitle(this.getName());
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(rlyFilter);
        fileChooser.setFileFilter(rlyFilter);
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (oldRedlineLayer == null) {
            if (bb.contains(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY)) {
                String strPath = (String)bb.get(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY);
                fileChooser.setSelectedFile(new File(strPath));
            }
        } else {
            fileChooser.setSelectedFile(oldRedlineLayer);
        }
        if (0 != fileChooser.showOpenDialog(WorkbenchContext.getFrame())) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        String strFile = file.getAbsolutePath();
        bb.put(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY, strFile);
        return file;
    }

    private class ListObject {
        private File file;
        private String name;

        public ListObject(RedlineLayerOptionsPanel redlineLayerOptionsPanel, File file) {
            this.file = file;
            try {
                this.name = RedlineLayerUtils.readHeader(file).getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }
    }
}

