/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ExternalProgrammsOptionPanel
extends JPanel
implements OptionsPanel {
    public static final String PDF_KEY = "ExtProgramm - PDF";
    private final FileFilter exeFilter = new FileFilter(this){

        @Override
        public String getDescription() {
            return "*.exe";
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isFile() && f.getName().toLowerCase().endsWith(".exe") || f.isDirectory();
        }
    };
    PlugInContext context = null;
    private JButton butPDF;
    private JLabel lblPDF;
    private JTextField txtPDF;

    public ExternalProgrammsOptionPanel(PlugInContext _context) {
        this.context = _context;
        this.initComponents();
        this.i18n();
    }

    @Override
    public String validateInput() {
        String strPDF = this.txtPDF.getText();
        if (strPDF == null || strPDF.trim().equals("")) {
            return null;
        }
        File pdfExe = new File(strPDF);
        if (!pdfExe.exists()) {
            return I18N.get("ui.plugin.options.common.ExternalProgrammsOptionPanel.pdfviewer-not-valid");
        }
        return null;
    }

    @Override
    public void okPressed() {
        String strPDF = this.txtPDF.getText();
        Blackboard bb = PersistentBlackboardPlugIn.get();
        bb.put(PDF_KEY, strPDF);
    }

    @Override
    public void init() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        String strPDF = bb.get(PDF_KEY, "");
        this.txtPDF.setText(strPDF);
    }

    private void i18n() {
        this.lblPDF.setText(I18N.get("ui.plugin.options.common.ExternalProgrammsOptionPanel.pdfviewer"));
    }

    private void initComponents() {
        this.lblPDF = new JLabel();
        this.txtPDF = new JTextField();
        this.butPDF = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblPDF.setText("PDF-Viewer:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(13, 9, 3, 3);
        this.add((Component)this.lblPDF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 3, 3, 3);
        this.add((Component)this.txtPDF, gridBagConstraints);
        this.butPDF.setText("...");
        this.butPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalProgrammsOptionPanel.this.butPDF_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 3, 3, 9);
        this.add((Component)this.butPDF, gridBagConstraints);
    }

    private void butPDF_onActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(this.exeFilter);
        int state = fileChooser.showOpenDialog(this.context.getWorkbenchFrame());
        if (state == 1 || state == -1) {
            return;
        }
        if (fileChooser.getSelectedFile() == null || !fileChooser.getSelectedFile().exists()) {
            return;
        }
        this.txtPDF.setText(fileChooser.getSelectedFile().getAbsolutePath());
    }
}

