/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ConstraintsOptionsPanel
extends JPanel
implements OptionsPanel {
    private WorkbenchContext workbenchContext = null;
    private Blackboard pBB = null;
    private final DecimalFormat df = new DecimalFormat();
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private ButtonGroup buttonGroup1;
    private JCheckBox cboAngle1;
    private JCheckBox cboAngle2;
    private JCheckBox cboCommon;
    private JCheckBox cboLength;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel lblAngle1_1;
    private JLabel lblAngle1_2;
    private JLabel lblAngle2;
    private JLabel lblLength;
    private JPanel pnlAngle1;
    private JPanel pnlAngle1_1;
    private JPanel pnlAngle1_2;
    private JPanel pnlAngle2;
    private JPanel pnlAngle2_1;
    private JPanel pnlAngle2_2;
    private JPanel pnlAngle2_3;
    private JPanel pnlCommon;
    private JPanel pnlLength;
    private JRadioButton rdoAngle2_1;
    private JRadioButton rdoAngle2_2;
    private JFormattedTextField txtAngle1;
    private JFormattedTextField txtAngle2;
    private JFormattedTextField txtLength;

    public ConstraintsOptionsPanel(WorkbenchContext _workbenchContext) {
        this.workbenchContext = _workbenchContext;
        this.pBB = PersistentBlackboardPlugIn.get();
        this.initComponents();
        this.i18n();
        this.df.setMaximumFractionDigits(5);
        this.df.setGroupingUsed(false);
        this.nf.setGroupingUsed(false);
        this.txtLength.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtAngle1.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
        this.txtAngle2.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
    }

    private void i18n() {
        ((TitledBorder)this.pnlCommon.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.common"));
        ((TitledBorder)this.pnlLength.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.length"));
        ((TitledBorder)this.pnlAngle1.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle"));
        ((TitledBorder)this.pnlAngle2.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.angle"));
        this.cboCommon.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.invalid-geom"));
        this.cboLength.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.constant-length"));
        this.cboLength.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.constant-length"));
        this.lblLength.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.unit"));
        this.cboAngle1.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle-step"));
        this.lblAngle1_1.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle-step-2"));
        this.lblAngle1_2.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle-step-3"));
        this.cboAngle2.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.allow-only-certain-angle"));
        this.lblAngle2.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.angle-degree"));
        this.rdoAngle2_1.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.relative-angle"));
        this.rdoAngle2_2.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.absolute-angle"));
    }

    @Override
    public void init() {
        this.cboCommon.setSelected(this.pBB.get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false));
        this.cboLength.setSelected(this.pBB.get("CONSTRAIN_LENGTH - ENABLED", false));
        this.txtLength.setText(this.df.format(this.pBB.get("LENGTH_CONSTRAINT", 0.5)));
        this.cboAngle1.setSelected(this.pBB.get("CONSTRAIN_INCREMENTAL_ANGLE - ENABLED", false));
        this.txtAngle1.setText(this.nf.format(this.pBB.get("INCREMENTAL_ANGLE_CONSTRAINT", 8)));
        this.cboAngle2.setSelected(this.pBB.get("CONSTRAIN_ANGLE - ENABLED", false));
        this.txtAngle2.setText(this.df.format(this.pBB.get("ANGLE_CONSTRAINT", 30.0)));
        this.rdoAngle2_1.setSelected(this.pBB.get("RELATIVE_ANGLE_CONSTRAINT", true));
        this.rdoAngle2_2.setSelected(this.pBB.get("ABSOLUTE_ANGLE_CONSTRAINT", false));
        this.setAngle1Text();
        this.updateEnabled();
    }

    @Override
    public void okPressed() {
        try {
            this.pBB.put("LENGTH_CONSTRAINT", this.df.parse(this.txtLength.getText()).doubleValue());
            this.pBB.put("INCREMENTAL_ANGLE_CONSTRAINT", this.nf.parse(this.txtAngle1.getText()).intValue());
            this.pBB.put("ANGLE_CONSTRAINT", this.df.parse(this.txtAngle2.getText()).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pBB.put("CONSTRAIN_LENGTH - ENABLED", this.cboLength.isSelected());
        this.pBB.put("CONSTRAIN_INCREMENTAL_ANGLE - ENABLED", this.cboAngle1.isSelected());
        this.pBB.put("CONSTRAIN_ANGLE - ENABLED", this.cboAngle2.isSelected());
        this.pBB.put("RELATIVE_ANGLE_CONSTRAINT", this.rdoAngle2_1.isSelected());
        this.pBB.put("ABSOLUTE_ANGLE_CONSTRAINT", this.rdoAngle2_2.isSelected());
        this.pBB.put(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, this.cboCommon.isSelected());
    }

    @Override
    public String validateInput() {
        String errorMessage1 = "\"" + this.txtLength.getText() + "\"" + I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.negative-numbers-not-allowed-for-length");
        String errorMessage2 = "\"" + this.txtAngle1.getText() + "\"" + I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.is-too-small-must-be-3-or-greater");
        String errorMessage3 = I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.invalid-numbers");
        try {
            if (this.df.parse(this.txtLength.getText()).doubleValue() < 0.0) {
                return errorMessage1;
            }
            if (this.nf.parse(this.txtAngle1.getText()).intValue() < 3) {
                return errorMessage2;
            }
            this.df.parse(this.txtAngle2.getText());
        }
        catch (Exception e) {
            return errorMessage3;
        }
        return null;
    }

    private void updateEnabled() {
        this.txtLength.setEnabled(this.cboLength.isSelected());
        this.txtAngle1.setEnabled(this.cboAngle1.isSelected());
        this.txtAngle2.setEnabled(this.cboAngle2.isSelected());
        this.rdoAngle2_1.setEnabled(this.cboAngle2.isSelected());
        this.rdoAngle2_2.setEnabled(this.cboAngle2.isSelected());
        if (this.cboAngle1.isSelected()) {
            ((TitledBorder)this.pnlAngle1.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle-long"));
        } else {
            ((TitledBorder)this.pnlAngle1.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle"));
        }
        if (this.cboAngle2.isSelected()) {
            ((TitledBorder)this.pnlAngle2.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.angle-long"));
        } else {
            ((TitledBorder)this.pnlAngle2.getBorder()).setTitle(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.angle"));
        }
        this.repaint();
    }

    private void setAngle1Text() {
        try {
            double newAngle = 360.0 / this.nf.parse(this.txtAngle1.getText()).doubleValue();
            this.cboAngle1.setText(I18N.get("ui.plugin.options.common.ConstraintsOptionsPanel.fix-angle-step").replaceAll("\\$", "" + newAngle));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.pnlLength = new JPanel();
        this.cboLength = new JCheckBox();
        this.txtLength = new JFormattedTextField();
        this.lblLength = new JLabel();
        this.pnlAngle1 = new JPanel();
        this.pnlAngle1_1 = new JPanel();
        this.cboAngle1 = new JCheckBox();
        this.pnlAngle1_2 = new JPanel();
        this.lblAngle1_1 = new JLabel();
        this.txtAngle1 = new JFormattedTextField();
        this.lblAngle1_2 = new JLabel();
        this.pnlAngle2 = new JPanel();
        this.pnlAngle2_1 = new JPanel();
        this.cboAngle2 = new JCheckBox();
        this.txtAngle2 = new JFormattedTextField();
        this.lblAngle2 = new JLabel();
        this.pnlAngle2_2 = new JPanel();
        this.rdoAngle2_1 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.pnlAngle2_3 = new JPanel();
        this.rdoAngle2_2 = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.pnlCommon = new JPanel();
        this.cboCommon = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.pnlLength.setBorder(BorderFactory.createTitledBorder("L\u00e4nge"));
        this.pnlLength.setLayout(new FlowLayout(0));
        this.cboLength.setText("L\u00e4nge festsetzen auf Vielfache von ");
        this.cboLength.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLength.setMargin(new Insets(0, 0, 0, 0));
        this.cboLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintsOptionsPanel.this.cboLength_onActionPerformed(evt);
            }
        });
        this.pnlLength.add(this.cboLength);
        this.txtLength.setMinimumSize(new Dimension(60, 20));
        this.txtLength.setPreferredSize(new Dimension(60, 20));
        this.txtLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintsOptionsPanel.this.txtLengthActionPerformed(evt);
            }
        });
        this.pnlLength.add(this.txtLength);
        this.lblLength.setText("Meter");
        this.pnlLength.add(this.lblLength);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.pnlLength, gridBagConstraints);
        this.pnlAngle1.setBorder(BorderFactory.createTitledBorder("Feste Winkel"));
        this.pnlAngle1.setLayout(new GridBagLayout());
        this.pnlAngle1_1.setLayout(new FlowLayout(0));
        this.cboAngle1.setText("Feste Winkel in Schritten von 45 Grad");
        this.cboAngle1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboAngle1.setMargin(new Insets(0, 0, 0, 0));
        this.cboAngle1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintsOptionsPanel.this.cboAngle1_onActionPerformed(evt);
            }
        });
        this.pnlAngle1_1.add(this.cboAngle1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAngle1.add((Component)this.pnlAngle1_1, gridBagConstraints);
        this.pnlAngle1_2.setLayout(new FlowLayout(0));
        this.lblAngle1_1.setHorizontalAlignment(2);
        this.lblAngle1_1.setText("durch Teilung von 360 Grad in ");
        this.pnlAngle1_2.add(this.lblAngle1_1);
        this.txtAngle1.setMinimumSize(new Dimension(50, 20));
        this.txtAngle1.setPreferredSize(new Dimension(50, 20));
        this.txtAngle1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintsOptionsPanel.this.txtAngle1ActionPerformed(evt);
            }
        });
        this.txtAngle1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ConstraintsOptionsPanel.this.txtAngle1focusLost(evt);
            }
        });
        this.pnlAngle1_2.add(this.txtAngle1);
        this.lblAngle1_2.setText("Teile.");
        this.pnlAngle1_2.add(this.lblAngle1_2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAngle1.add((Component)this.pnlAngle1_2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.pnlAngle1, gridBagConstraints);
        this.pnlAngle2.setBorder(BorderFactory.createTitledBorder("Winkel"));
        this.pnlAngle2.setLayout(new GridBagLayout());
        this.pnlAngle2_1.setLayout(new FlowLayout(0));
        this.cboAngle2.setText("nur bestimmte Winkel erlauben  ");
        this.cboAngle2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboAngle2.setMargin(new Insets(0, 0, 0, 0));
        this.cboAngle2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintsOptionsPanel.this.cboAngle2_onActionPerformed(evt);
            }
        });
        this.pnlAngle2_1.add(this.cboAngle2);
        this.txtAngle2.setMinimumSize(new Dimension(50, 20));
        this.txtAngle2.setPreferredSize(new Dimension(50, 20));
        this.txtAngle2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintsOptionsPanel.this.txtAngle2ActionPerformed(evt);
            }
        });
        this.pnlAngle2_1.add(this.txtAngle2);
        this.lblAngle2.setText("Grad");
        this.pnlAngle2_1.add(this.lblAngle2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAngle2.add((Component)this.pnlAngle2_1, gridBagConstraints);
        this.pnlAngle2_2.setLayout(new FlowLayout(0));
        this.buttonGroup1.add(this.rdoAngle2_1);
        this.rdoAngle2_1.setText("G\u00fcltig f\u00fcr relativen Winkel");
        this.rdoAngle2_1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdoAngle2_1.setMargin(new Insets(0, 0, 0, 0));
        this.pnlAngle2_2.add(this.rdoAngle2_1);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/com/vividsolutions/jump/workbench/ui/plugin/options/common/relAngle.png")));
        this.pnlAngle2_2.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAngle2.add((Component)this.pnlAngle2_2, gridBagConstraints);
        this.pnlAngle2_3.setLayout(new FlowLayout(0));
        this.buttonGroup1.add(this.rdoAngle2_2);
        this.rdoAngle2_2.setText("G\u00fcltig f\u00fcr absoluten Winkel");
        this.rdoAngle2_2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdoAngle2_2.setMargin(new Insets(0, 0, 0, 0));
        this.pnlAngle2_3.add(this.rdoAngle2_2);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/com/vividsolutions/jump/workbench/ui/plugin/options/common/absAngle.png")));
        this.pnlAngle2_3.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAngle2.add((Component)this.pnlAngle2_3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.pnlAngle2, gridBagConstraints);
        this.pnlCommon.setBorder(BorderFactory.createTitledBorder("Allgemein"));
        this.pnlCommon.setLayout(new FlowLayout(0));
        this.cboCommon.setText("Verhindere die Erstellung von ung\u00fcltigen Geometrien");
        this.cboCommon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboCommon.setMargin(new Insets(0, 0, 0, 0));
        this.pnlCommon.add(this.cboCommon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.pnlCommon, gridBagConstraints);
    }

    private void txtAngle1focusLost(FocusEvent evt) {
        this.setAngle1Text();
    }

    private void txtAngle2ActionPerformed(ActionEvent evt) {
    }

    private void txtAngle1ActionPerformed(ActionEvent evt) {
        this.setAngle1Text();
    }

    private void txtLengthActionPerformed(ActionEvent evt) {
    }

    private void cboAngle2_onActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }

    private void cboAngle1_onActionPerformed(ActionEvent evt) {
        this.setAngle1Text();
        this.updateEnabled();
    }

    private void cboLength_onActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }
}

