/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.SessionCacheDirectory;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.CacheOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.CommonOptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.ExternalProgrammsOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.ProxyOptionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.RedlineLayerOptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.common.SnapOptionPanel;
import de.riwagis.icons.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonOptionsPlugIn
extends AbstractPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(CommonOptionsPlugIn.class);
    public static final Lock CACHE_LOCK = new ReentrantLock();

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.dialog(context).setSize(600, 530);
        this.dialog(context).setResizable(false);
        this.dialog(context).setLocationRelativeTo(context.getWorkbenchFrame());
        this.dialog(context).setVisible(true);
        if (this.dialog(context).wasOKPressed()) {
            CommonOptionsPlugIn.renderGrid();
        }
        return this.dialog(context).wasOKPressed();
    }

    public static void renderGrid() {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = WorkbenchContext.getFrame().getInternalFrames()) {
            if (!(frame instanceof LayerViewPanelProxy)) continue;
            ((LayerViewPanelProxy)((Object)frame)).getLayerViewPanel().getRenderingManager().render("GRID", true);
        }
    }

    private OptionsDialog dialog(PlugInContext context) {
        return OptionsDialog.instance(WorkbenchContext.getWorkbench(), OptionsDialog.COMMON_DIALOG_KEY);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.options.common.CommonOptionsPlugIn.name");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_options.svg");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.dialog(context).setTitle(this.getName());
        this.dialog(context).addTab(I18N.get("ui.plugin.options.common.CommonOptionsPanel.title"), new CommonOptionsPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.title"), new RedlineLayerOptionsPanel());
        this.dialog(context).addTab(I18N.get("ui.plugin.options.common.SnapOptionPanel.title"), new SnapOptionPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.common.ProxyOptionPanel.title"), new ProxyOptionPanel(context.getWorkbenchContext()));
        this.dialog(context).addTab(I18N.get("ui.plugin.options.common.CacheOptionPanel.title"), new CacheOptionPanel());
        if (!System.getProperty("os.name").equalsIgnoreCase("linux")) {
            this.dialog(context).addTab(I18N.get("ui.plugin.options.common.ExternalProgrammsOptionPanel.title"), new ExternalProgrammsOptionPanel(context));
        }
        Runnable cleanUpTask = new Runnable(this){
            public static final long expirationTimeDay = 86400000L;
            public static final long expirationTimeWeek = 604800000L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                int countDeleted = 0;
                try {
                    String cacheDirectoryPath = SessionCacheDirectory.get();
                    int maxCacheSize = PersistentBlackboardPlugIn.get().get("cache_directory_size", 100);
                    File root = new File(cacheDirectoryPath);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("cleanup deamon start: cache directory " + String.valueOf(root) + " size: " + FileUtils.sizeOfDirectory((File)root) / 1024L / 1024L + "mb, max size: " + maxCacheSize + "mb");
                    }
                    if (root.exists()) {
                        long cleanUpTime = startTime - 604800000L;
                        if (maxCacheSize > 0 && FileUtils.sizeOfDirectory((File)root) / 1024L / 1024L > (long)maxCacheSize) {
                            cleanUpTime = startTime - 86400000L;
                        }
                        countDeleted = this.cleanUpDirectory(root, cleanUpTime);
                    }
                }
                catch (Exception ex) {
                    LOG.error("error cleaning up cache directory", (Throwable)ex);
                }
                finally {
                    LOG.info("cleanup deamon finished: " + countDeleted + " files and folders deleted, duration " + (System.currentTimeMillis() - startTime) + " ms");
                }
            }

            private int cleanUpDirectory(File dir, long cleanUpTime) {
                if (Thread.currentThread().isInterrupted()) {
                    return 0;
                }
                int countDeleted = 0;
                if (dir.isDirectory()) {
                    File[] files = dir.listFiles();
                    if (files.length == 0) {
                        dir.delete();
                        ++countDeleted;
                    } else {
                        for (File file : files) {
                            if (file.isDirectory()) {
                                countDeleted += this.cleanUpDirectory(file, cleanUpTime);
                                continue;
                            }
                            if (file.lastModified() >= cleanUpTime) continue;
                            file.delete();
                            ++countDeleted;
                        }
                        if (dir.listFiles().length == 0) {
                            dir.delete();
                            ++countDeleted;
                        }
                    }
                }
                return countDeleted;
            }
        };
        Runnable wmtsCleanUpTask = new Runnable(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                int countDeleted = 0;
                try {
                    String cacheDirectoryPath = SessionCacheDirectory.get();
                    File root = new File(cacheDirectoryPath, "wmts");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("cleanup deamon start: cache directory " + String.valueOf(root));
                    }
                    if (root.exists()) {
                        CACHE_LOCK.lock();
                        File[] files = root.listFiles();
                        if (files.length == 0) {
                            root.delete();
                        } else {
                            for (File file : files) {
                                if (!file.isDirectory() || file.getName().equals("rgz")) continue;
                                FileUtils.deleteDirectory((File)file);
                            }
                            if (root.listFiles().length == 0) {
                                root.delete();
                                ++countDeleted;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("error cleaning up cache directory", (Throwable)ex);
                }
                finally {
                    LOG.info("cleanup deamon finished: " + countDeleted + " files and folders deleted, duration " + (System.currentTimeMillis() - startTime) + " ms");
                    CACHE_LOCK.unlock();
                }
            }
        };
        final ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable r) {
                Thread cleanUpDeamon = new Thread(r, "CacheDirectoryCleanUpDeamon");
                cleanUpDeamon.setDaemon(true);
                cleanUpDeamon.setPriority(1);
                return cleanUpDeamon;
            }
        });
        threadPool.execute(wmtsCleanUpTask);
        threadPool.scheduleWithFixedDelay(cleanUpTask, 5L, 30L, TimeUnit.MINUTES);
        JUMPWorkbench.getWorkbench().addCloseAppListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                threadPool.shutdownNow();
            }
        });
    }
}

