/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.ToolTipWriter;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.WmsFeatureInfoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopyThisCoordinatePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import de.riwagis.gis.context.jump.MapContextImpl;
import de.riwagis.util.Support;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;

public class CommonOptionsPanel
extends JPanel
implements OptionsPanel {
    public static final String SHOW_MODULE_INFO_KEY = "SHOW_MODULE_INFO";
    private WorkbenchContext workbenchContext = null;
    private Blackboard pBB = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox cboGPSEnabled;
    private JCheckBox cboShowDurable;
    private JCheckBox chkGroupVisibleWithLayer;
    private JCheckBox chkOpenUrlOnDblClick;
    private JCheckBox chkOpenWmsInBrowser;
    private JCheckBox chkShowDashboard;
    private JCheckBox chkShowModuleInfo;
    private JComboBox cmbCoordNumSeparator;
    private JLabel jLabel1;
    private JLabel lblCoordNumSeparator;
    private JLabel lblCoordSeparator;
    private JLabel lblTooltips;
    private JLabel lblWMSTileSize;
    private JRadioButton optTooltipAllLayers;
    private JRadioButton optTooltipTopLayer;
    private JPanel pnlCoordCopy;
    private JPanel pnlMap;
    private JPanel pnlSearch;
    private JPanel pnlSearch1;
    private JSpinner tfWMSTileSize;
    private JTextField txtCoordSeparator;

    public CommonOptionsPanel(WorkbenchContext _workbenchContext) {
        this.workbenchContext = _workbenchContext;
        this.pBB = PersistentBlackboardPlugIn.get();
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        ((TitledBorder)this.pnlMap.getBorder()).setTitle(I18N.get("ui.plugin.options.common.CommonOptionsPanel.map"));
        ((TitledBorder)this.pnlCoordCopy.getBorder()).setTitle(I18N.get("ui.plugin.options.common.CommonOptionsPanel.copy-coord"));
        ((TitledBorder)this.pnlSearch.getBorder()).setTitle(I18N.get("ui.plugin.options.common.CommonOptionsPanel.search"));
        this.lblTooltips.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.tooltips"));
        this.optTooltipAllLayers.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.all-layers"));
        this.optTooltipTopLayer.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.top-layer"));
        this.chkGroupVisibleWithLayer.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.group-visible-with-layer"));
        this.lblCoordSeparator.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.delimiter"));
        this.lblCoordNumSeparator.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.dec-delimiter"));
        this.cboShowDurable.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.show-durable"));
        this.cmbCoordNumSeparator.removeAllItems();
        this.cmbCoordNumSeparator.addItem(I18N.get("ui.plugin.options.common.CommonOptionsPanel.point"));
        this.cmbCoordNumSeparator.addItem(I18N.get("ui.plugin.options.common.CommonOptionsPanel.comma"));
        this.chkOpenUrlOnDblClick.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.open-url-at-doubleclick"));
        this.chkOpenUrlOnDblClick.setToolTipText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.open-url-at-doubleclick-tooltip"));
        this.chkOpenWmsInBrowser.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.open-wms-info-in-browser"));
        this.lblWMSTileSize.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.wms-tile-size"));
        this.chkShowDashboard.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.show-dashboard"));
        this.chkShowModuleInfo.setText(I18N.get("ui.plugin.options.common.CommonOptionsPanel.show-module-info"));
    }

    @Override
    public void init() {
        boolean bolShowTTAll = this.pBB.get(ToolTipWriter.WRITER_SHOWALL, true);
        this.buttonGroup1.add(this.optTooltipAllLayers);
        this.buttonGroup1.add(this.optTooltipTopLayer);
        this.optTooltipAllLayers.setSelected(bolShowTTAll);
        this.optTooltipTopLayer.setSelected(!bolShowTTAll);
        boolean bolGroupVisibleWithLayer = this.pBB.get("GROUP_VISI_LAYER", true);
        this.chkGroupVisibleWithLayer.setSelected(bolGroupVisibleWithLayer);
        this.txtCoordSeparator.setText(this.pBB.get(CopyThisCoordinatePlugIn.DELIMITER, ";"));
        String strDecDelimiter = ".";
        strDecDelimiter = this.pBB.get(CopyThisCoordinatePlugIn.DECIMAL_DELIMITER, strDecDelimiter);
        if (strDecDelimiter.equals(".")) {
            this.cmbCoordNumSeparator.setSelectedIndex(0);
        } else {
            this.cmbCoordNumSeparator.setSelectedIndex(1);
        }
        boolean bolShowDurable = this.pBB.get(MapContextImpl.SELECTION_MARKER_DURABLE, true);
        this.cboShowDurable.setSelected(bolShowDurable);
        this.cboGPSEnabled.setSelected(this.pBB.get("GLOBAL_CONFIG_GPSACTIVE", false));
        boolean bolOpenUrlOnDblClick = this.pBB.get(SelectFeaturesTool.OPEN_URL_ON_DOUBLECLICK, true);
        this.chkOpenUrlOnDblClick.setSelected(bolOpenUrlOnDblClick);
        boolean bolOpenWmsInBrowser = this.pBB.get(WmsFeatureInfoPlugIn.OPEN_WMS_IN_BROWSER, false);
        this.chkOpenWmsInBrowser.setSelected(bolOpenWmsInBrowser);
        if (JUMPWorkbench.GIS_CONTEXT == null) {
            this.chkShowDashboard.setVisible(false);
            this.chkShowModuleInfo.setVisible(false);
        } else {
            boolean showDashboard = this.pBB.get("SHOW_DASHBOARD", false);
            this.chkShowDashboard.setSelected(showDashboard);
            boolean showModuleInfo = this.pBB.get(SHOW_MODULE_INFO_KEY, true);
            this.chkShowModuleInfo.setSelected(showModuleInfo);
        }
        int wmsTileSize = this.pBB.get(WMSLayer.DEFAULT_TILE_SIZE_KEY, 2000);
        this.tfWMSTileSize.setValue(new Integer(wmsTileSize));
        if (!Support.isWindows()) {
            this.cboGPSEnabled.setEnabled(false);
            this.jLabel1.setEnabled(false);
            this.cboGPSEnabled.setSelected(false);
        }
        this.updateEnabled();
    }

    @Override
    public void okPressed() {
        this.pBB.put(ToolTipWriter.WRITER_SHOWALL, this.optTooltipAllLayers.isSelected());
        this.pBB.put("GROUP_VISI_LAYER", this.chkGroupVisibleWithLayer.isSelected());
        if (this.txtCoordSeparator.getText().length() > 0) {
            this.pBB.put(CopyThisCoordinatePlugIn.DELIMITER, this.txtCoordSeparator.getText());
        }
        if (this.cmbCoordNumSeparator.getSelectedIndex() == 0) {
            this.pBB.put(CopyThisCoordinatePlugIn.DECIMAL_DELIMITER, ".");
        } else {
            this.pBB.put(CopyThisCoordinatePlugIn.DECIMAL_DELIMITER, ",");
        }
        this.pBB.put(MapContextImpl.SELECTION_MARKER_DURABLE, this.cboShowDurable.isSelected());
        this.pBB.put("GLOBAL_CONFIG_GPSACTIVE", this.cboGPSEnabled.isSelected());
        this.pBB.put(SelectFeaturesTool.OPEN_URL_ON_DOUBLECLICK, this.chkOpenUrlOnDblClick.isSelected());
        this.pBB.put(WmsFeatureInfoPlugIn.OPEN_WMS_IN_BROWSER, this.chkOpenWmsInBrowser.isSelected());
        this.pBB.put(WMSLayer.DEFAULT_TILE_SIZE_KEY, this.tfWMSTileSize.getValue());
        this.pBB.put("SHOW_DASHBOARD", this.chkShowDashboard.isSelected());
        this.pBB.put(SHOW_MODULE_INFO_KEY, this.chkShowModuleInfo.isSelected());
    }

    @Override
    public String validateInput() {
        String strCoordSeparator = this.txtCoordSeparator.getText();
        if (StringUtils.isEmpty((CharSequence)strCoordSeparator)) {
            this.txtCoordSeparator.setText(";");
        } else if (StringUtils.contains((CharSequence)strCoordSeparator, (CharSequence)".")) {
            return String.format(I18N.get("ui.plugin.options.common.CommonOptionsPanel.invalid-coord-separator"), strCoordSeparator);
        }
        int tileSize = (Integer)this.tfWMSTileSize.getValue();
        if (tileSize < 1 || tileSize > 2000) {
            return I18N.get("ui.plugin.options.common.CommonOptionsPanel.wms-tile-size-error");
        }
        return null;
    }

    private void updateEnabled() {
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.pnlMap = new JPanel();
        this.optTooltipAllLayers = new JRadioButton();
        this.optTooltipTopLayer = new JRadioButton();
        this.lblTooltips = new JLabel();
        this.chkGroupVisibleWithLayer = new JCheckBox();
        this.chkOpenUrlOnDblClick = new JCheckBox();
        this.chkOpenWmsInBrowser = new JCheckBox();
        this.lblWMSTileSize = new JLabel();
        this.tfWMSTileSize = new JSpinner();
        this.chkShowDashboard = new JCheckBox();
        this.chkShowModuleInfo = new JCheckBox();
        this.pnlCoordCopy = new JPanel();
        this.lblCoordSeparator = new JLabel();
        this.txtCoordSeparator = new JTextField();
        this.lblCoordNumSeparator = new JLabel();
        this.cmbCoordNumSeparator = new JComboBox();
        this.pnlSearch = new JPanel();
        this.cboShowDurable = new JCheckBox();
        this.pnlSearch1 = new JPanel();
        this.cboGPSEnabled = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.pnlMap.setBorder(BorderFactory.createTitledBorder("Karte"));
        this.pnlMap.setLayout(new GridBagLayout());
        this.optTooltipAllLayers.setText("f\u00fcr alle Ebenen");
        this.optTooltipAllLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.optTooltipAllLayersActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMap.add((Component)this.optTooltipAllLayers, gridBagConstraints);
        this.optTooltipTopLayer.setText("f\u00fcr oberste Ebene");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMap.add((Component)this.optTooltipTopLayer, gridBagConstraints);
        this.lblTooltips.setText("Tooltips");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 3, 3, 3);
        this.pnlMap.add((Component)this.lblTooltips, gridBagConstraints);
        this.chkGroupVisibleWithLayer.setText("Ebenengruppe automatisch mit Ebene sichtbar schalten");
        this.chkGroupVisibleWithLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.chkGroupVisibleWithLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlMap.add((Component)this.chkGroupVisibleWithLayer, gridBagConstraints);
        this.chkOpenUrlOnDblClick.setText("Verkn\u00fcpfte URL bei Doppelclick auf Element \u00f6ffnen");
        this.chkOpenUrlOnDblClick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.chkOpenUrlOnDblClickActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlMap.add((Component)this.chkOpenUrlOnDblClick, gridBagConstraints);
        this.chkOpenWmsInBrowser.setText("Informationen zu WMS-Ebenen direkt im Browser anzeigen");
        this.chkOpenWmsInBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.chkOpenWmsInBrowserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlMap.add((Component)this.chkOpenWmsInBrowser, gridBagConstraints);
        this.lblWMSTileSize.setText("WMS Kachelgr\u00f6\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMap.add((Component)this.lblWMSTileSize, gridBagConstraints);
        this.tfWMSTileSize.setModel(new SpinnerNumberModel(2000, 200, 2000, 1));
        this.tfWMSTileSize.setToolTipText("");
        this.tfWMSTileSize.setEditor(new JSpinner.NumberEditor(this.tfWMSTileSize, "#0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlMap.add((Component)this.tfWMSTileSize, gridBagConstraints);
        this.chkShowDashboard.setText("Infobox nach Server-Anmeldung anzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlMap.add((Component)this.chkShowDashboard, gridBagConstraints);
        this.chkShowModuleInfo.setText("Kundeninfo nach Server-Anmeldung anzeigen");
        this.chkShowModuleInfo.setActionCommand("Kundeninfo nach Server-Anmeldung anzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlMap.add((Component)this.chkShowModuleInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.pnlMap, gridBagConstraints);
        this.pnlCoordCopy.setBorder(BorderFactory.createTitledBorder("Koordinate in Zwischenablage kopieren"));
        this.pnlCoordCopy.setLayout(new GridBagLayout());
        this.lblCoordSeparator.setText("Trennzeichen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlCoordCopy.add((Component)this.lblCoordSeparator, gridBagConstraints);
        this.txtCoordSeparator.setMinimumSize(new Dimension(30, 26));
        this.txtCoordSeparator.setColumns(1);
        this.txtCoordSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.txtCoordSeparatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlCoordCopy.add((Component)this.txtCoordSeparator, gridBagConstraints);
        this.lblCoordNumSeparator.setText("Dezimaltrenner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlCoordCopy.add((Component)this.lblCoordNumSeparator, gridBagConstraints);
        this.cmbCoordNumSeparator.setModel(new DefaultComboBoxModel<String>(new String[]{"Punkt", "Komma"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlCoordCopy.add((Component)this.cmbCoordNumSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.pnlCoordCopy, gridBagConstraints);
        this.pnlSearch.setBorder(BorderFactory.createTitledBorder("Suchfunktion"));
        this.pnlSearch.setLayout(new GridBagLayout());
        this.cboShowDurable.setText("dauerhaft anzeigen");
        this.cboShowDurable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboShowDurable.setMargin(new Insets(0, 0, 0, 0));
        this.cboShowDurable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.cboShowDurable_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlSearch.add((Component)this.cboShowDurable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.pnlSearch, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.pnlSearch1.setBorder(BorderFactory.createTitledBorder(bundle.getString("ui.plugin.options.common.CommonOptionsPanel.GPStitle")));
        this.pnlSearch1.setPreferredSize(new Dimension(380, 85));
        this.pnlSearch1.setLayout(new GridBagLayout());
        this.cboGPSEnabled.setText(bundle.getString("ui.plugin.options.common.CommonOptionsPanel.GPSavailable"));
        this.cboGPSEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboGPSEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.cboGPSEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonOptionsPanel.this.cboGPSEnabled_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlSearch1.add((Component)this.cboGPSEnabled, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("ui.plugin.options.common.CommonOptionsPanel.GPSrequirements"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlSearch1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.add((Component)this.pnlSearch1, gridBagConstraints);
    }

    private void txtCoordSeparatorActionPerformed(ActionEvent evt) {
    }

    private void cboShowDurable_onActionPerformed(ActionEvent evt) {
    }

    private void optTooltipAllLayersActionPerformed(ActionEvent evt) {
    }

    private void chkGroupVisibleWithLayerActionPerformed(ActionEvent evt) {
    }

    private void cboGPSEnabled_onActionPerformed(ActionEvent evt) {
    }

    private void chkOpenUrlOnDblClickActionPerformed(ActionEvent evt) {
    }

    private void chkOpenWmsInBrowserActionPerformed(ActionEvent evt) {
    }
}

