/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options.common;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.SessionCacheDirectory;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheOptionPanel
extends JPanel
implements OptionsPanel {
    private static final Logger LOG = LoggerFactory.getLogger(CacheOptionPanel.class);
    public static final String CACHE_DIRECTORY_PATH_KEY = "cache_directory_path";
    public static final String CACHE_DIRECTORY_SIZE_KEY = "cache_directory_size";
    public static final int DEFAULT_CACHE_DIRECTORY_SIZE = 100;
    private JButton btnCacheDirectory;
    private Box.Filler filler1;
    private JLabel lblCacheDirectory;
    private JLabel lblMaxCacheSize;
    private JTextField tfCacheDirectory;
    private JSpinner tfMaxCacheSize;

    public CacheOptionPanel() {
        this.initComponents();
        this.i18n();
    }

    @Override
    public String validateInput() {
        String cacheDirectoryPath = this.tfCacheDirectory.getText();
        if (StringUtils.isEmpty((CharSequence)cacheDirectoryPath)) {
            return null;
        }
        File cacheDirectory = new File(cacheDirectoryPath);
        if (!cacheDirectory.exists()) {
            return I18N.get("ui.plugin.options.common.CacheOptionPanel.cache-directory-not-valid");
        }
        return null;
    }

    @Override
    public void okPressed() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        String cacheDirectoryPath = this.tfCacheDirectory.getText();
        bb.put(CACHE_DIRECTORY_PATH_KEY, cacheDirectoryPath);
        bb.put(CACHE_DIRECTORY_SIZE_KEY, this.tfMaxCacheSize.getValue());
        SessionCacheDirectory.reset();
    }

    @Override
    public void init() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        String cacheDirectoryPath = bb.get(CACHE_DIRECTORY_PATH_KEY, "");
        this.tfCacheDirectory.setText(cacheDirectoryPath);
        int maxCacheSize = bb.get(CACHE_DIRECTORY_SIZE_KEY, 100);
        this.tfMaxCacheSize.setValue(maxCacheSize);
    }

    private void i18n() {
        this.lblCacheDirectory.setText(I18N.get("ui.plugin.options.common.CacheOptionPanel.cache-directory"));
        this.lblMaxCacheSize.setText(I18N.get("ui.plugin.options.common.CacheOptionPanel.max-cache-size"));
    }

    private void initComponents() {
        this.lblCacheDirectory = new JLabel();
        this.tfCacheDirectory = new JTextField();
        this.btnCacheDirectory = new JButton();
        this.tfMaxCacheSize = new JSpinner();
        this.lblMaxCacheSize = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.lblCacheDirectory.setText("Cache-Verzeichnis:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(13, 9, 3, 3);
        this.add((Component)this.lblCacheDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 3, 3, 3);
        this.add((Component)this.tfCacheDirectory, gridBagConstraints);
        this.btnCacheDirectory.setText("...");
        this.btnCacheDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CacheOptionPanel.this.btnCacheDirectory_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 3, 3, 9);
        this.add((Component)this.btnCacheDirectory, gridBagConstraints);
        this.tfMaxCacheSize.setModel(new SpinnerNumberModel(100, 0, 256, 1));
        this.tfMaxCacheSize.setToolTipText("");
        this.tfMaxCacheSize.setEditor(new JSpinner.NumberEditor(this.tfMaxCacheSize, ""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfMaxCacheSize, gridBagConstraints);
        this.lblMaxCacheSize.setText("Maximale Cache Gr\u00f6\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.add((Component)this.lblMaxCacheSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void btnCacheDirectory_onActionPerformed(ActionEvent evt) {
        int state;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileSelectionMode(1);
        String cacheDirectoryPath = this.tfCacheDirectory.getText();
        if (StringUtils.isNotBlank((CharSequence)cacheDirectoryPath)) {
            fileChooser.setSelectedFile(new File(cacheDirectoryPath));
        }
        if ((state = fileChooser.showOpenDialog(WorkbenchContext.getFrame())) == 1 || state == -1) {
            return;
        }
        if (fileChooser.getSelectedFile() == null || !fileChooser.getSelectedFile().exists()) {
            return;
        }
        this.tfCacheDirectory.setText(fileChooser.getSelectedFile().getAbsolutePath());
    }
}

