/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.options;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.options.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.locationtech.jts.util.Assert;

public class OptionsDialog
extends JDialog {
    public static final String COMMON_DIALOG_KEY = OptionsDialog.class.getName() + " - CommonDialog";
    public static final String TASK_DIALOG_KEY = OptionsDialog.class.getName() + " - TaskDialog";
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private OKCancelPanel okCancelPanel = new OKCancelPanel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ArrayList<ChangedListener> changedListeners = new ArrayList();

    private OptionsDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Assert.shouldNeverReachHere((String)ex.getMessage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                OptionsDialog.this.fireInit();
            }
        });
        this.okCancelPanel.addActionListener(e -> {
            if (this.okCancelPanel.wasOKPressed()) {
                String errorMessage = this.validateInput();
                if (errorMessage != null) {
                    JOptionPane.showMessageDialog(this, errorMessage, "JUMP", 0);
                    return;
                }
                this.fireOKPressed();
                this.setVisible(false);
                return;
            }
            this.setVisible(false);
        });
    }

    public void addCangedListener(ChangedListener listener) {
        if (this.changedListeners.contains(listener)) {
            return;
        }
        this.changedListeners.add(listener);
    }

    public void removedCangedListener(ChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    private void fireChanged() {
        for (ChangedListener listener : this.changedListeners) {
            listener.propertiesChanged();
        }
    }

    public static OptionsDialog instance(JUMPWorkbench workbench, String bbKey) {
        return OptionsDialog.instance(JUMPWorkbench.getBlackboard(), JUMPWorkbench.getFrame(), bbKey);
    }

    public static OptionsDialog instance(Blackboard blackboard, Frame frame, String bbKey) {
        if (blackboard.get(bbKey) == null) {
            return (OptionsDialog)blackboard.get(bbKey, new OptionsDialog(frame, "Options", true));
        }
        return (OptionsDialog)blackboard.get(bbKey);
    }

    private void fireOKPressed() {
        for (OptionsPanel panel : this.optionsPanels()) {
            panel.okPressed();
        }
        this.fireChanged();
    }

    private void fireInit() {
        for (OptionsPanel panel : this.optionsPanels()) {
            panel.init();
        }
    }

    private Collection<OptionsPanel> optionsPanels() {
        ArrayList<OptionsPanel> optionsPanels = new ArrayList<OptionsPanel>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            optionsPanels.add((OptionsPanel)((Object)this.tabbedPane.getComponentAt(i)));
        }
        return optionsPanels;
    }

    private String validateInput() {
        for (OptionsPanel panel : this.optionsPanels()) {
            String errorMessage = panel.validateInput();
            if (errorMessage == null) continue;
            return errorMessage;
        }
        return null;
    }

    public void addTab(String title, OptionsPanel panel) {
        this.addTab(title, null, panel);
    }

    public void addTab(String title, Icon icon, OptionsPanel panel) {
        this.tabbedPane.addTab(title, icon, (Component)((Object)panel));
        this.pack();
    }

    private void jbInit() {
        JPanel strut = new JPanel();
        strut.setPreferredSize(new Dimension(280, 0));
        this.getContentPane().add((Component)strut, "North");
        this.panel1.setLayout(this.borderLayout1);
        this.setModal(true);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.okCancelPanel, "South");
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public static interface ChangedListener {
        public void propertiesChanged();
    }
}

