/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.TransformRedlineLayerDialog;
import de.riwagis.crs.Transformer;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;

public class TransformRedlineLayerPlugIn
extends AbstractPlugIn {
    PlugInContext context = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.redline.TransformRedlineLayerPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.context = _context;
        final RedlineLayer rly = this.getLayer();
        final TransformRedlineLayerDialog dlgTransRedline = new TransformRedlineLayerDialog((Frame)this.context.getWorkbenchFrame(), rly);
        dlgTransRedline.setVisible(true);
        if (dlgTransRedline.wasOkPressed()) {
            final WaitDialog dlgWait = new WaitDialog((Window)this.context.getWorkbenchFrame(), I18N.get("common.wait"));
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FeatureIterator<SimpleFeature> fi = null;
                    try {
                        Transformer trans = new Transformer(dlgTransRedline.getSourceCRS().getCRS(), dlgTransRedline.getTargetCRS().getCRS());
                        fi = TransformRedlineLayerPlugIn.this.getFeatureIterator();
                        while (fi.hasNext() && dlgWait.isVisible()) {
                            SimpleFeature fFrom = (SimpleFeature)fi.next();
                            trans.transform2d(fFrom);
                        }
                        rly.setMetaDataModified(true);
                        rly.reload();
                    }
                    catch (Exception e) {
                        dlgWait.setError(e);
                    }
                    finally {
                        try {
                            fi.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            dlgWait.addWorkToDo(run);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                ExceptionDialog.handleGuiException((Component)this.context.getWorkbenchFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
            }
        }
        return true;
    }

    RedlineLayer getLayer() {
        return (RedlineLayer)this.context.getSelectedLayer(0);
    }

    FeatureIterator<SimpleFeature> getFeatureIterator() throws Exception {
        return this.getLayer().getFeatureIterator((Envelope)null);
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RedlineLayer.class));
    }
}

