/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransformRedlineLayerDialog
extends JDialog {
    private boolean okPressed = false;
    private final RedlineLayer rly;
    private JButton butCancel;
    private JButton butOK;
    private JComboBox cmbSourceCRS;
    private JComboBox cmbTargetCRS;
    private JPanel jPanel1;
    private JLabel lblHeader;
    private JLabel lblSourceCRS;
    private JLabel lblTargetCRS;

    public TransformRedlineLayerDialog(Frame parent, RedlineLayer rly) {
        super(parent, true);
        this.rly = rly;
        this.initComponents();
        this.init();
        this.i18n();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean wasOkPressed() {
        return this.okPressed;
    }

    private void init() {
        ArrayList lstCrsDef = new ArrayList(CRSDefFactory.getCRSDefinitionList());
        Collections.sort(lstCrsDef);
        this.cmbSourceCRS.removeAllItems();
        this.cmbTargetCRS.removeAllItems();
        for (CRSDefinition crsDef : lstCrsDef) {
            this.cmbSourceCRS.addItem(crsDef);
            this.cmbTargetCRS.addItem(crsDef);
        }
        CRSDefinition crsDefTask = WorkbenchContext.getTask().getCRSDefinition();
        if (crsDefTask != null) {
            this.cmbSourceCRS.setSelectedItem(crsDefTask);
        }
    }

    public CRSDefinition getSourceCRS() {
        return (CRSDefinition)this.cmbSourceCRS.getSelectedItem();
    }

    public CRSDefinition getTargetCRS() {
        return (CRSDefinition)this.cmbTargetCRS.getSelectedItem();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.layer.redline.TransformRedlineLayerDialog.title"));
        this.lblHeader.setText(I18N.getMessage("ui.plugin.layer.redline.TransformRedlineLayerDialog.header", this.rly.getName()));
        this.lblSourceCRS.setText(I18N.get("ui.plugin.layer.redline.TransformRedlineLayerDialog.source-crs"));
        this.lblTargetCRS.setText(I18N.get("ui.plugin.layer.redline.TransformRedlineLayerDialog.target-crs"));
        this.butOK.setText(I18N.get("common.ok"));
        this.butCancel.setText(I18N.get("common.cancel"));
    }

    private void initComponents() {
        this.lblTargetCRS = new JLabel();
        this.cmbTargetCRS = new JComboBox();
        this.lblSourceCRS = new JLabel();
        this.cmbSourceCRS = new JComboBox();
        this.jPanel1 = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.lblHeader = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Zeichenebene transformieren");
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblTargetCRS.setText("Zielkoordinatensystem:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblTargetCRS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbTargetCRS, gridBagConstraints);
        this.lblSourceCRS.setText("Ausgangskoordinatensystem:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblSourceCRS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbSourceCRS, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setMinimumSize(new Dimension(100, 23));
        this.butOK.setPreferredSize(new Dimension(100, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformRedlineLayerDialog.this.butOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMinimumSize(new Dimension(100, 23));
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformRedlineLayerDialog.this.butCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.lblHeader.setText("<html>Transformation s\u00e4mtlicher Koordinaten der Zeichenebene in ein neues Koordinatensystem:</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblHeader, gridBagConstraints);
    }

    private void butOKActionPerformed(ActionEvent evt) {
        this.okPressed = true;
        this.setVisible(false);
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.okPressed = false;
        this.setVisible(false);
    }
}

