/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.SetRedlineTooltipDialog;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.lang3.ObjectUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SetRedlineTooltipPlugIn
extends AbstractPlugIn {
    private SetRedlineTooltipDialog setRedlineTooltipDialog = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.redline.SetRedlineTooltipPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_tooltip.svg");
    }

    private SetRedlineTooltipDialog getDialog(PlugInContext context) {
        if (this.setRedlineTooltipDialog == null) {
            this.setRedlineTooltipDialog = new SetRedlineTooltipDialog(context.getWorkbenchFrame());
            GUISupport.centreComponent((Component)this.setRedlineTooltipDialog, (Component)context.getWorkbenchFrame());
        }
        return this.setRedlineTooltipDialog;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SetRedlineTooltipDialog dlg = this.getDialog(context);
        SelectionManager selMngr = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        Iterator<Layer> iLy = selMngr.getLayersWithSelectedItems().iterator();
        String strTooltipSuggestion = "";
        while (iLy.hasNext()) {
            Layer ly = iLy.next();
            if (!(ly instanceof AbstractCadLayer) || ly instanceof CadLayer && !this.doesShowTooltips((CadLayer)ly)) continue;
            Iterator<SimpleFeature> iSel = selMngr.getFeaturesWithSelectedItems(ly).iterator();
            while (iSel.hasNext()) {
                strTooltipSuggestion = ObjectUtils.toString((Object)FeatureUtil.getAttribute((SimpleFeature)iSel.next(), (String)CadFeatureAtts.NAME.getName())).trim();
            }
            if (strTooltipSuggestion.isEmpty()) continue;
            break;
        }
        if (strTooltipSuggestion.isEmpty()) {
            dlg.setVisible(true);
        } else {
            dlg.setVisible(strTooltipSuggestion);
        }
        if (!dlg.wasOkPressed()) {
            return true;
        }
        String strTooltip = dlg.getTooltipText();
        ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
        for (Layer ly : selMngr.getLayersWithSelectedItems()) {
            if (!(ly instanceof AbstractCadLayer) || ly instanceof CadLayer && !this.doesShowTooltips((CadLayer)ly)) continue;
            ArrayList<SimpleFeature> lstOldFeatures = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
            for (SimpleFeature featOld : selMngr.getFeaturesWithSelectedItems(ly)) {
                SimpleFeature featNew = FeatureUtil.cloneFeature((SimpleFeature)featOld, (boolean)false);
                FeatureUtil.setAttribute((SimpleFeature)featNew, (String)CadFeatureAtts.NAME.getName(), (Object)strTooltip);
                lstOldFeatures.add(featOld);
                lstNewFeatures.add(featNew);
            }
            lstCommands.add(this.createSetTooltipCommand((AbstractCadLayer)ly, lstNewFeatures, lstOldFeatures));
        }
        AbstractPlugIn.execute(lstCommands, (LayerManagerProxy)context, true);
        return true;
    }

    private boolean doesShowTooltips(CadLayer cadLayer) {
        StyleCollection sCol;
        CadStyleModel cadStyle;
        boolean doesShowTooltips = false;
        Iterator<StyleCollection> iterator = cadLayer.getStyleCollections().iterator();
        while (iterator.hasNext() && (cadStyle = (sCol = iterator.next()).getStyle(CadStyleModel.class)).isShowTooltips()) {
            doesShowTooltips = true;
        }
        return doesShowTooltips;
    }

    private UndoableCommand createSetTooltipCommand(final AbstractCadLayer cadlayer, final Collection colNewFeatures, final Collection colOldFeatures) {
        UndoableCommand command = new UndoableCommand(this, "SetCadLayerTooltip"){

            @Override
            public void execute() {
                cadlayer.editFeature(colNewFeatures, 2);
            }

            @Override
            public void unexecute() {
                cadlayer.editFeature(colOldFeatures, 2);
            }
        };
        return command;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1)).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Collection<Layer> colLy = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems();
                for (Layer ly : colLy) {
                    if (!(ly instanceof AbstractCadLayer)) continue;
                    if (ly instanceof RedlineLayer) {
                        return null;
                    }
                    if (ly instanceof CadLayer) {
                        StyleCollection sCol;
                        CadStyleModel cadStyle;
                        boolean doesShowTooltips = false;
                        Iterator<StyleCollection> iterator = ly.getStyleCollections().iterator();
                        while (iterator.hasNext() && (cadStyle = (sCol = iterator.next()).getStyle(CadStyleModel.class)).isShowTooltips()) {
                            doesShowTooltips = true;
                        }
                        if (!doesShowTooltips) continue;
                    }
                    if (!FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)ly.getFeatureType(), (String)CadFeatureAtts.NAME.getName())) continue;
                    return null;
                }
                return "At least one feature on redline or cadlayer has to be selected.";
            }
        });
    }
}

