/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang3.ObjectUtils;

public class SetRedlineTooltipDialog
extends JDialog {
    private static final String KEY_LAST_REDLINE_TOOLTIPS = SetRedlineTooltipDialog.class.getName() + "_LAST_REDLINE_TOOLTIPS";
    private final Blackboard bb = PersistentBlackboardPlugIn.get();
    private final List<String> lstLastTooltips = new ArrayList<String>();
    private boolean blockEvents = false;
    private JComboBox cmbLastEntries;
    private JScrollPane jScrollPane1;
    private JLabel lblLastEntries;
    private JLabel lblTooltip;
    private OKCancelPanel oKCancelPanel;
    private JTextArea txaTooltip;

    public SetRedlineTooltipDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.i18n();
        this.setSize(300, 300);
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.layer.redline.SetRedlineTooltipDialog.title"));
        this.lblLastEntries.setText(I18N.get("ui.plugin.layer.redline.SetRedlineTooltipDialog.last-entries"));
        this.lblTooltip.setText(I18N.get("ui.plugin.layer.redline.SetRedlineTooltipDialog.tooltip-text"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCombo() {
        this.blockEvents = true;
        try {
            this.lstLastTooltips.clear();
            this.lstLastTooltips.addAll((List)this.bb.get(KEY_LAST_REDLINE_TOOLTIPS, new ArrayList()));
            this.cmbLastEntries.removeAllItems();
            String strLastEntry = "";
            for (String strEntry : this.lstLastTooltips) {
                this.cmbLastEntries.addItem(strEntry);
                strLastEntry = strEntry;
            }
            this.cmbLastEntries.setSelectedItem(strLastEntry);
            this.setTooltipText(strLastEntry);
        }
        finally {
            this.blockEvents = false;
        }
    }

    public void setTooltipText(String strTooltip) {
        this.txaTooltip.setText(strTooltip);
        this.txaTooltip.requestFocus();
        this.txaTooltip.selectAll();
    }

    public String getTooltipText() {
        return this.txaTooltip.getText();
    }

    public boolean wasOkPressed() {
        return this.oKCancelPanel.wasOKPressed();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.initCombo();
        }
        super.setVisible(visible);
    }

    public void setVisible(String strTooltipSuggestion) {
        this.initCombo();
        this.setTooltipText(strTooltipSuggestion);
        super.setVisible(true);
    }

    private void initComponents() {
        this.lblLastEntries = new JLabel();
        this.cmbLastEntries = new JComboBox();
        this.lblTooltip = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txaTooltip = new JTextArea();
        this.oKCancelPanel = new OKCancelPanel();
        this.setTitle("Tooltips setzen");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblLastEntries.setText("Letzte Eingaben:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblLastEntries, gridBagConstraints);
        this.cmbLastEntries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetRedlineTooltipDialog.this.cmbLastEntries_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbLastEntries, gridBagConstraints);
        this.lblTooltip.setText("Tooltiptext:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        this.getContentPane().add((Component)this.lblTooltip, gridBagConstraints);
        this.txaTooltip.setColumns(20);
        this.txaTooltip.setLineWrap(true);
        this.txaTooltip.setRows(5);
        this.txaTooltip.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.txaTooltip);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.oKCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetRedlineTooltipDialog.this.okCancelPanel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.oKCancelPanel, gridBagConstraints);
        this.pack();
    }

    private void okCancelPanel_onActionPerformed(ActionEvent evt) {
        if (this.oKCancelPanel.wasOKPressed()) {
            this.lstLastTooltips.remove(this.getTooltipText());
            this.lstLastTooltips.add(this.getTooltipText());
            while (this.lstLastTooltips.size() > 10) {
                this.lstLastTooltips.remove(0);
            }
            this.bb.put(KEY_LAST_REDLINE_TOOLTIPS, new ArrayList<String>(this.lstLastTooltips));
        }
        this.setVisible(false);
    }

    private void cmbLastEntries_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.setTooltipText(ObjectUtils.toString((Object)this.cmbLastEntries.getSelectedItem()));
    }
}

