/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineStylePanel;
import de.riwagis.icons.IconLoader;
import javax.swing.ImageIcon;

public class SetRedlineLayerStylePlugIn
extends AbstractPlugIn {
    private RedlineStylePanel pnlRedline = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.redline.SetRedlineLayerStylePlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_palette.svg");
    }

    @Override
    public boolean execute(PlugInContext context) {
        if (this.pnlRedline == null) {
            this.pnlRedline = new RedlineStylePanel();
        }
        if (WorkbenchContext.getFrame().getDesktopPanel().getNullOrTabLeft(this.pnlRedline) == null) {
            WorkbenchContext.getFrame().getDesktopPanel().addLeftPane(this.getName(), "", this.pnlRedline, null, null);
        }
        WorkbenchContext.getFrame().getDesktopPanel().setLeftTabsVisible(true);
        this.pnlRedline.updateComponentsForCurrentLayer();
        WorkbenchContext.getFrame().getDesktopPanel().selectPane(this.pnlRedline);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            EditingPanel editingPanel = EditingPanel.instanceOf();
            String frameActive = editingPanel.getInternalFrameActiveCheck().check(component);
            if (frameActive != null) {
                return frameActive;
            }
            if (editingPanel.getCurrentLayer() == null || editingPanel.getCurrentLayer().getFMD() == null) {
                return "No editable layer";
            }
            if (!(editingPanel.getCurrentLayer() instanceof RedlineLayer) && !(editingPanel.getCurrentLayer() instanceof CadLayer)) {
                return "No redline or cad layer selected.";
            }
            return null;
        };
    }
}

