/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStore;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.apache.commons.lang3.StringUtils;

public class SaveRedlineLayerPlugIn
extends AbstractPlugIn {
    public static final String CURRENT_FILE_KEY = String.valueOf(SaveRedlineLayerPlugIn.class) + " - FILE";
    PlugInContext context = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.SaveRedlineLayerPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.context = _context;
        final String strFile = SaveRedlineLayerPlugIn.chooseFile(this.getLayer());
        if (StringUtils.isEmpty((CharSequence)strFile)) {
            return false;
        }
        final WaitDialog dlgWait = new WaitDialog((Window)this.context.getWorkbenchFrame(), I18N.get("common.wait"), new Runnable(this){

            @Override
            public void run() {
            }
        });
        Runnable run = new Runnable(){

            @Override
            public void run() {
                RedlineLayer rly = SaveRedlineLayerPlugIn.this.getLayer();
                try {
                    rly.setFile(new File(strFile));
                    rly.commitEditedFeatures();
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this.context.getWorkbenchFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
        }
        return true;
    }

    RedlineLayer getLayer() {
        return (RedlineLayer)this.context.getSelectedLayer(0);
    }

    private static String addSuffix(String str, String strSuffix) {
        if (str.toLowerCase().endsWith(strSuffix.toLowerCase())) {
            return str;
        }
        return str + strSuffix;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RedlineLayer.class));
    }

    public static String chooseFile(RedlineLayer rly) throws IOException {
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(RedlineLayerUtils.RLY_FILE_FILTER);
        fileChooser.setFileFilter(RedlineLayerUtils.RLY_FILE_FILTER);
        Blackboard bb = PersistentBlackboardPlugIn.get();
        RedlineDataStore ds = rly.getDataStore();
        File file = ds.getFileInternal();
        if (file == null) {
            if (bb.contains(CURRENT_FILE_KEY)) {
                String strPath = (String)bb.get(CURRENT_FILE_KEY);
                fileChooser.setCurrentDirectory(new File(strPath).getParentFile());
            }
            fileChooser.setSelectedFile(new File(SaveRedlineLayerPlugIn.addSuffix(rly.getName(), ".rly")));
        } else {
            fileChooser.setSelectedFile(file);
        }
        int state = fileChooser.showSaveDialog(JUMPWorkbench.getFrame());
        if (state == 1 || state == -1) {
            return null;
        }
        String strFileTmp = fileChooser.getSelectedFile().toString();
        if (!strFileTmp.toLowerCase().endsWith(".rly")) {
            strFileTmp = SaveRedlineLayerPlugIn.addSuffix(strFileTmp, ".rly");
        }
        String strFile = strFileTmp;
        bb.put(CURRENT_FILE_KEY, strFile);
        return strFile;
    }
}

