/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineStylePanel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.icons.IconLoader;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.tuple.Pair;
import org.opengis.feature.simple.SimpleFeature;

public class RetrieveRedlineStylePlugIn
extends AbstractPlugIn {
    private RedlineStylePanel rStylePanel = null;

    public RetrieveRedlineStylePlugIn(RedlineStylePanel rStylePanel) {
        this.rStylePanel = rStylePanel;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.redline.RetrieveRedlineStylePlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_style_get.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        AbstractCadLayer currentLy = this.rStylePanel.getCurrentLayer();
        if (currentLy == null) {
            return false;
        }
        SelectionManager selMngr = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        selMngr.getLayersWithSelectedItems().stream().filter(ly -> this.isSameCadOrBothRedlineLayer((Layer)ly, currentLy)).flatMap(ly -> selMngr.getFeaturesWithSelectedItems((Layer)ly).stream().map(feature -> Pair.of((Object)ly, (Object)feature))).findFirst().ifPresent(layerAndFeature -> {
            RedlineLayerUtils.addSymbolAndFillIfNecessary(currentLy, (AbstractCadLayer)layerAndFeature.getLeft(), (SimpleFeature)layerAndFeature.getRight());
            currentLy.copyStyleToDefaultFeature((SimpleFeature)layerAndFeature.getRight());
            this.rStylePanel.updateComponentsForCurrentLayer();
        });
        return true;
    }

    private boolean isSameCadOrBothRedlineLayer(Layer ly, AbstractCadLayer currentLy) {
        return ly instanceof AbstractCadLayer && (ly == currentLy || ly instanceof RedlineLayer && currentLy instanceof RedlineLayer);
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createExactlyNFeaturesMustBeSelectedCheck(1)).add(component -> {
            if (this.rStylePanel == null) {
                return "No RedlineStylePanel found in PlugIn.";
            }
            AbstractCadLayer cLy = this.rStylePanel.getCurrentLayer();
            Collection<Layer> colLy = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems();
            for (Layer ly : colLy) {
                if (!(ly instanceof AbstractCadLayer)) continue;
                if (cLy instanceof RedlineLayer && ly instanceof RedlineLayer) {
                    return null;
                }
                if (cLy != ly) continue;
                return null;
            }
            return "At least one feature on redline or cadlayer has to be selected.";
        });
    }
}

