/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.DesktopPanelTabPanel;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.components.CloseablePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.SetCadLayerThemePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.AssignRedlineAttributesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.EditableNumberWithValidationJComboBox;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineDrawingStylePanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RetrieveRedlineStylePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.SetRedlineTooltipPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.style.LinePatternPanel;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.guitools.GUIUtil;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.model.style.AbstractCadStyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.gui.RedlineLayerSymbolListCellRenderer;
import de.riwagis.riwajump.symbol.gui.SymbolListDialog;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.gui.FontSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineStylePanel
extends JPanel
implements DesktopPanelTabPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineStylePanel.class);
    private static final long serialVersionUID = 8166990847589981707L;
    private AbstractCadLayer currentLy = null;
    private boolean blockEvents = false;
    private final Set<String> validFonts = new HashSet<String>();
    private final RedlineLayerSymbolListCellRenderer symbolCellRenderer = new RedlineLayerSymbolListCellRenderer();
    private static final String[] PREFERRED_FONTS = new String[]{"Liberation Sans", "Liberation Sans Narrow", "Liberation Serif", "Liberation Mono", "Noto Sans", "Noto Serif", "Noto Mono", "Arial", "Arial Black", "Century", "Courier New", "ISO", "SansSerif", "Tahoma", "Times New Roman", "Verdana"};
    private final List<Supplier<String>> validators = new ArrayList<Supplier<String>>();
    private ColorChooserPanel areaColorChooser;
    private JButton butChooseFill;
    private JButton butChooseSym;
    private JCheckBox cboShowArea;
    private JCheckBox cboShowFillPattern;
    private JComboBox<CadLayerSymbolDefinition> cmbFill;
    private EditableNumberWithValidationJComboBox<Float> cmbFillPatternWidth;
    private EditableNumberWithValidationJComboBox<Float> cmbLineWidth;
    private JComboBox<CadLayerSymbolDefinition> cmbSym;
    private EditableNumberWithValidationJComboBox<Float> cmbSymWidth;
    private JComboBox<String> cmbTextFont;
    private EditableNumberWithValidationJComboBox<Float> cmbTextHeight;
    private JLabel lblFillColor;
    private JLabel lblFillPattern;
    private JLabel lblFillPatternWidth;
    private JLabel lblLineColor;
    private JLabel lblLinePattern;
    private JLabel lblLineWidth;
    private JLabel lblSym;
    private JLabel lblSymWidth;
    private JLabel lblTextFont;
    private JLabel lblTextHeight;
    private JLabel lblTransparency;
    private JLabel lblTxtColor;
    private ColorChooserPanel lineColorChooser;
    private LinePatternPanel pnlLinePattern;
    private TransparencyPanel pnlTransparency;
    private RedlineDrawingStylePanel redlineDrawingStylePanel;
    private JScrollPane scrollPane;
    private JXTaskPaneContainer styleTaskPanel;
    private ToolboxPanel toolboxPanel;
    private JXTaskPane tpFill;
    private JXTaskPane tpLine;
    private JXTaskPane tpStyle;
    private JXTaskPane tpSymbol;
    private JXTaskPane tpText;
    private ColorChooserPanel txtColorChooser;

    public RedlineStylePanel() {
        this.initComponents();
        this.i18n();
        this.init();
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setGroupingUsed(false);
        EditingPanel.instanceOf().addDigiLayerChangedListener(e -> this.updateComponentsForCurrentLayer());
        this.updateComponentsForCurrentLayer();
    }

    private void registerValidatableCombobox(String fieldDescription, EditableNumberWithValidationJComboBox<Float> comboBox, Predicate<Double> validator, String invalidMessage) {
        comboBox.setValidator(value -> {
            double dVal = value.doubleValue();
            boolean isValid = validator.test(dVal);
            if (!isValid) {
                return I18N.get(invalidMessage);
            }
            return null;
        });
        this.validators.add(() -> {
            String validationError = comboBox.getValidationErrors();
            if (StringUtils.isNotBlank((CharSequence)validationError)) {
                return fieldDescription + " " + validationError;
            }
            return null;
        });
    }

    public String getValidationErrors() {
        String error = this.validators.stream().map(v -> (String)v.get()).filter(v -> v != null).collect(Collectors.joining("\n"));
        if (StringUtils.isBlank((CharSequence)error)) {
            return null;
        }
        return error;
    }

    @Override
    public void updateEnabledState() {
        this.toolboxPanel.updateEnabledState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateComponentsForCurrentLayer() {
        boolean bolBlockEventsTmp = this.blockEvents;
        this.blockEvents = true;
        try {
            Layer ly = EditingPanel.instanceOf().getCurrentLayer();
            if (ly instanceof AbstractCadLayer) {
                AbstractCadLayer cly = (AbstractCadLayer)ly;
                this.setCloseableTabPaneTitle(ly.getName());
                this.currentLy = cly;
                boolean isRedlineLayer = cly instanceof RedlineLayer;
                if (isRedlineLayer) {
                    RedlineLayer redlineLayer = (RedlineLayer)cly;
                    redlineLayer.updateSilently(() -> this.redlineDrawingStylePanel.updateDrawingStyles(redlineLayer));
                } else {
                    this.updatePanelState();
                }
                this.tpStyle.setVisible(isRedlineLayer);
            } else {
                this.setCloseableTabPaneTitle("");
                this.currentLy = null;
                this.updatePanelState();
                this.tpStyle.setVisible(false);
            }
        }
        catch (Exception e) {
            log.error("Error at updating components of RedlineStylePanel for current editable layer.", (Throwable)e);
            Assert.shouldNeverReachHere((String)("Error at updating components of RedlineStylePanel for current editable layer: " + e.getMessage()));
        }
        finally {
            this.blockEvents = bolBlockEventsTmp;
        }
    }

    private boolean getEnabledState(CadFeatureAtts attribute) {
        if (this.currentLy == null) {
            return false;
        }
        return FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)this.currentLy.getFeatureType(), (String)attribute.getName());
    }

    private void updateEnabledStateForLayer() {
        boolean enableSymbols = this.cmbSym.getItemCount() != 0;
        boolean enableAreas = this.cboShowArea.isEnabled() && this.cboShowArea.isSelected();
        boolean enableFillPatterns = this.cboShowFillPattern.isEnabled() && this.cboShowFillPattern.isSelected() && this.cmbFill.getItemCount() != 0;
        this.lblTxtColor.setEnabled(this.getEnabledState(CadFeatureAtts.TEXTCOLOR));
        this.txtColorChooser.setEnabled(this.getEnabledState(CadFeatureAtts.TEXTCOLOR));
        this.lblTextHeight.setEnabled(this.getEnabledState(CadFeatureAtts.TEXTSIZE));
        this.cmbTextHeight.setEnabled(this.getEnabledState(CadFeatureAtts.TEXTSIZE));
        this.lblTextFont.setEnabled(this.getEnabledState(CadFeatureAtts.TEXTFONT));
        this.cmbTextFont.setEnabled(this.getEnabledState(CadFeatureAtts.TEXTFONT));
        this.lblSym.setEnabled(this.getEnabledState(CadFeatureAtts.SYMBOL) && enableSymbols);
        this.cmbSym.setEnabled(this.getEnabledState(CadFeatureAtts.SYMBOL) && enableSymbols);
        this.butChooseSym.setEnabled(this.getEnabledState(CadFeatureAtts.SYMBOL));
        this.lblSymWidth.setEnabled(this.getEnabledState(CadFeatureAtts.SYMSIZE));
        this.cmbSymWidth.setEnabled(this.getEnabledState(CadFeatureAtts.SYMSIZE));
        this.lblLineColor.setEnabled(this.getEnabledState(CadFeatureAtts.LINECOLOR));
        this.lineColorChooser.setEnabled(this.getEnabledState(CadFeatureAtts.LINECOLOR));
        this.lblLinePattern.setEnabled(this.getEnabledState(CadFeatureAtts.LINEPATTERN));
        this.pnlLinePattern.setEnabled(this.getEnabledState(CadFeatureAtts.LINEPATTERN));
        this.lblLineWidth.setEnabled(this.getEnabledState(CadFeatureAtts.LINEWIDTH));
        this.cmbLineWidth.setEnabled(this.getEnabledState(CadFeatureAtts.LINEWIDTH));
        this.cboShowArea.setEnabled(this.getEnabledState(CadFeatureAtts.RENDERFILL));
        this.cboShowFillPattern.setEnabled(this.getEnabledState(CadFeatureAtts.FILL) && enableAreas);
        this.lblFillColor.setEnabled(this.getEnabledState(CadFeatureAtts.FILLCOLOR) && enableAreas);
        this.areaColorChooser.setEnabled(this.getEnabledState(CadFeatureAtts.FILLCOLOR) && enableAreas);
        this.lblFillPattern.setEnabled(this.getEnabledState(CadFeatureAtts.FILL) && enableFillPatterns);
        this.cmbFill.setEnabled(this.getEnabledState(CadFeatureAtts.FILL) && enableFillPatterns);
        this.butChooseFill.setEnabled(this.getEnabledState(CadFeatureAtts.FILL) && enableFillPatterns);
        this.lblFillPatternWidth.setEnabled(this.getEnabledState(CadFeatureAtts.FILL) && enableFillPatterns);
        this.cmbFillPatternWidth.setEnabled(this.getEnabledState(CadFeatureAtts.FILL) && enableFillPatterns);
        this.lblTransparency.setEnabled(this.getEnabledState(CadFeatureAtts.ALPHA) && enableAreas);
        this.pnlTransparency.setEnabled(this.getEnabledState(CadFeatureAtts.ALPHA) && enableAreas);
        if (!this.pnlTransparency.isEnabled()) {
            this.areaColorChooser.setAlpha(255);
        }
    }

    private void updateSymbolsForLayer() {
        this.cmbSym.removeAllItems();
        this.cmbFill.removeAllItems();
        if (this.currentLy == null) {
            this.symbolCellRenderer.setStore(null);
            return;
        }
        SymbolStore store = this.currentLy instanceof RedlineLayer ? ((RedlineLayer)this.currentLy).getRedlineSymbolStore().createReadOnlyWithGlobals() : this.currentLy.getSymbolStore();
        this.fillSymbolComboBox(this.cmbSym, store.getSymbolDefinitions());
        this.fillSymbolComboBox(this.cmbFill, store.getFillDefinitions());
        this.symbolCellRenderer.setStore(this.currentLy instanceof RedlineLayer ? ((RedlineLayer)this.currentLy).getRedlineSymbolStore() : null);
    }

    private void fillSymbolComboBox(JComboBox<CadLayerSymbolDefinition> cmbSym, Collection<CadLayerSymbolDefinition> lstSymDef) {
        if (lstSymDef == null || lstSymDef.isEmpty()) {
            return;
        }
        for (CadLayerSymbolDefinition symDef : lstSymDef) {
            cmbSym.addItem(symDef);
        }
    }

    private void setCloseableTabPaneTitle(String strTitle) {
        JTabbedPane tp = WorkbenchContext.getFrame().getDesktopPanel().getLeftTabbedPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            CloseablePanel closeablePanel;
            Component comp = tp.getComponent(i);
            if (!(comp instanceof CloseablePanel) || (closeablePanel = (CloseablePanel)comp).getComponent() != this) continue;
            closeablePanel.setTitle(strTitle);
            return;
        }
    }

    private void i18n() {
        this.tpStyle.setTitle(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.header-styles"));
        this.tpSymbol.setTitle(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.header-sym"));
        this.tpText.setTitle(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.header-text"));
        this.lblTxtColor.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.text-color"));
        this.lblTextHeight.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.text-height"));
        this.lblSym.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.symbol"));
        this.lblSymWidth.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.sym-width"));
        this.tpLine.setTitle(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.header-line"));
        this.lblLinePattern.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.line-type"));
        this.lblLineColor.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.line-color"));
        this.lblLineWidth.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.line-width"));
        this.tpFill.setTitle(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.header-fill"));
        this.cboShowArea.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.show-fill"));
        this.cboShowFillPattern.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.show-fill-pattern"));
        this.lblFillPattern.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.fill-pattern"));
        this.lblFillColor.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.fill-color"));
        this.lblFillPatternWidth.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.fill-pattern-width"));
        this.lblTransparency.setText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.transparency"));
        this.butChooseSym.setToolTipText(I18N.get("common.open"));
        this.butChooseFill.setToolTipText(I18N.get("common.open"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.blockEvents = true;
        try {
            this.styleTaskPanel.setBackground(this.getBackground());
            AssignRedlineAttributesPlugIn assignRedlineAttributesPlugIn = new AssignRedlineAttributesPlugIn(this);
            this.toolboxPanel.addPlugIn(assignRedlineAttributesPlugIn, assignRedlineAttributesPlugIn.createEnableCheck(), assignRedlineAttributesPlugIn.getIcon());
            RetrieveRedlineStylePlugIn retrieveSelectionAttributesPlugIn = new RetrieveRedlineStylePlugIn(this);
            this.toolboxPanel.addPlugIn(retrieveSelectionAttributesPlugIn, retrieveSelectionAttributesPlugIn.createEnableCheck(), retrieveSelectionAttributesPlugIn.getIcon());
            this.toolboxPanel.getToolBar().addSeparator(new Dimension(7, 25));
            SetRedlineTooltipPlugIn setRedlineTooltipPlugIn = new SetRedlineTooltipPlugIn();
            this.toolboxPanel.addPlugIn(setRedlineTooltipPlugIn, setRedlineTooltipPlugIn.createEnableCheck(), setRedlineTooltipPlugIn.getIcon());
            this.toolboxPanel.getToolBar().addSeparator(new Dimension(7, 25));
            SetCadLayerThemePlugIn setCadLayerThemePlugIn = new SetCadLayerThemePlugIn();
            this.toolboxPanel.addPlugIn(setCadLayerThemePlugIn, setCadLayerThemePlugIn.createEnableCheck(), setCadLayerThemePlugIn.getIcon());
            String[] arrLinePattern = AbstractCadLayer.getDefaultLinePatterns().toArray(new String[0]);
            this.pnlLinePattern.setLinePatterns(arrLinePattern);
            this.pnlLinePattern.setEditable(false);
            this.cmbTextHeight.addItem(Float.valueOf(6.0f));
            this.cmbTextHeight.addItem(Float.valueOf(8.0f));
            this.cmbTextHeight.addItem(Float.valueOf(10.0f));
            this.cmbTextHeight.addItem(Float.valueOf(12.0f));
            this.cmbTextHeight.addItem(Float.valueOf(14.0f));
            this.cmbTextHeight.addItem(Float.valueOf(16.0f));
            this.cmbTextHeight.addItem(Float.valueOf(18.0f));
            this.cmbTextHeight.addItem(Float.valueOf(20.0f));
            this.cmbSymWidth.addItem(Float.valueOf(5.0f));
            this.cmbSymWidth.addItem(Float.valueOf(10.0f));
            this.cmbSymWidth.addItem(Float.valueOf(15.0f));
            this.cmbSymWidth.addItem(Float.valueOf(20.0f));
            this.cmbSymWidth.addItem(Float.valueOf(25.0f));
            this.cmbSymWidth.addItem(Float.valueOf(30.0f));
            this.cmbSymWidth.addItem(Float.valueOf(35.0f));
            this.cmbSymWidth.addItem(Float.valueOf(40.0f));
            this.cmbSymWidth.addItem(Float.valueOf(45.0f));
            this.cmbSymWidth.addItem(Float.valueOf(50.0f));
            this.cmbSymWidth.addItem(Float.valueOf(55.0f));
            this.cmbSymWidth.addItem(Float.valueOf(60.0f));
            this.cmbLineWidth.addItem(Float.valueOf(0.0f));
            this.cmbLineWidth.addItem(Float.valueOf(1.0f));
            this.cmbLineWidth.addItem(Float.valueOf(2.0f));
            this.cmbLineWidth.addItem(Float.valueOf(3.0f));
            this.cmbLineWidth.addItem(Float.valueOf(4.0f));
            this.cmbLineWidth.addItem(Float.valueOf(5.0f));
            this.cmbLineWidth.addItem(Float.valueOf(7.0f));
            this.cmbLineWidth.addItem(Float.valueOf(9.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(5.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(10.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(15.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(20.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(25.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(30.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(35.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(40.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(45.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(50.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(55.0f));
            this.cmbFillPatternWidth.addItem(Float.valueOf(60.0f));
            this.cmbTextFont.setRenderer(new ListCellRenderer<String>(this){
                private final DefaultListCellRenderer wrappedRenderer = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel lbl = (JLabel)this.wrappedRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    Font lblFont = lbl.getFont();
                    lbl.setFont(Font.decode(lbl.getText() + " " + lblFont.getSize()));
                    return lbl;
                }
            });
            for (String font : PREFERRED_FONTS) {
                if (!FontSupport.isFontAvailable((String)font)) continue;
                this.cmbTextFont.addItem(font);
                this.validFonts.add(font);
            }
            this.pnlLinePattern.addActionListener(this::pnlLinePattern_onActionPerformed);
            this.initTaskPane(this.tpStyle, false);
            this.initTaskPane(this.tpText, true);
            this.initTaskPane(this.tpSymbol, true);
            this.initTaskPane(this.tpLine, true);
            this.initTaskPane(this.tpFill, true);
            this.txtColorChooser.setAlpha(255);
            this.lineColorChooser.setAlpha(255);
            this.cmbSym.setRenderer(this.symbolCellRenderer);
            this.cmbFill.setRenderer(this.symbolCellRenderer);
            this.pnlTransparency.addChangeListener(this::pnlTransparency_onStateChanged);
            this.redlineDrawingStylePanel.setParent(this);
            String invalid200Msg = "ui.plugin.layer.redline.RedlineStyleDialog.validation.error-not-in-range-0-200";
            String invalidInclusive200Msg = "ui.plugin.layer.redline.RedlineStyleDialog.validation.error-not-in-range-including-0-200";
            Predicate<Double> validator200 = dVal -> dVal > 0.0 && dVal <= 200.0;
            Predicate<Double> validatorInclusive200 = dVal -> dVal >= 0.0 && dVal <= 200.0;
            this.registerValidatableCombobox(this.tpLine.getTitle() + " \u2192 " + this.lblLineWidth.getText(), this.cmbLineWidth, validatorInclusive200, invalidInclusive200Msg);
            this.registerValidatableCombobox(this.tpFill.getTitle() + " \u2192 " + this.lblFillPatternWidth.getText(), this.cmbFillPatternWidth, validator200, invalid200Msg);
            this.registerValidatableCombobox(this.tpText.getTitle() + " \u2192 " + this.lblTextHeight.getText(), this.cmbTextHeight, validator200, invalid200Msg);
            this.registerValidatableCombobox(this.tpSymbol.getTitle() + " \u2192 " + this.lblSymWidth.getText(), this.cmbSymWidth, validator200, invalid200Msg);
        }
        finally {
            this.blockEvents = false;
        }
    }

    private void initTaskPane(JXTaskPane tp, boolean topSpacing) {
        JXPanel taskPanel = (JXPanel)tp.getContentPane();
        taskPanel.setOpaque(false);
        taskPanel.setBorder(BorderFactory.createEmptyBorder(topSpacing ? 3 : 0, 0, 3, 0));
    }

    public AbstractCadLayer getCurrentLayer() {
        return this.currentLy;
    }

    private void setStyleByFeature(SimpleFeature f) {
        Object objTxtColor = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXTCOLOR.getName());
        if (objTxtColor != null) {
            int rgbColor = ((Number)objTxtColor).intValue();
            this.txtColorChooser.setColor(new Color(rgbColor));
        } else {
            this.txtColorChooser.setColor(Color.RED);
        }
        Object objTxtSize = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXTSIZE.getName());
        this.cmbTextHeight.setSelectedItem(Objects.requireNonNullElse(objTxtSize, Float.valueOf(10.0f)));
        Object objTxtFont = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXTFONT.getName());
        if (objTxtFont != null && this.validFonts.contains(objTxtFont.toString())) {
            this.cmbTextFont.setSelectedItem(objTxtFont);
        } else {
            this.cmbTextFont.setSelectedItem(AbstractCadLayer.DEFAULT_FONT.getFamily());
        }
        Object objSymbol = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.SYMBOL.getName());
        if (objSymbol != null) {
            String strSymSVG = objSymbol.toString();
            this.selectSymbolBySymbolName(this.cmbSym, strSymSVG);
        } else if (this.cmbSym.getItemCount() > 0) {
            this.cmbSym.setSelectedIndex(0);
            if (this.currentLy != null) {
                // empty if block
            }
        }
        Object objSymbolSize = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.SYMSIZE.getName());
        this.cmbSymWidth.setSelectedItem(Objects.requireNonNullElse(objSymbolSize, Float.valueOf(30.0f)));
        Object objLineColor = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LINECOLOR.getName());
        if (objLineColor != null) {
            int rgbColor = ((Number)objLineColor).intValue();
            this.lineColorChooser.setColor(new Color(rgbColor));
        } else {
            this.lineColorChooser.setColor(Color.RED);
        }
        Object objLineWidth = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LINEWIDTH.getName());
        this.cmbLineWidth.setSelectedItem(Objects.requireNonNullElse(objLineWidth, Float.valueOf(2.0f)));
        Object objLinePattern = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LINEPATTERN.getName());
        if (objLinePattern != null) {
            this.pnlLinePattern.setSelectedPattern(objLinePattern.toString());
        } else {
            this.pnlLinePattern.setSelectedIndex(0);
        }
        this.cboShowArea.setSelected(FeatureUtil.getBooleanAttribute((SimpleFeature)f, (String)CadFeatureAtts.RENDERFILL.getName()));
        Object objFillColor = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.FILLCOLOR.getName());
        if (objFillColor != null) {
            int rgbColor = ((Number)objFillColor).intValue();
            this.areaColorChooser.setColor(new Color(rgbColor));
        } else {
            this.areaColorChooser.setColor(Color.RED);
        }
        Object objFill = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.FILL.getName());
        this.cboShowFillPattern.setSelected(StringUtils.isNotEmpty((CharSequence)((String)objFill)));
        if (objFill != null) {
            String strFillSVG = objFill.toString();
            this.selectSymbolBySymbolName(this.cmbFill, strFillSVG);
        } else if (this.cmbFill.getItemCount() > 0) {
            this.cmbFill.setSelectedIndex(0);
            if (this.currentLy == null || !this.cboShowFillPattern.isSelected() || this.cboShowFillPattern.isEnabled()) {
                // empty if block
            }
        }
        Object objFillPatternSize = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.FILLWIDTH.getName());
        this.cmbFillPatternWidth.setSelectedItem(Objects.requireNonNullElse(objFillPatternSize, Float.valueOf(20.0f)));
        Object objTransparency = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.ALPHA.getName());
        this.pnlTransparency.setColor(this.areaColorChooser.getColor());
        if (objTransparency != null) {
            int alpha = ((Number)objTransparency).intValue();
            this.areaColorChooser.setAlpha(alpha);
            this.pnlTransparency.getSlider().setValue(255 - alpha);
        } else {
            this.pnlTransparency.getSlider().setValue(0);
            this.areaColorChooser.setAlpha(255);
        }
    }

    private void selectSymbolBySymbolName(JComboBox<CadLayerSymbolDefinition> symCombo, String strSymName) {
        if (strSymName == null) {
            if (symCombo.getItemCount() > 0) {
                symCombo.setSelectedIndex(0);
            }
            return;
        }
        for (int i = 0; i < symCombo.getItemCount(); ++i) {
            CadLayerSymbolDefinition symDef = symCombo.getItemAt(i);
            if (!symDef.getSymbolName().equals(strSymName)) continue;
            symCombo.setSelectedIndex(i);
            return;
        }
    }

    private SymbolListDialog createSymbolListDialog() {
        SymbolListDialog dlgSymList = null;
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent instanceof Frame) {
            dlgSymList = new SymbolListDialog((Frame)parent, true);
        }
        if (parent instanceof Dialog) {
            dlgSymList = new SymbolListDialog((Dialog)parent, true);
        }
        GUIUtil.centreOnScreen(dlgSymList);
        return dlgSymList;
    }

    private String getSymbolStoreName(AbstractCadLayer cly) {
        Collection<StyleCollection> lstSCol = cly.getStyleCollections();
        String strSymStore = null;
        for (StyleCollection sCol : lstSCol) {
            AbstractCadStyleModel cadStyle = sCol.getStyle(AbstractCadStyleModel.class);
            String strTmpSymStore = cadStyle.getStrSymStore();
            if (strTmpSymStore == null) continue;
            if (strSymStore == null) {
                strSymStore = strTmpSymStore;
                continue;
            }
            if (strSymStore.equals(strTmpSymStore)) continue;
            strSymStore = null;
            break;
        }
        return strSymStore;
    }

    private void pnlTransparency_onStateChanged(ChangeEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        int alpha = this.pnlTransparency.getAlpha();
        this.setStyleAttribute(CadFeatureAtts.ALPHA, alpha);
        this.areaColorChooser.setAlpha(alpha);
    }

    private void pnlLinePattern_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        this.setStyleAttribute(CadFeatureAtts.LINEPATTERN, this.pnlLinePattern.getSelectedPattern());
    }

    private void setStyleAttribute(CadFeatureAtts attribute, Object value, boolean fireMetaDataChanged) {
        Object oldValue = FeatureUtil.getAttribute((SimpleFeature)this.currentLy.getDefaultFeature(), (String)attribute.getName());
        if (Objects.equals(oldValue, value)) {
            return;
        }
        FeatureUtil.setAttribute((SimpleFeature)this.currentLy.getDefaultFeature(), (String)attribute.getName(), (Object)value);
        if (fireMetaDataChanged && this.currentLy instanceof RedlineLayer) {
            this.redlineDrawingStylePanel.setStyleChanged(true);
        }
    }

    private void setStyleAttribute(CadFeatureAtts attribute, Object value) {
        this.setStyleAttribute(attribute, value, true);
    }

    private void initComponents() {
        this.toolboxPanel = new ToolboxPanel();
        this.scrollPane = new JScrollPane();
        this.styleTaskPanel = new JXTaskPaneContainer();
        this.tpStyle = new JXTaskPane();
        this.redlineDrawingStylePanel = new RedlineDrawingStylePanel();
        this.tpText = new JXTaskPane();
        this.txtColorChooser = new ColorChooserPanel();
        this.lblTxtColor = new JLabel();
        this.lblTextHeight = new JLabel();
        this.cmbTextHeight = new EditableNumberWithValidationJComboBox();
        this.lblTextFont = new JLabel();
        this.cmbTextFont = new JComboBox();
        this.tpSymbol = new JXTaskPane();
        this.lblSym = new JLabel();
        this.cmbSym = new JComboBox();
        this.lblSymWidth = new JLabel();
        this.cmbSymWidth = new EditableNumberWithValidationJComboBox();
        this.butChooseSym = new JButton();
        this.tpLine = new JXTaskPane();
        this.lblLineWidth = new JLabel();
        this.pnlLinePattern = new LinePatternPanel();
        this.lblLineColor = new JLabel();
        this.lineColorChooser = new ColorChooserPanel();
        this.lblLinePattern = new JLabel();
        this.cmbLineWidth = new EditableNumberWithValidationJComboBox();
        this.tpFill = new JXTaskPane();
        this.cmbFillPatternWidth = new EditableNumberWithValidationJComboBox();
        this.lblFillPatternWidth = new JLabel();
        this.cboShowFillPattern = new JCheckBox();
        this.cmbFill = new JComboBox();
        this.lblFillPattern = new JLabel();
        this.areaColorChooser = new ColorChooserPanel();
        this.lblFillColor = new JLabel();
        this.cboShowArea = new JCheckBox();
        this.lblTransparency = new JLabel();
        this.pnlTransparency = new TransparencyPanel();
        this.butChooseFill = new JButton();
        this.setMinimumSize(new Dimension(220, 430));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(220, 430));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                RedlineStylePanel.this.formComponentResized(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.toolboxPanel, gridBagConstraints);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.styleTaskPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.styleTaskPanel.setLayout((LayoutManager)new GridBagLayout());
        this.tpStyle.setToolTipText("");
        this.tpStyle.setCollapsed(true);
        this.tpStyle.setTitle("Stilverwaltung");
        this.tpStyle.add((Component)this.redlineDrawingStylePanel, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.styleTaskPanel.add((Component)this.tpStyle, (Object)gridBagConstraints);
        this.tpText.setToolTipText("");
        this.tpText.setTitle("Texte");
        this.tpText.setLayout((LayoutManager)new GridBagLayout());
        this.txtColorChooser.addActionListener(this::txtColorChooser_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.tpText.add((Component)this.txtColorChooser, (Object)gridBagConstraints);
        this.lblTxtColor.setHorizontalAlignment(4);
        this.lblTxtColor.setText("Farbe:");
        this.lblTxtColor.setMinimumSize(new Dimension(60, 14));
        this.lblTxtColor.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpText.add((Component)this.lblTxtColor, (Object)gridBagConstraints);
        this.lblTextHeight.setHorizontalAlignment(4);
        this.lblTextHeight.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpText.add((Component)this.lblTextHeight, (Object)gridBagConstraints);
        this.cmbTextHeight.setEditable(true);
        this.cmbTextHeight.addActionListener(this::cmbTextHeight_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.tpText.add(this.cmbTextHeight, (Object)gridBagConstraints);
        this.lblTextFont.setText("Schrift:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.tpText.add((Component)this.lblTextFont, (Object)gridBagConstraints);
        this.cmbTextFont.addActionListener(this::cmbTextFont_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.tpText.add(this.cmbTextFont, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.styleTaskPanel.add((Component)this.tpText, (Object)gridBagConstraints);
        this.tpSymbol.setTitle("Symbole");
        this.tpSymbol.setLayout((LayoutManager)new GridBagLayout());
        this.lblSym.setHorizontalAlignment(4);
        this.lblSym.setText("Symbol:");
        this.lblSym.setMinimumSize(new Dimension(60, 14));
        this.lblSym.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpSymbol.add((Component)this.lblSym, (Object)gridBagConstraints);
        this.cmbSym.addActionListener(this::cmbSym_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 2);
        this.tpSymbol.add(this.cmbSym, (Object)gridBagConstraints);
        this.lblSymWidth.setHorizontalAlignment(4);
        this.lblSymWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.tpSymbol.add((Component)this.lblSymWidth, (Object)gridBagConstraints);
        this.cmbSymWidth.setEditable(true);
        this.cmbSymWidth.addActionListener(this::cmbSymWidth_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.tpSymbol.add(this.cmbSymWidth, (Object)gridBagConstraints);
        this.butChooseSym.setText("...");
        this.butChooseSym.setMargin(new Insets(0, 2, 0, 2));
        this.butChooseSym.setPreferredSize(new Dimension(22, 20));
        this.butChooseSym.addActionListener(this::butChooseSym_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpSymbol.add((Component)this.butChooseSym, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.styleTaskPanel.add((Component)this.tpSymbol, (Object)gridBagConstraints);
        this.tpLine.setTitle("Linien");
        this.tpLine.setLayout((LayoutManager)new GridBagLayout());
        this.lblLineWidth.setHorizontalAlignment(4);
        this.lblLineWidth.setText("Dicke:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.tpLine.add((Component)this.lblLineWidth, (Object)gridBagConstraints);
        this.pnlLinePattern.setPreferredSize(new Dimension(100, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.tpLine.add((Component)this.pnlLinePattern, (Object)gridBagConstraints);
        this.lblLineColor.setHorizontalAlignment(4);
        this.lblLineColor.setText("Farbe:");
        this.lblLineColor.setMinimumSize(new Dimension(60, 14));
        this.lblLineColor.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpLine.add((Component)this.lblLineColor, (Object)gridBagConstraints);
        this.lineColorChooser.addActionListener(this::lineColorChooser_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.tpLine.add((Component)this.lineColorChooser, (Object)gridBagConstraints);
        this.lblLinePattern.setHorizontalAlignment(4);
        this.lblLinePattern.setText("Art:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpLine.add((Component)this.lblLinePattern, (Object)gridBagConstraints);
        this.cmbLineWidth.setEditable(true);
        this.cmbLineWidth.addActionListener(this::cmbLineWidth_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.tpLine.add(this.cmbLineWidth, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.styleTaskPanel.add((Component)this.tpLine, (Object)gridBagConstraints);
        this.tpFill.setTitle("Fl\u00e4chen");
        this.tpFill.setLayout((LayoutManager)new GridBagLayout());
        this.cmbFillPatternWidth.setEditable(true);
        this.cmbFillPatternWidth.addActionListener(this::cmbFillPatternWidth_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.tpFill.add(this.cmbFillPatternWidth, (Object)gridBagConstraints);
        this.lblFillPatternWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.tpFill.add((Component)this.lblFillPatternWidth, (Object)gridBagConstraints);
        this.cboShowFillPattern.setText("Schraffur darstellen");
        this.cboShowFillPattern.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboShowFillPattern.addActionListener(this::cboShowFillPattern_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tpFill.add((Component)this.cboShowFillPattern, (Object)gridBagConstraints);
        this.cmbFill.addActionListener(this::cmbFill_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 2);
        this.tpFill.add(this.cmbFill, (Object)gridBagConstraints);
        this.lblFillPattern.setHorizontalAlignment(4);
        this.lblFillPattern.setText("Schraffur:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpFill.add((Component)this.lblFillPattern, (Object)gridBagConstraints);
        this.areaColorChooser.addActionListener(this::areaColorChooser_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.tpFill.add((Component)this.areaColorChooser, (Object)gridBagConstraints);
        this.lblFillColor.setHorizontalAlignment(4);
        this.lblFillColor.setText("Farbe:");
        this.lblFillColor.setMinimumSize(new Dimension(60, 14));
        this.lblFillColor.setPreferredSize(new Dimension(60, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.tpFill.add((Component)this.lblFillColor, (Object)gridBagConstraints);
        this.cboShowArea.setText("F\u00fcllung darstellen");
        this.cboShowArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboShowArea.setMargin(new Insets(0, 0, 0, 0));
        this.cboShowArea.addActionListener(this::cboShowArea_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tpFill.add((Component)this.cboShowArea, (Object)gridBagConstraints);
        this.lblTransparency.setText("Transparenz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tpFill.add((Component)this.lblTransparency, (Object)gridBagConstraints);
        this.pnlTransparency.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.tpFill.add((Component)this.pnlTransparency, (Object)gridBagConstraints);
        this.butChooseFill.setText("...");
        this.butChooseFill.setMargin(new Insets(0, 2, 0, 2));
        this.butChooseFill.setPreferredSize(new Dimension(22, 20));
        this.butChooseFill.addActionListener(this::butChooseFill_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tpFill.add((Component)this.butChooseFill, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.styleTaskPanel.add((Component)this.tpFill, (Object)gridBagConstraints);
        this.scrollPane.setViewportView((Component)this.styleTaskPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    private boolean openSymbolListDialog(JComboBox<CadLayerSymbolDefinition> comboBox, boolean displaySymbols) {
        if (this.blockEvents || this.currentLy == null) {
            return true;
        }
        try {
            String strSymStore = this.getSymbolStoreName(this.currentLy);
            if (strSymStore == null || strSymStore.isEmpty()) {
                return true;
            }
            SymbolListDialog dlg = this.createSymbolListDialog();
            if (dlg == null) {
                log.error("Could not open SymbolListDialog.");
                return false;
            }
            SymbolStore store = RenderUtil.getSymbolStore(strSymStore, this.currentLy.getLayerManager().getTask());
            CadLayerSymbolDefinition selectedSymbol = (CadLayerSymbolDefinition)comboBox.getSelectedItem();
            RedlineLayerSymbolStore redlineStore = null;
            RedlineLayerSymbolStore tempStore = null;
            if (store instanceof RedlineLayerSymbolStore) {
                redlineStore = (RedlineLayerSymbolStore)store;
                tempStore = redlineStore.copyWithGlobals();
                dlg.setup(tempStore, displaySymbols, this.currentLy);
            } else {
                dlg.setup(store, displaySymbols, this.currentLy);
            }
            dlg.selectSymbol(selectedSymbol);
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                if (tempStore != null && redlineStore != null && dlg.isUserSymbolsChanged()) {
                    redlineStore.assign(tempStore);
                    RedlineLayer redlineLayer = (RedlineLayer)this.currentLy;
                    redlineLayer.setMetaDataModified(true);
                    this.updateSymbolsForLayer();
                    Tasks.submit(redlineLayer::saveHeaderToFile);
                }
                String strNewSym = dlg.getSymbolName();
                this.selectSymbolBySymbolName(comboBox, strNewSym);
            }
            dlg.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
        return false;
    }

    private void formComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(() -> {
            this.styleTaskPanel.setPreferredSize(new Dimension(this.scrollPane.getViewport().getExtentSize().width, this.styleTaskPanel.getPreferredSize().height));
            this.styleTaskPanel.revalidate();
        });
    }

    private void butChooseFill_onActionPerformed(ActionEvent evt) {
        this.openSymbolListDialog(this.cmbFill, false);
    }

    private void cboShowArea_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        if (this.cboShowArea.isSelected()) {
            this.setStyleAttribute(CadFeatureAtts.RENDERFILL, 1);
        } else {
            this.setStyleAttribute(CadFeatureAtts.RENDERFILL, 0);
        }
        this.updateEnabledStateForLayer();
    }

    private void areaColorChooser_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Color clrArea = this.areaColorChooser.getColor();
        this.setStyleAttribute(CadFeatureAtts.FILLCOLOR, clrArea.getRGB());
        this.pnlTransparency.setColor(clrArea);
    }

    private void cmbFill_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        if (!this.cboShowFillPattern.isSelected()) {
            this.setStyleAttribute(CadFeatureAtts.FILL, null);
            return;
        }
        CadLayerSymbolDefinition symDef = (CadLayerSymbolDefinition)this.cmbFill.getSelectedItem();
        if (symDef != null) {
            this.setStyleAttribute(CadFeatureAtts.FILL, symDef.getSymbolName());
        }
    }

    private void cboShowFillPattern_onActionPerformed(ActionEvent evt) {
        this.cmbFill_onActionPerformed(evt);
        this.updateEnabledStateForLayer();
    }

    private void cmbFillPatternWidth_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Float f = (Float)this.cmbFillPatternWidth.getSelectedItem();
        this.setStyleAttribute(CadFeatureAtts.FILLWIDTH, f);
    }

    private void cmbLineWidth_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Float f = (Float)this.cmbLineWidth.getSelectedItem();
        this.setStyleAttribute(CadFeatureAtts.LINEWIDTH, f);
    }

    private void lineColorChooser_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Color clrLine = this.lineColorChooser.getColor();
        this.setStyleAttribute(CadFeatureAtts.LINECOLOR, clrLine.getRGB());
    }

    private void butChooseSym_onActionPerformed(ActionEvent evt) {
        this.openSymbolListDialog(this.cmbSym, true);
    }

    private void cmbSymWidth_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Float f = (Float)this.cmbSymWidth.getSelectedItem();
        this.setStyleAttribute(CadFeatureAtts.SYMSIZE, f);
    }

    private void cmbSym_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        CadLayerSymbolDefinition symDef = (CadLayerSymbolDefinition)this.cmbSym.getSelectedItem();
        if (symDef != null) {
            this.setStyleAttribute(CadFeatureAtts.SYMBOL, symDef.getSymbolName());
        }
    }

    private void cmbTextFont_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        String strFont = Objects.toString(this.cmbTextFont.getSelectedItem(), "");
        if (strFont.isEmpty()) {
            this.setStyleAttribute(CadFeatureAtts.TEXTFONT, AbstractCadLayer.DEFAULT_FONT.getFamily());
        } else {
            this.setStyleAttribute(CadFeatureAtts.TEXTFONT, strFont);
        }
    }

    private void cmbTextHeight_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Float f = Float.valueOf(((Number)this.cmbTextHeight.getSelectedItem()).floatValue());
        this.setStyleAttribute(CadFeatureAtts.TEXTSIZE, f);
    }

    private void txtColorChooser_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents || this.currentLy == null) {
            return;
        }
        Color clrText = this.txtColorChooser.getColor();
        this.setStyleAttribute(CadFeatureAtts.TEXTCOLOR, clrText.getRGB());
    }

    public void updatePanelState() {
        SimpleFeature copyOfSettings = this.currentLy != null ? FeatureUtil.cloneFeature((SimpleFeature)this.currentLy.getDefaultFeature()) : null;
        this.updateSymbolsForLayer();
        this.setStyleByFeature(copyOfSettings);
        this.updateEnabledStateForLayer();
        this.updateEnabledState();
    }
}

