/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayerStyleDefinition;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStore;
import com.vividsolutions.jump.workbench.model.redline.RedlineFeatureInputStream;
import com.vividsolutions.jump.workbench.model.redline.RedlineFeatureOutputStream;
import com.vividsolutions.jump.workbench.model.redline.RedlineGlobalStyles;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityPanel;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineLayerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineLayerUtils.class);
    public static final int REDLINE_VERSION = 6;
    public static final int REDLINE_DRAW_STYLE_VERSION = 1;
    public static final FileFilter RLY_FILE_FILTER = GUIUtil.createFileFilter(I18N.get("ui.plugin.io.layer.SaveRedlineLayerPlugIn.FileFilterName"), new String[]{"rly"});
    public static final String MY_REDLINELAYERS_KEY = "MY_REDLINELAYERS";
    public static final String MY_REDLINELAYERS_CATEGORY_KEY = "MY_REDLINELAYERS_CATEGORY";
    private static final Map<Integer, Color> COLOR_MAP_VERSION1 = Map.ofEntries(Map.entry(12, Color.WHITE), Map.entry(0, Color.YELLOW), Map.entry(1, Color.PINK), Map.entry(2, Color.ORANGE), Map.entry(3, Color.RED), Map.entry(14, new Color(162, 255, 14)), Map.entry(4, Color.GREEN), Map.entry(5, Color.GREEN.darker()), Map.entry(13, Color.CYAN), Map.entry(6, Color.BLUE), Map.entry(7, Color.BLUE.darker()), Map.entry(8, Color.ORANGE.darker()), Map.entry(15, new Color(142, 77, 1)), Map.entry(9, Color.LIGHT_GRAY), Map.entry(10, Color.DARK_GRAY), Map.entry(11, Color.BLACK));

    public static void saveLayerToFile(RedlineLayer rly, File file, WaitDialog dlgWait) {
        RedlineLayerUtils.saveLayerToFile(rly, file, dlgWait, true);
    }

    public static void saveLayerToFile(RedlineLayer rly, File file, WaitDialog dlgWait, boolean withModifiedFeatures) {
        log.debug("saveRedlineLayer to " + String.valueOf(file));
        try {
            rly.setCRSDefinition(rly.getLayerManager().getTask().getCRSDefinition());
            RedlineDataStore ds = rly.getDataStore();
            ds.getInternalFeatureCollection();
            Collection<SimpleFeature> readFeatures = RedlineLayerUtils.readFeatures(rly, file, withModifiedFeatures);
            try (RedlineFeatureOutputStream fout = new RedlineFeatureOutputStream(rly, file, dlgWait);){
                fout.writeHeader();
                if (withModifiedFeatures) {
                    fout.writeFeatures();
                } else {
                    for (SimpleFeature f : readFeatures) {
                        fout.writeFeature(f);
                    }
                }
            }
            rly.setFile(file);
            rly.setMetaDataModified(false);
        }
        catch (Exception e) {
            log.error("error on writing " + rly.getName() + " to file " + String.valueOf(file), (Throwable)e);
            if (dlgWait != null) {
                dlgWait.setError(e);
            }
            throw new RuntimeException(e);
        }
    }

    private static Collection<SimpleFeature> readFeatures(RedlineLayer rly, File file, boolean withModifiedFeatures) throws IOException {
        if (withModifiedFeatures || !file.exists()) {
            return Collections.emptyList();
        }
        try (RedlineFeatureInputStream fin = new RedlineFeatureInputStream(file);){
            int version = fin.skipHeader();
            if (!RedlineLayerUtils.isRedlineVersionSupported(version)) {
                Assert.shouldNeverReachHere((String)("Unknown redline layer version: " + version));
            }
            Collection<SimpleFeature> collection = fin.readFeatures(rly.getFMD());
            return collection;
        }
    }

    public static void saveStylesToFile(RedlineLayer redlineLayer, Set<String> styles, File file, WaitDialog waitDialog) {
        block7: {
            log.debug("Saving Redline Layer Style Definition to " + String.valueOf(file));
            try (RedlineFeatureOutputStream fout = new RedlineFeatureOutputStream(redlineLayer, file, waitDialog);){
                fout.writeStylesDefinitionStandalone(styles);
            }
            catch (Exception e) {
                log.error("error on writing style from layer " + redlineLayer.getName() + " to file " + String.valueOf(file), (Throwable)e);
                if (waitDialog == null) break block7;
                waitDialog.setError(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<CadLayerStyleDefinition> readStylesFromFile(File file, WaitDialog waitDialog) {
        log.debug("Reading Redline Layer Style Definition from " + String.valueOf(file));
        if (!file.exists()) {
            log.error("Styles from file '{}' cannot be read.", (Object)file);
            return Optional.empty();
        }
        try (RedlineFeatureInputStream fin = new RedlineFeatureInputStream(file);){
            CadLayerStyleDefinition styles = fin.readStyleDefinitionStandalone();
            if (!RedlineLayerUtils.isStyleVersionSupported(styles.getVersion())) {
                Optional<CadLayerStyleDefinition> optional = Optional.empty();
                return optional;
            }
            Optional<CadLayerStyleDefinition> optional = Optional.of(styles);
            return optional;
        }
        catch (Exception e) {
            log.error("error on reading styles from file '" + String.valueOf(file) + "'", (Throwable)e);
            if (waitDialog == null) return Optional.empty();
            waitDialog.setError(e);
            return Optional.empty();
        }
    }

    public static Optional<String> addStylesAndSymbolsToLayer(RedlineLayer redlineLayer, File file, BinaryOperator<Set<String>> styleFilter) {
        Objects.requireNonNull(redlineLayer);
        Objects.requireNonNull(file);
        Objects.requireNonNull(styleFilter);
        Optional<CadLayerStyleDefinition> importedDefinitions = RedlineLayerUtils.readStylesFromFile(file, null);
        if (!importedDefinitions.isPresent()) {
            return Optional.empty();
        }
        CadLayerStyleDefinition styleDefinitions = importedDefinitions.orElseThrow();
        Map<String, SimpleFeature> layerStyles = redlineLayer.getDrawingStyles();
        Map<String, SimpleFeature> importedStyles = styleDefinitions.getStyles();
        Set existingStyles = importedStyles.keySet().stream().filter(layerStyles::containsKey).collect(Collectors.toUnmodifiableSet());
        Set filteredStyles = (Set)styleFilter.apply(existingStyles, importedStyles.keySet());
        RedlineGlobalStyles redlineGlobalStyles = RedlineGlobalStyles.getInstance();
        Map styles = filteredStyles.stream().collect(Collectors.partitioningBy(redlineGlobalStyles::isGlobalStyle, Collectors.toSet()));
        Set<String> stylesForFile = styles.get(false);
        Set<String> globalStyles = styles.get(true);
        Optional<String> firstEntry = RedlineLayerUtils.addOrUpdateStylesAndSymbols(redlineLayer, styleDefinitions, stylesForFile);
        if (!globalStyles.isEmpty()) {
            return redlineGlobalStyles.addOrUpdateGlobalStylesAndSymbols(styleDefinitions, globalStyles);
        }
        return firstEntry;
    }

    public static Optional<String> addOrUpdateStylesAndSymbols(RedlineLayer redlineLayer, CadLayerStyleDefinition styleDefinitions, Set<String> stylesForFile) {
        RedlineLayerSymbolStore redlineStore = redlineLayer.getRedlineSymbolStore();
        Map<String, SimpleFeature> importedStyles = styleDefinitions.getStyles();
        Map<CadLayerSymbolDefinition, ByteBuffer> importedSymbols = styleDefinitions.getSymbols();
        List<String> stylesToImport = RedlineLayerUtils.addStylesToLayer(importedStyles, stylesForFile, redlineLayer);
        RedlineLayerUtils.getRequiredSymbolsForStyles(stylesToImport, styleDefinitions).forEach(def -> redlineStore.addSymbolIfAbsent((CadLayerSymbolDefinition)def, (ByteBuffer)importedSymbols.get(def)));
        return stylesToImport.stream().findFirst();
    }

    private static List<String> addStylesToLayer(Map<String, SimpleFeature> importedStyles, Set<String> stylesNamesToImport, RedlineLayer redlineLayer) {
        List<String> stylesToImport = importedStyles.keySet().stream().filter(stylesNamesToImport::contains).sorted().collect(Collectors.toUnmodifiableList());
        stylesToImport.forEach(name -> redlineLayer.addOrReplaceDrawingStyle((String)name, (SimpleFeature)importedStyles.get(name)));
        return stylesToImport;
    }

    private static Stream<CadLayerSymbolDefinition> getRequiredSymbolsForStyles(List<String> stylesToImport, CadLayerStyleDefinition styleDefinitions) {
        Map<CadLayerSymbolDefinition, ByteBuffer> importedSymbols = styleDefinitions.getSymbols();
        Map<String, SimpleFeature> importedStyles = styleDefinitions.getStyles();
        Set symbolsToImport = stylesToImport.stream().map(importedStyles::get).flatMap(feature -> Stream.of((String)FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.SYMBOL.getName()), (String)FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.FILL.getName()))).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        return importedSymbols.keySet().stream().filter(def -> symbolsToImport.contains(def.getSymbolName()));
    }

    public static void readFeatures(RedlineLayer rly, File file) throws IOException {
        try (RedlineFeatureInputStream fin = new RedlineFeatureInputStream(file);){
            int version = fin.skipHeader();
            if (!RedlineLayerUtils.isRedlineVersionSupported(version)) {
                return;
            }
            Collection<SimpleFeature> features = fin.readFeatures(rly.getFMD());
            RedlineDataStore ds = rly.getDataStore();
            ds.addFeatures(features);
            rly.setFile(file);
            rly.setFiringEvents(true);
            int intFeaturesIgnored = fin.getNumFeaturesIgnored();
            if (intFeaturesIgnored > 0) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.plugin.io.layer.LoadRedlineLayerPlugIn.features-ignored", intFeaturesIgnored), (String)I18N.get("common.message"));
            }
        }
    }

    public static RedlineLayer createLayerFromFile(File file, LayerManager layMngr) throws IOException {
        boolean layMngrIsFiringEvents = layMngr.isFiringEvents();
        layMngr.setFiringEvents(false);
        try {
            RedlineFeatureInputStream.Header header;
            RedlineFeatureInputStream fin;
            block10: {
                RedlineLayer redlineLayer;
                fin = new RedlineFeatureInputStream(file);
                try {
                    header = fin.readHeader();
                    if (RedlineLayerUtils.isRedlineVersionSupported(header.getVersion())) break block10;
                    redlineLayer = null;
                }
                catch (Throwable throwable) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                fin.close();
                return redlineLayer;
            }
            RedlineLayer redlineLayer = RedlineLayerUtils.createAndInitializeLayer(fin, header, layMngr);
            fin.close();
            return redlineLayer;
        }
        finally {
            layMngr.setFiringEvents(layMngrIsFiringEvents);
        }
    }

    public static RedlineFeatureInputStream.Header readHeader(File file) throws IOException {
        try (RedlineFeatureInputStream fin = new RedlineFeatureInputStream(file);){
            RedlineFeatureInputStream.Header header = fin.readHeader();
            if (!RedlineLayerUtils.isRedlineVersionSupported(header.getVersion())) {
                RedlineFeatureInputStream.Header header2 = null;
                return header2;
            }
            RedlineFeatureInputStream.Header header3 = header;
            return header3;
        }
    }

    public static RedlineLayer readHeader(RedlineLayer layer, File redlineFile) throws IOException {
        if (redlineFile == null) {
            return layer;
        }
        try (RedlineFeatureInputStream fin = new RedlineFeatureInputStream(redlineFile);){
            RedlineFeatureInputStream.Header header = fin.readHeader();
            if (!RedlineLayerUtils.isRedlineVersionSupported(header.getVersion())) {
                RedlineLayer redlineLayer = null;
                return redlineLayer;
            }
            RedlineLayerUtils.addSymbolsAndStylesToLayer(header, layer);
            RedlineLayer redlineLayer = layer;
            return redlineLayer;
        }
    }

    private static RedlineLayer createAndInitializeLayer(RedlineFeatureInputStream input, RedlineFeatureInputStream.Header header, LayerManager layerManager) {
        RedlineLayer layer = new RedlineLayer(layerManager.uniqueLayerName(header.getName()), layerManager);
        layer.updateSilently(() -> {
            layer.setDrawScale(header.getDrawScale());
            if (header.getVersion() >= 3) {
                layer.setDescription(header.getDescription());
                layer.setRenderPrio(header.getRenderPrio());
                layer.setEditable(header.isEditable());
                layer.setSelectable(header.isSelectable());
                layer.setVisible(header.isVisible());
            }
            if (StringUtils.isNotEmpty((CharSequence)header.getCrsKey())) {
                layer.setCRSDefinition(CRSDefFactory.getCRSDefinition((String)header.getCrsKey()));
            }
            layer.setFile(input.getFile());
            RedlineLayerUtils.addSymbolsAndStylesToLayer(header, layer);
            layer.setMetaDataModified(false);
        });
        return layer;
    }

    private static void addSymbolsAndStylesToLayer(RedlineFeatureInputStream.Header header, RedlineLayer layer) {
        RedlineLayerSymbolStore redlineStore = layer.getRedlineSymbolStore();
        redlineStore.clear();
        header.getSymbols().forEach(redlineStore::addSymbol);
        layer.updateSilently(() -> {
            layer.clearDrawingStyles();
            header.getDrawingStyles().forEach(layer::addDrawingStyle);
            header.getDrawingStyles().keySet().stream().findFirst().ifPresent(layer::copyOverActiveFeatureFromStyle);
        });
    }

    private static boolean isVersionSupported(int expected, int actual) {
        if (actual > expected) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.plugin.io.layer.LoadRedlineLayerPlugIn.invalid-version", actual, expected), (String)I18N.get("common.error"));
            return false;
        }
        return true;
    }

    private static boolean isRedlineVersionSupported(int actual) {
        return RedlineLayerUtils.isVersionSupported(6, actual);
    }

    private static boolean isStyleVersionSupported(int actual) {
        return RedlineLayerUtils.isVersionSupported(1, actual);
    }

    public static void fixInvalidGeometry(SimpleFeature f) {
        Geometry geom = (Geometry)f.getDefaultGeometry();
        if (!geom.isValid()) {
            geom = geom.buffer(0.0);
            f.setDefaultGeometry((Object)geom);
        }
    }

    public static boolean ignoreFeature(FeaturestoreMetadata fmd, SimpleFeature f) {
        return f.getDefaultGeometry() == null || ((Geometry)f.getDefaultGeometry()).isEmpty() || !((Geometry)f.getDefaultGeometry()).isValid() || !fmd.isGeometryAllowed(f.getDefaultGeometry().getClass());
    }

    public static SimpleFeature convertRedlineFeatureByVersion(SimpleFeature feat, int version) {
        switch (version) {
            case 1: {
                Number numFillColor;
                Number numLineColor;
                Number numTxtColor;
                SimpleFeature newFeat = FeatureUtil.createFeature((SimpleFeatureType)RedlineLayer.REDLINE_FEATURE_TYPE, (String)feat.getID(), (Geometry)((Geometry)feat.getDefaultGeometry()));
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.NAME.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.NAME.getName()));
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.TEXT.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.TEXT.getName()));
                Number numTxtSize = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.TEXTSIZE.getName());
                if (numTxtSize != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.TEXTSIZE.getName(), (Object)Float.valueOf(numTxtSize.floatValue()));
                }
                if ((numTxtColor = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.TEXTCOLOR.getName())) != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.TEXTCOLOR.getName(), (Object)RedlineLayerUtils.convertColorVersion1(numTxtColor.intValue()));
                }
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.TEXTORI.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.TEXTORI.getName()));
                Number numSymSize = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.SYMSIZE.getName());
                if (numSymSize != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.SYMSIZE.getName(), (Object)Float.valueOf(numSymSize.floatValue()));
                }
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.SYMORI.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.SYMORI.getName()));
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.SYMBOL.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.SYMBOL.getName()));
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.LINEPATTERN.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.LINEPATTERN.getName()));
                Number numLineWidth = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.LINEWIDTH.getName());
                if (numLineWidth != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.LINEWIDTH.getName(), (Object)Float.valueOf(numLineWidth.floatValue()));
                }
                String strFill = (String)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.FILL.getName());
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.FILL.getName(), (Object)strFill);
                Boolean renderFill = (Boolean)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.RENDERFILL.getName());
                if (renderFill != null && renderFill.booleanValue()) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.RENDERFILL.getName(), (Object)1);
                } else {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.RENDERFILL.getName(), (Object)0);
                }
                Number numFillWidth = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.FILLWIDTH.getName());
                if (numFillWidth != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.FILLWIDTH.getName(), (Object)Float.valueOf(numFillWidth.floatValue()));
                }
                if ((numLineColor = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.LINECOLOR.getName())) != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.LINECOLOR.getName(), (Object)RedlineLayerUtils.convertColorVersion1(numLineColor.intValue()));
                }
                if ((numFillColor = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.FILLCOLOR.getName())) != null) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.FILLCOLOR.getName(), (Object)RedlineLayerUtils.convertColorVersion1(numFillColor.intValue()));
                }
                if (strFill != null && strFill.equalsIgnoreCase("hatch-transparent.svg")) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.ALPHA.getName(), (Object)90);
                } else {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.ALPHA.getName(), (Object)255);
                }
                Boolean isDim = (Boolean)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.ISDIM.getName());
                if (isDim != null && isDim.booleanValue()) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.ISDIM.getName(), (Object)1);
                } else {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.ISDIM.getName(), (Object)0);
                }
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.MTYPE.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.MTYPE.getName()));
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.MTEXT_ORI.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.MTEXT_ORI.getName()));
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.MTEXT.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.MTEXT.getName()));
                Boolean useOri = (Boolean)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.USE_ORI.getName());
                if (useOri != null && useOri.booleanValue()) {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.USE_ORI.getName(), (Object)1);
                } else {
                    FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.USE_ORI.getName(), (Object)0);
                }
                FeatureUtil.setAttribute((SimpleFeature)newFeat, (String)CadFeatureAtts.VP_SCALE.getName(), (Object)FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.VP_SCALE.getName()));
                return newFeat;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return feat;
            }
        }
        Assert.shouldNeverReachHere((String)("Unknown redline layer version: " + version));
        return null;
    }

    private static int convertColorVersion1(int colorKeyInMap) {
        if (COLOR_MAP_VERSION1.containsKey(colorKeyInMap)) {
            return COLOR_MAP_VERSION1.get(colorKeyInMap).getRGB();
        }
        return Color.RED.getRGB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMyRedlineLayers(Task task) {
        block13: {
            boolean isFiringEvents;
            LayerManager layerManager;
            block12: {
                layerManager = task.getLayerManager();
                isFiringEvents = layerManager.isFiringEvents();
                layerManager.setFiringEvents(false);
                Category catMyRedlineLayers = null;
                boolean fireAddedEvent = false;
                try {
                    List redlineLayerFiles;
                    Blackboard bb = PersistentBlackboardPlugIn.get();
                    if (bb.contains(MY_REDLINELAYERS_KEY) && !(redlineLayerFiles = (List)bb.get(MY_REDLINELAYERS_KEY)).isEmpty()) {
                        String catName = bb.get(MY_REDLINELAYERS_CATEGORY_KEY, StandardCategoryNames.MY_REDLINE_LAYERS);
                        catMyRedlineLayers = layerManager.getCategoryBuildIn(catName);
                        if (catMyRedlineLayers == null) {
                            catMyRedlineLayers = new Category();
                            catMyRedlineLayers.setName(catName);
                            catMyRedlineLayers.setLayerManager(layerManager);
                            layerManager.addCategoryBuildIn(catMyRedlineLayers);
                        }
                        for (File file : redlineLayerFiles) {
                            if (file.exists()) {
                                RedlineLayer redlineLayer = RedlineLayerUtils.createLayerFromFile(file, layerManager);
                                if (redlineLayer == null) continue;
                                redlineLayer.setCategory(catMyRedlineLayers);
                                fireAddedEvent = true;
                                continue;
                            }
                            WorkbenchContext.getFrame().warnUser(String.format(I18N.get("ui.plugin.options.common.RedlineLayerOptionsPanel.file-does-not-exists"), file.getAbsolutePath()));
                        }
                        VisibilityPanel.activateDefaultProfile(task.getLayerManager(), false);
                    }
                    if (!fireAddedEvent) break block12;
                    layerManager.setFiringEvents(true);
                }
                catch (IOException e) {
                    log.error("error loading my redlinelayers: ", (Throwable)e);
                    break block13;
                }
                finally {
                    if (fireAddedEvent) {
                        layerManager.setFiringEvents(true);
                        for (Layerable layer : catMyRedlineLayers.getLayerables()) {
                            if (!(layer instanceof RedlineLayer)) continue;
                            layerManager.fireLayerChanged(layer, LayerEventType.ADDED);
                        }
                    }
                    layerManager.setFiringEvents(isFiringEvents);
                }
                for (Layerable layer : catMyRedlineLayers.getLayerables()) {
                    if (!(layer instanceof RedlineLayer)) continue;
                    layerManager.fireLayerChanged(layer, LayerEventType.ADDED);
                }
            }
            layerManager.setFiringEvents(isFiringEvents);
        }
    }

    public static void addSymbolAndFillIfNecessary(Layer destLayer, AbstractCadLayer sourceLayer) {
        RedlineLayerUtils.addSymbolAndFillIfNecessary(destLayer, sourceLayer, sourceLayer.getDefaultFeature());
    }

    public static void addSymbolAndFillIfNecessary(Layer destLayer, AbstractCadLayer sourceLayer, SimpleFeature featureToCheck) {
        RedlineLayerUtils.addSymbolAndFillIfNecessary(destLayer, sourceLayer, featureToCheck, true);
    }

    public static void addSymbolAndFillIfNecessary(Layer destLayer, AbstractCadLayer sourceLayer, SimpleFeature featureToCheck, boolean async) {
        if (destLayer != sourceLayer && destLayer instanceof RedlineLayer && sourceLayer instanceof RedlineLayer) {
            Pair<CadLayerSymbolDefinition, ByteBuffer> definitionsAndData;
            RedlineLayerSymbolStore srcStore = ((RedlineLayer)sourceLayer).getRedlineSymbolStore();
            RedlineLayerSymbolStore destStore = ((RedlineLayer)destLayer).getRedlineSymbolStore();
            String symbolName = (String)FeatureUtil.getAttribute((SimpleFeature)featureToCheck, (String)CadFeatureAtts.SYMBOL.getName());
            String fillName = (String)FeatureUtil.getAttribute((SimpleFeature)featureToCheck, (String)CadFeatureAtts.FILL.getName());
            boolean newSymbols = false;
            if (symbolName != null && srcStore.containsSymbol(symbolName) && !destStore.containsSymbol(symbolName)) {
                definitionsAndData = srcStore.getDefinitionAndData(symbolName);
                if (definitionsAndData != null) {
                    destStore.addSymbol((CadLayerSymbolDefinition)definitionsAndData.getLeft(), (ByteBuffer)definitionsAndData.getRight());
                }
                newSymbols = true;
            }
            if (fillName != null && srcStore.containsSymbol(fillName) && !destStore.containsSymbol(fillName)) {
                definitionsAndData = srcStore.getDefinitionAndData(fillName);
                if (definitionsAndData != null) {
                    destStore.addSymbol((CadLayerSymbolDefinition)definitionsAndData.getLeft(), (ByteBuffer)definitionsAndData.getRight());
                }
                newSymbols = true;
            }
            if (newSymbols) {
                if (async) {
                    Tasks.submit(() -> RedlineLayerUtils.fireHeaderSave(destLayer));
                } else {
                    RedlineLayerUtils.fireHeaderSave(destLayer);
                }
            }
        }
    }

    private static void fireHeaderSave(Layer destLayer) {
        destLayer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        ((RedlineLayer)destLayer).saveHeaderToFile();
    }

    private RedlineLayerUtils() {
    }
}

