/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.redline.RedlineGlobalStyles;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineStylePanel;
import de.riwagis.guitools.Tasks;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineDrawingStylePanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineDrawingStylePanel.class);
    private static final long serialVersionUID = -2518150537533168614L;
    private static final String STYLE_FILE_EXTENSION = "draw";
    private static final String DRAW_FILE_PATH = RedlineDrawingStylePanel.class.getName() + "_LAST_USED_FILE";
    private static final FileFilter STYLE_FILE_FILTER = GUISupport.createFileFilter((String)I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.style-format-name"), (String[])new String[]{"draw"});
    private RedlineStylePanel redlineStylePanel;
    private RedlineLayer redlineLayer;
    private boolean ignoreEvents = false;
    private JFileChooser _fileOpenChooser = null;
    private JFileChooser _fileSaveChooser = null;
    private final Blackboard blackBoard = PersistentBlackboardPlugIn.get();
    private JButton btnAddDrawingStyle;
    private JButton btnExportDrawingStyle;
    private JButton btnImportDrawingStyle;
    private JButton btnRemoveDrawingStyle;
    private JButton btnRenameDrawingStyle;
    private JButton btnSaveDrawingStyle;
    private JComboBox<String> cmbDrawingStyle;
    private JLabel jLabel1;
    private JToolBar.Separator jSeparator2;
    private JToolBar tbaDrawingStyles;

    public RedlineDrawingStylePanel() {
        this.initComponents();
        this.setStyleChanged(false);
    }

    public void setParent(RedlineStylePanel redlineStylePanel) {
        this.redlineStylePanel = redlineStylePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDrawingStyles(RedlineLayer redlineLayer) {
        boolean layerChanged = redlineLayer != this.redlineLayer;
        this.redlineLayer = redlineLayer;
        try {
            this.ignoreEvents = true;
            SortedSet<String> keySet = RedlineGlobalStyles.getInstance().getAllStyleNames(redlineLayer);
            String currentSelection = this.getSelectedStyle();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cmbDrawingStyle.getModel();
            model.removeAllElements();
            model.addAll(keySet);
            if (!layerChanged && keySet.contains(currentSelection)) {
                this.cmbDrawingStyle.setSelectedItem(currentSelection);
                this.redlineStylePanel.updatePanelState();
                SimpleFeature style = RedlineGlobalStyles.getInstance().getStyle(redlineLayer, this.getSelectedStyle());
                this.setStyleChanged(!redlineLayer.styleAttributeEquals(style));
            } else {
                this.ignoreEvents = false;
                keySet.stream().findFirst().ifPresent(this.cmbDrawingStyle::setSelectedItem);
            }
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private JFileChooser getFileSaveChooser() {
        if (this._fileSaveChooser == null) {
            this._fileSaveChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
            this._fileSaveChooser.setFileFilter(STYLE_FILE_FILTER);
            this._fileSaveChooser.setMultiSelectionEnabled(false);
        }
        return this._fileSaveChooser;
    }

    private JFileChooser getFileOpenChooser() {
        if (this._fileOpenChooser == null) {
            this._fileOpenChooser = GUISupport.createJFileChooser((boolean)true);
            this._fileOpenChooser.setFileFilter(STYLE_FILE_FILTER);
            this._fileOpenChooser.setMultiSelectionEnabled(true);
            this._fileOpenChooser.removeChoosableFileFilter(this._fileOpenChooser.getAcceptAllFileFilter());
        }
        return this._fileOpenChooser;
    }

    private void initComponents() {
        this.tbaDrawingStyles = new JToolBar();
        this.btnAddDrawingStyle = new JButton();
        this.btnSaveDrawingStyle = new JButton();
        this.btnRenameDrawingStyle = new JButton();
        this.btnRemoveDrawingStyle = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnImportDrawingStyle = new JButton();
        this.btnExportDrawingStyle = new JButton();
        this.jLabel1 = new JLabel();
        this.cmbDrawingStyle = new JComboBox();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.tbaDrawingStyles.setRollover(true);
        this.tbaDrawingStyles.setOpaque(false);
        this.btnAddDrawingStyle.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.btnAddDrawingStyle.setToolTipText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.add-style-tooltip"));
        this.btnAddDrawingStyle.setFocusable(false);
        this.btnAddDrawingStyle.setHorizontalTextPosition(0);
        this.btnAddDrawingStyle.setMargin(new Insets(0, 0, 0, 0));
        this.btnAddDrawingStyle.setVerticalTextPosition(3);
        this.btnAddDrawingStyle.addActionListener(this::btnAddDrawingStyleActionPerformed);
        this.tbaDrawingStyles.add(this.btnAddDrawingStyle);
        this.btnSaveDrawingStyle.setIcon(IconLoader.svgIcon((String)"common_save.svg"));
        this.btnSaveDrawingStyle.setToolTipText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.save-style-tooltip"));
        this.btnSaveDrawingStyle.setFocusable(false);
        this.btnSaveDrawingStyle.setHorizontalTextPosition(0);
        this.btnSaveDrawingStyle.setMargin(new Insets(0, 0, 0, 0));
        this.btnSaveDrawingStyle.setVerticalTextPosition(3);
        this.btnSaveDrawingStyle.addActionListener(this::btnSaveDrawingStyleActionPerformed);
        this.tbaDrawingStyles.add(this.btnSaveDrawingStyle);
        this.btnRenameDrawingStyle.setIcon(IconLoader.svgIcon((String)"common_edit.svg"));
        this.btnRenameDrawingStyle.setToolTipText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.rename-style-tooltip"));
        this.btnRenameDrawingStyle.setFocusable(false);
        this.btnRenameDrawingStyle.setHorizontalTextPosition(0);
        this.btnRenameDrawingStyle.setMargin(new Insets(0, 0, 0, 0));
        this.btnRenameDrawingStyle.setVerticalTextPosition(3);
        this.btnRenameDrawingStyle.addActionListener(this::btnRenameDrawingStyleActionPerformed);
        this.tbaDrawingStyles.add(this.btnRenameDrawingStyle);
        this.btnRemoveDrawingStyle.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.btnRemoveDrawingStyle.setToolTipText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.remove-style-tooltip"));
        this.btnRemoveDrawingStyle.setFocusable(false);
        this.btnRemoveDrawingStyle.setHorizontalTextPosition(0);
        this.btnRemoveDrawingStyle.setMargin(new Insets(0, 0, 0, 0));
        this.btnRemoveDrawingStyle.setVerticalTextPosition(3);
        this.btnRemoveDrawingStyle.addActionListener(this::btnRemoveDrawingStyleActionPerformed);
        this.tbaDrawingStyles.add(this.btnRemoveDrawingStyle);
        this.tbaDrawingStyles.add(this.jSeparator2);
        this.btnImportDrawingStyle.setIcon(IconLoader.svgIcon((String)"legend_import.svg"));
        this.btnImportDrawingStyle.setToolTipText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.import-style-tooltip"));
        this.btnImportDrawingStyle.setFocusable(false);
        this.btnImportDrawingStyle.setHorizontalTextPosition(0);
        this.btnImportDrawingStyle.setMargin(new Insets(0, 0, 0, 0));
        this.btnImportDrawingStyle.setVerticalTextPosition(3);
        this.btnImportDrawingStyle.addActionListener(this::btnImportDrawingStyleActionPerformed);
        this.tbaDrawingStyles.add(this.btnImportDrawingStyle);
        this.btnExportDrawingStyle.setIcon(IconLoader.svgIcon((String)"legend_export.svg"));
        this.btnExportDrawingStyle.setToolTipText(I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.export-style-tooltip"));
        this.btnExportDrawingStyle.setFocusable(false);
        this.btnExportDrawingStyle.setHorizontalTextPosition(0);
        this.btnExportDrawingStyle.setMargin(new Insets(0, 0, 0, 0));
        this.btnExportDrawingStyle.setVerticalTextPosition(3);
        this.btnExportDrawingStyle.addActionListener(this::btnExportDrawingStyleActionPerformed);
        this.tbaDrawingStyles.add(this.btnExportDrawingStyle);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tbaDrawingStyles, gridBagConstraints);
        this.jLabel1.setText("Zeichenstil");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.cmbDrawingStyle.setRenderer(new StyleListRenderer());
        this.cmbDrawingStyle.addActionListener(this::cmbDrawingStyleActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add(this.cmbDrawingStyle, gridBagConstraints);
    }

    private void cmbDrawingStyleActionPerformed(ActionEvent evt) {
        if (this.ignoreEvents || this.redlineStylePanel == null || this.redlineLayer == null || this.cmbDrawingStyle.getSelectedItem() == null) {
            return;
        }
        this.redlineLayer.updateSilently(() -> {
            this.redlineLayer.copyOverActiveFeatureFromStyle(this.getSelectedStyle());
            this.redlineStylePanel.updatePanelState();
            this.setStyleChanged(false);
            boolean isStyleFromFile = !RedlineGlobalStyles.getInstance().isGlobalStyle(this.getSelectedStyle());
            this.btnRenameDrawingStyle.setEnabled(isStyleFromFile);
            this.btnRemoveDrawingStyle.setEnabled(isStyleFromFile);
        });
    }

    private void btnAddDrawingStyleActionPerformed(ActionEvent evt) {
        if (this.redlineStylePanel == null || this.redlineLayer == null) {
            return;
        }
        String validationErrors = this.redlineStylePanel.getValidationErrors();
        if (validationErrors != null) {
            JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.getMessage("ui.plugin.layer.redline.RedlineStyleDialog.validation-errors", validationErrors), I18N.get("common.error"), 0);
            return;
        }
        String untrimmedName = JOptionPane.showInputDialog(this.btnAddDrawingStyle, (Object)I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.new-symbol-name"));
        if (untrimmedName == null) {
            return;
        }
        String name = untrimmedName.trim();
        if (name.isBlank()) {
            JOptionPane.showMessageDialog(this.btnAddDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.error-style-name-empty"), I18N.get("common.error"), 0);
        } else if (!RedlineGlobalStyles.getInstance().containsStyle(this.redlineLayer, name)) {
            Tasks.submit(() -> {
                this.redlineLayer.updateSilently(() -> this.redlineLayer.createDrawingStyle(name));
                this.redlineLayer.copyOverActiveFeatureFromStyle(name);
                this.updateDrawingStyles(this.redlineLayer);
                this.cmbDrawingStyle.setSelectedItem(name);
                this.redlineLayer.saveHeaderToFile();
            });
        } else {
            JOptionPane.showMessageDialog(this.btnAddDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.error-style-exists"), I18N.get("common.error"), 0);
        }
    }

    private void btnRenameDrawingStyleActionPerformed(ActionEvent evt) {
        if (this.redlineStylePanel == null || this.redlineLayer == null) {
            return;
        }
        String selectedItem = this.getSelectedStyle();
        String name = JOptionPane.showInputDialog(this.btnRenameDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.new-symbol-name"), selectedItem);
        if (name == null) {
            return;
        }
        String trimmedName = name.trim();
        if (!trimmedName.equals(selectedItem)) {
            if (name.isBlank()) {
                JOptionPane.showMessageDialog(this.btnRenameDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.error-style-name-empty"), I18N.get("common.error"), 0);
            } else if (!RedlineGlobalStyles.getInstance().containsStyle(this.redlineLayer, trimmedName)) {
                SimpleFeature currentStyle = this.redlineLayer.getDefaultFeature();
                this.redlineLayer.copyOverActiveFeatureFromStyle(selectedItem);
                this.redlineLayer.updateSilently(() -> {
                    boolean styleChanged = this.isStyleChanged();
                    this.redlineLayer.createDrawingStyle(trimmedName);
                    this.updateDrawingStyles(this.redlineLayer);
                    this.cmbDrawingStyle.setSelectedItem(trimmedName);
                    this.redlineLayer.removeDrawingStyle(selectedItem);
                    this.cmbDrawingStyle.removeItem(selectedItem);
                    this.redlineLayer.copyStyleToDefaultFeature(currentStyle);
                    this.redlineStylePanel.updatePanelState();
                    this.setStyleChanged(styleChanged);
                });
                Tasks.submit(() -> this.redlineLayer.saveHeaderToFile());
            } else {
                JOptionPane.showMessageDialog(this.btnRenameDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.error-style-exists"), I18N.get("common.error"), 0);
            }
        }
    }

    private void btnRemoveDrawingStyleActionPerformed(ActionEvent evt) {
        if (this.redlineStylePanel == null || this.redlineLayer == null) {
            return;
        }
        if (RedlineGlobalStyles.getInstance().getStyleCount(this.redlineLayer) <= 1) {
            JOptionPane.showMessageDialog(this.btnRemoveDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.error-at-least-one-style"), I18N.get("common.error"), 0);
            return;
        }
        int option = JOptionPane.showConfirmDialog(this.btnRemoveDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.question-delete"), I18N.get("common.message"), 0);
        if (option != 0) {
            return;
        }
        String selectedItem = this.getSelectedStyle();
        this.redlineLayer.updateSilently(() -> this.redlineLayer.removeDrawingStyle(selectedItem));
        this.cmbDrawingStyle.removeItem(selectedItem);
        Tasks.submit(() -> this.redlineLayer.saveHeaderToFile());
    }

    private String getSelectedStyle() {
        return (String)this.cmbDrawingStyle.getSelectedItem();
    }

    private void btnExportDrawingStyleActionPerformed(ActionEvent evt) {
        int result;
        if (this.redlineStylePanel == null || this.redlineLayer == null) {
            return;
        }
        JList<String> styleList = new JList<String>(this.cmbDrawingStyle.getModel());
        JScrollPane scrollableList = new JScrollPane(styleList);
        int size = styleList.getModel().getSize();
        if (size > 0) {
            styleList.setSelectionInterval(0, size - 1);
        }
        if ((result = JOptionPane.showConfirmDialog(this.btnRemoveDrawingStyle, scrollableList, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.select-styles-for-export"), 2, -1)) != 0) {
            return;
        }
        HashSet<String> selectedStyles = new HashSet<String>(styleList.getSelectedValuesList());
        if (selectedStyles.isEmpty()) {
            JOptionPane.showMessageDialog(this.btnRemoveDrawingStyle, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.error-at-least-one-style-selected"), I18N.get("ui.WorkbenchFrame.warning"), 2);
            return;
        }
        JFileChooser fileSaveChooser = this.getFileSaveChooser();
        this.setCurrentChooserLocation(fileSaveChooser);
        if (fileSaveChooser.showSaveDialog(this) == 0) {
            this.setLastUsedLocationFromChooser(fileSaveChooser);
            Tasks.submit(() -> {
                File exportFile = FileUtil.addExtensionIfNone(fileSaveChooser.getSelectedFile(), STYLE_FILE_EXTENSION);
                RedlineLayerUtils.saveStylesToFile(this.redlineLayer, selectedStyles, exportFile, null);
            });
        }
    }

    private void btnImportDrawingStyleActionPerformed(ActionEvent evt) {
        if (this.redlineStylePanel == null || this.redlineLayer == null) {
            return;
        }
        JFileChooser fileOpenChooser = this.getFileOpenChooser();
        this.setCurrentChooserLocation(fileOpenChooser);
        if (fileOpenChooser.showOpenDialog(this) != 1) {
            this.setLastUsedLocationFromChooser(fileOpenChooser);
            Tasks.submit(() -> {
                File drawFile = fileOpenChooser.getSelectedFile();
                AtomicReference firstNewStyle = new AtomicReference(Optional.empty());
                RedlineLayerUtils.addStylesAndSymbolsToLayer(this.redlineLayer, drawFile, this::selectStylesForImport).ifPresent(style -> firstNewStyle.compareAndExchange(Optional.empty(), Optional.of(style)));
                firstNewStyle.get().ifPresent(style -> {
                    this.redlineStylePanel.updateComponentsForCurrentLayer();
                    this.cmbDrawingStyle.setSelectedItem(style);
                    this.redlineLayer.saveHeaderToFile();
                });
            });
        }
    }

    private void setLastUsedLocationFromChooser(JFileChooser chooser) {
        this.blackBoard.put(DRAW_FILE_PATH, chooser.getSelectedFile().getAbsolutePath());
    }

    private void setCurrentChooserLocation(JFileChooser chooser) {
        String lastUsedFile = this.blackBoard.getString(DRAW_FILE_PATH);
        if (StringUtils.isNotBlank((String)lastUsedFile)) {
            chooser.setSelectedFile(new File(lastUsedFile));
        }
    }

    private void btnSaveDrawingStyleActionPerformed(ActionEvent evt) {
        if (this.redlineStylePanel == null || this.redlineLayer == null) {
            return;
        }
        String validationErrors = this.redlineStylePanel.getValidationErrors();
        if (validationErrors != null) {
            JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.getMessage("ui.plugin.layer.redline.RedlineStyleDialog.validation-errors", validationErrors), I18N.get("common.error"), 0);
            return;
        }
        Tasks.submit(() -> {
            if (RedlineGlobalStyles.getInstance().isGlobalStyle(this.getSelectedStyle())) {
                RedlineGlobalStyles.getInstance().saveStyle(this.getSelectedStyle(), this.redlineLayer.getDefaultFeature(), this.redlineLayer);
            } else {
                this.redlineLayer.updateSilently(() -> this.redlineLayer.updateStyle(this.getSelectedStyle()));
                this.redlineLayer.saveHeaderToFile();
            }
            this.setStyleChanged(false);
        });
    }

    public void setStyleChanged(boolean isChanged) {
        this.btnSaveDrawingStyle.setEnabled(isChanged);
    }

    public boolean isStyleChanged() {
        return this.btnSaveDrawingStyle.isEnabled();
    }

    private Set<String> selectStylesForImport(Set<String> existingStyles, Set<String> stylesInFile) {
        try {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicInteger result = new AtomicInteger();
            AtomicReference selectedStyles = new AtomicReference();
            SwingUtilities.invokeLater(() -> {
                DefaultListModel listModel = new DefaultListModel();
                listModel.addAll(stylesInFile);
                JList<String> styleList = new JList<String>(listModel);
                styleList.clearSelection();
                stylesInFile.stream().filter(s -> !existingStyles.contains(s)).forEach(style -> {
                    int index = listModel.indexOf(style);
                    styleList.addSelectionInterval(index, index);
                });
                styleList.setCellRenderer(new ImportListCellRenderer(existingStyles));
                JScrollPane scrollableList = new JScrollPane(styleList);
                result.set(JOptionPane.showConfirmDialog(this.btnRemoveDrawingStyle, scrollableList, I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.select-styles-for-import"), 2, -1));
                selectedStyles.set(styleList.getSelectedValuesList());
                latch.countDown();
            });
            latch.await();
            if (result.get() != 0) {
                return Collections.emptySet();
            }
            return Set.copyOf((Collection)selectedStyles.get());
        }
        catch (InterruptedException ex) {
            log.error("Could not get selected styles.", (Throwable)ex);
            return Collections.emptySet();
        }
    }

    private static class StyleListRenderer
    implements ListCellRenderer<String> {
        private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();

        private StyleListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!isSelected && RedlineGlobalStyles.getInstance().isGlobalStyle(value)) {
                comp.setBackground(Color.YELLOW);
            }
            return comp;
        }
    }

    private static class ImportListCellRenderer
    implements ListCellRenderer<String> {
        final DefaultListCellRenderer wrappedRenderer;
        private final Set<String> existingStyles;

        public ImportListCellRenderer(Set<String> existingStyles) {
            this.existingStyles = existingStyles;
            this.wrappedRenderer = new DefaultListCellRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.wrappedRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.existingStyles.contains(value)) {
                renderer.setText(value + " (" + I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.suffix-exists") + ")");
            } else {
                renderer.setFont(renderer.getFont().deriveFont(1));
            }
            return renderer;
        }
    }
}

