/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.redline.RedlineFeatureCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.LoadMyRedlineLayersTaskIOListener;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.SaveRedlineLayerPlugIn;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.SelfClosingMessageBox;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class LoadRedlineLayerPlugIn
extends AbstractPlugIn {
    private JFileChooser fileChooser = null;
    private static final LoadMyRedlineLayersTaskIOListener LOAD_MY_REDLINELAYERS_TASKIOLISTENER = new LoadMyRedlineLayersTaskIOListener();

    public LoadRedlineLayerPlugIn() {
        AbstractTaskPlugIn.addTaskIOListener(LOAD_MY_REDLINELAYERS_TASKIOLISTENER);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.name");
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    private void initFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            this.fileChooser.setDialogTitle(this.getName());
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(true);
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            this.fileChooser.addChoosableFileFilter(RedlineLayerUtils.RLY_FILE_FILTER);
            this.fileChooser.setFileFilter(RedlineLayerUtils.RLY_FILE_FILTER);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.initFileChooser();
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (bb.contains(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY)) {
            String strPath = (String)bb.get(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY);
            this.fileChooser.setSelectedFile(new File(strPath));
        }
        if (0 != this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            return true;
        }
        String strFile = this.fileChooser.getSelectedFile().getAbsolutePath();
        bb.put(SaveRedlineLayerPlugIn.CURRENT_FILE_KEY, strFile);
        WaitDialog dlgWait = new WaitDialog((Window)context.getWorkbenchFrame(), I18N.get("common.wait"));
        Runnable run = () -> {
            try {
                List<String> messages = LoadRedlineLayerPlugIn.loadRedlineLayers(context, this.fileChooser.getSelectedFiles());
                if (!messages.isEmpty()) {
                    if (messages.contains(I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.crs-does-not-match"))) {
                        throw new IOException(I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.crs-does-not-match"));
                    }
                    if (messages.contains(I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.outside-bounds"))) {
                        SelfClosingMessageBox msgBox = new SelfClosingMessageBox((Window)context.getWorkbenchFrame(), I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.outside-bounds"), 3000);
                        SwingUtilities.invokeLater(() -> msgBox.setVisible(true));
                    }
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)context.getWorkbenchFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
        }
        dlgWait.dispose();
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }

    public static List<String> loadRedlineLayers(PlugInContext context, File[] arrFiles) throws Exception {
        return LoadRedlineLayerPlugIn.loadRedlineLayers(context, arrFiles, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadRedlineLayers(PlugInContext context, File[] arrFiles, Category cat) throws Exception {
        if (cat == null) {
            cat = LoadRedlineLayerPlugIn.getCategory4RedlineLayer(context);
        }
        ArrayList<String> messages = new ArrayList<String>();
        LayerManager layMngr = context.getLayerManager();
        Envelope projectBounds = layMngr.getTask().getInitialView();
        Envelope visibleBounds = context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        boolean showNoIntersectionMessage = false;
        for (File file : arrFiles) {
            boolean isFiringEvents = layMngr.isFiringEvents();
            RedlineLayer rly = null;
            try {
                RedlineFeatureCollection col;
                rly = RedlineLayerUtils.createLayerFromFile(file, layMngr);
                if (!StringUtils.equals((CharSequence)rly.getCRSDefinition().getKey(), (CharSequence)layMngr.getTask().getCRSDefinition().getKey())) {
                    messages.add(I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.crs-does-not-match"));
                }
                if (!(projectBounds == null || projectBounds.isNull() || visibleBounds == null || visibleBounds.isNull() || (col = rly.getDataStore().getInternalFeatureCollection()).isEmpty() || showNoIntersectionMessage)) {
                    boolean intersectionFound = false;
                    try (SimpleFeatureIterator iter = col.features();){
                        while (iter.hasNext()) {
                            Envelope env;
                            SimpleFeature feature = (SimpleFeature)iter.next();
                            Geometry geom = (Geometry)feature.getDefaultGeometry();
                            if (geom == null || geom.isEmpty() || !projectBounds.intersects(env = geom.getEnvelopeInternal()) && !visibleBounds.intersects(env)) continue;
                            intersectionFound = true;
                            break;
                        }
                    }
                    if (!intersectionFound) {
                        messages.add(I18N.get("ui.plugin.io.layer.LoadRedlineLayerPlugIn.outside-bounds"));
                    }
                    showNoIntersectionMessage = !intersectionFound;
                }
                rly.setMetaDataModified(false);
                cat.add(0, rly);
            }
            finally {
                layMngr.setFiringEvents(isFiringEvents);
                if (rly != null) {
                    rly.fireAppearanceChanged();
                    rly.getLayerManager().fireLayerChanged(rly, LayerEventType.ADDED);
                    EditingPanel.instanceOf().setCurrentLayer(rly);
                }
            }
        }
        return messages;
    }

    public static Category getCategory4RedlineLayer(PlugInContext context) {
        Category cat2 = null;
        for (Category cat2 : context.getLayerNamePanel().getSelectedCategories()) {
        }
        if (cat2 == null) {
            cat2 = context.getLayerManager().addCategory(StandardCategoryNames.WORKING);
        }
        return cat2;
    }
}

