/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.EditableNumberJComboBox;
import java.text.ParseException;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableNumberWithValidationJComboBox<T>
extends EditableNumberJComboBox<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EditableNumberWithValidationJComboBox.class);
    private final JLabel warningLabel;
    private final JFormattedTextField textEditor;
    private Function<Number, String> validator = v -> null;

    public EditableNumberWithValidationJComboBox() {
        this.warningLabel = new JLabel(IconLoader.svgIcon((String)"common_attention.svg", (int)16));
        this.warningLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateStateUI();
            }
        });
        this.textEditor = (JFormattedTextField)this.getEditor().getEditorComponent();
        this.textEditor.setColumns(3);
        this.textEditor.addActionListener(e -> this.updateStateUI());
        this.textEditor.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jc) {
                EditableNumberWithValidationJComboBox.this.commitCurrentTextInput();
                return true;
            }
        });
    }

    public Function<Number, String> getValidator() {
        return this.validator;
    }

    public void setValidator(Function<Number, String> validator) {
        this.validator = validator;
    }

    public String getValidationErrors() {
        return this.validator.apply((Number)this.getSelectedItem());
    }

    private void commitCurrentTextInput() {
        try {
            this.textEditor.commitEdit();
        }
        catch (ParseException ex) {
            log.error("Could not parse number text field", (Throwable)ex);
        }
    }

    private void updateStateUI() {
        String error = this.getValidationErrors();
        if (error != null) {
            this.putClientProperty("JComponent.outline", "error");
            this.textEditor.putClientProperty("JTextField.trailingComponent", this.warningLabel);
            this.textEditor.setToolTipText(error);
        } else {
            this.putClientProperty("JComponent.outline", null);
            this.textEditor.putClientProperty("JTextField.trailingComponent", null);
            this.textEditor.setToolTipText(null);
        }
    }
}

