/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineStylePanel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.opengis.feature.simple.SimpleFeature;

public class AssignRedlineAttributesPlugIn
extends AbstractPlugIn {
    private final RedlineStylePanel rStylePanel;

    public AssignRedlineAttributesPlugIn(RedlineStylePanel rStylePanel) {
        this.rStylePanel = rStylePanel;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.redline.AssignRedlineAttributesPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_copy_style.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        String validationErrors = this.rStylePanel.getValidationErrors();
        if (validationErrors != null) {
            JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.getMessage("ui.plugin.layer.redline.AssignRedlineAttributesPlugIn.validation-errors", validationErrors), I18N.get("common.error"), 0);
            return false;
        }
        AbstractCadLayer currentLy = this.rStylePanel.getCurrentLayer();
        if (currentLy == null) {
            return false;
        }
        SelectionManager selMngr = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
        HashMap<Layer, ArrayList<SimpleFeature>> mapSel = new HashMap<Layer, ArrayList<SimpleFeature>>();
        for (Layer layer : selMngr.getLayersWithSelectedItems()) {
            if ((!(layer instanceof AbstractCadLayer) || layer != currentLy) && (!(layer instanceof RedlineLayer) || !(currentLy instanceof RedlineLayer))) continue;
            ArrayList<SimpleFeature> lstOldFeatures = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
            AbstractCadLayer cadly = (AbstractCadLayer)layer;
            RedlineLayerUtils.addSymbolAndFillIfNecessary(layer, currentLy);
            for (SimpleFeature src : selMngr.getFeaturesWithSelectedItems(layer)) {
                SimpleFeature oldFeat = FeatureUtil.cloneFeature((SimpleFeature)src, (boolean)false);
                SimpleFeature newFeat = FeatureUtil.cloneFeature((SimpleFeature)oldFeat, (boolean)false);
                currentLy.copyDefaultStyleToFeature(newFeat);
                lstOldFeatures.add(oldFeat);
                lstNewFeatures.add(newFeat);
            }
            lstCommands.add(this.createAssignCommand(cadly, lstNewFeatures, lstOldFeatures));
            mapSel.put(layer, lstNewFeatures);
        }
        AbstractPlugIn.execute(lstCommands, (LayerManagerProxy)WorkbenchContext.getInstance(), true);
        selMngr.clear();
        for (Map.Entry entry : mapSel.entrySet()) {
            selMngr.getFeatureSelection().selectItems((Layer)entry.getKey(), (Collection)entry.getValue());
        }
        if (mapSel.isEmpty()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("ui.plugin.layer.redline.RedlineStyleDialog.select-redline-element"), (String)I18N.get("common.message"));
        }
        return true;
    }

    private UndoableCommand createAssignCommand(final AbstractCadLayer cadlayer, final Collection<SimpleFeature> colNewFeatures, final Collection<SimpleFeature> colOldFeatures) {
        return new UndoableCommand(this, I18N.get("ui.plugin.layer.redline.AssignRedlineAttributesPlugIn.assign-style")){

            @Override
            public void execute() {
                cadlayer.editFeature(colNewFeatures, 2);
            }

            @Override
            public void unexecute() {
                cadlayer.editFeature(colOldFeatures, 2);
            }
        };
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1)).add(component -> {
            if (this.rStylePanel == null) {
                return "No RedlineStylePanel found in PlugIn.";
            }
            AbstractCadLayer cLy = this.rStylePanel.getCurrentLayer();
            Collection<Layer> colLy = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems();
            for (Layer ly : colLy) {
                if (!(ly instanceof AbstractCadLayer)) continue;
                if (cLy instanceof RedlineLayer && ly instanceof RedlineLayer) {
                    return null;
                }
                if (cLy != ly) continue;
                return null;
            }
            return "At least one feature on redline or cadlayer has to be selected.";
        });
    }
}

