/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.redline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.AddLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.style.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.util.ArrayList;
import java.util.List;

public class AddRedlineLayerPlugIn
extends AddLayerPlugIn {
    private static final String MESSAGE = I18N.get("ui.plugin.layer.redline.AddRedlineLayerPlugIn.message");

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.redline.AddRedlineLayerPlugIn.name");
    }

    @Override
    protected Class<?> getLayerableClass() {
        return RedlineLayer.class;
    }

    @Override
    protected List<LayerStylePanel> generateLayerPanels(PlugInContext context, AbstractLayerable layer) throws Exception {
        ArrayList<LayerStylePanel> lstPanels = new ArrayList<LayerStylePanel>(1);
        LayerNamePanel layerPanel = new LayerNamePanel(layer);
        lstPanels.add(0, layerPanel);
        return lstPanels;
    }

    @Override
    protected StylePanel generateStylePanel(PlugInContext context, AbstractLayerable layer) throws Exception {
        return null;
    }

    @Override
    protected AbstractLayerable generateLayerable(PlugInContext context) throws Exception {
        LayerManager layMngr = context.getLayerManager();
        String strName = I18N.get("ui.plugin.layer.redline.AddRedlineLayerPlugIn.default-layername");
        RedlineLayer res = new RedlineLayer(layMngr.uniqueLayerName(strName), layMngr);
        return res;
    }

    public static final RedlineLayer addLayer(PlugInContext context, Category category, String name) {
        return AddRedlineLayerPlugIn.addLayer(context.getLayerManager(), category, name);
    }

    public static final RedlineLayer addLayer(LayerManager layerManager, Category selectedCategory, String strName) {
        RedlineLayer res = null;
        if (selectedCategory == null) {
            selectedCategory = layerManager.addCategory(StandardCategoryNames.REDLINE_LAYERS);
        }
        res = new RedlineLayer(layerManager.uniqueLayerName(strName), layerManager);
        selectedCategory.add(0, res);
        return res;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1));
        return chk;
    }
}

