/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.DatastoreCRUDLabelsUtil;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.LabelSelectedFeaturePlugIn;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.label.LabelFeatureAction;
import de.riwagis.label.LabelFeatureAtts;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.swing.JComponent;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class UpdateSelectedLabelPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.label.UpdateSelectedLabelPlugIn.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1)).add(checkFactory.createExactlyNLayersMustHaveSelectedItemsCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck()).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Layer selectedLayer = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems().iterator().next();
                if (!selectedLayer.getClass().equals(LabelLayer.class)) {
                    return I18N.get("ui.plugin.layer.label.UpdateSelectedLabelPlugIn.enablecheck-only-label-layer");
                }
                return null;
            }
        });
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(new Runnable(){

            @Override
            public void run() {
                try {
                    Collection<SimpleFeature> selectedLabels = context.getWorkbenchContext().getSelectionManager().getFeaturesWithSelectedItems();
                    LabelLayer labelLayer = (LabelLayer)context.getWorkbenchContext().getSelectionManager().getLayersWithSelectedItems().iterator().next();
                    Layer parentLayer = labelLayer.getParentLayer();
                    FeaturestoreMetadata labelFMD = labelLayer.getFMD();
                    boolean useUpperCase = FeatureTypeUtil.isSchemaNameInUpperCase((String)labelFMD.getDatatypeNameEdit());
                    DataStore dataStore = labelFMD.getDataStore(WorkbenchContext.getTask().getDataStores());
                    ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                    ArrayList<SimpleFeature> features2Delete = new ArrayList<SimpleFeature>();
                    int errorCount = 0;
                    DatastoreCRUDLabelsUtil labelsUtil = new DatastoreCRUDLabelsUtil(labelLayer.getLayerManager().getTask(), dataStore, labelFMD.getDatastoreName(), useUpperCase);
                    for (SimpleFeature labelFeature : selectedLabels) {
                        String labelId2Update = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)labelFeature, (String)FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.LABEL_DEF_ID.getName())));
                        LabelDefInfo labelInfo = labelsUtil.retrieveLabelInfoForID(Integer.parseInt(labelId2Update));
                        if (labelInfo == null) {
                            ++errorCount;
                            continue;
                        }
                        Object parentFeatureFID = labelFeature.getAttribute(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.FID_PARENT.getName()));
                        FeaturestoreMetadata parentFMD = parentLayer.getFMD();
                        String parentFidCol = LabelSelectedFeaturePlugIn.determineParentFidCol(parentFMD, useUpperCase);
                        Filter parentFilter = FilterUtil.buildFeatureIdFilter((String)parentFidCol, (Object)parentFeatureFID);
                        String parentTypeName = parentFMD.getEditInOtherDatatype() ? parentFMD.getDatatypeNameEdit() : parentFMD.getDatatypeName();
                        SimpleFeatureSource fsParent = dataStore.getFeatureSource(parentTypeName);
                        SimpleFeatureCollection fCol = fsParent.getFeatures(parentFilter);
                        SimpleFeature parentFeature = (SimpleFeature)DataUtilities.first((FeatureCollection)DataUtilities.collection((FeatureCollection)fCol));
                        if (parentFeature == null) {
                            throw new IllegalArgumentException(I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.error-no-feature-found") + ": " + parentTypeName + " - " + String.valueOf(parentFilter));
                        }
                        LabelFeatureAction action = labelsUtil.updateLabelText(labelInfo, parentFeature, labelFeature);
                        if (action == LabelFeatureAction.DELETE) {
                            features2Delete.add(labelFeature);
                            continue;
                        }
                        if (action != LabelFeatureAction.UPDATE) continue;
                        features.add(labelFeature);
                    }
                    if (errorCount > 0) {
                        dlgWait.setError((Exception)new NoSuchElementException(I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.error") + "\n" + I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.error-no-labeldef-found")));
                    }
                    if (!features.isEmpty()) {
                        labelLayer.editFeature(features, 2);
                    }
                    if (!features2Delete.isEmpty()) {
                        labelLayer.editFeature(features2Delete, 3);
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            context.getErrorHandler().handleThrowable(dlgWait.getError());
        }
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }
}

