/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.LabelSelectedFeaturePlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.label.LabelFeatureAtts;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.apache.commons.io.IOUtils;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class SelectLabelsPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.label.SelectLabelsPlugIn.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustHaveSelectedItemsCheck(1)).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1)).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Layer selectedLayer = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems().iterator().next();
                if (!selectedLayer.getClass().equals(Layer.class)) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-only-layer");
                }
                if (selectedLayer.getLabelLayer() == null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-layer-has-no-label-layer");
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selectionManager = context.getWorkbenchContext().getSelectionManager();
        Layer parentLayer = selectionManager.getLayersWithSelectedItems().iterator().next();
        LabelLayer labelLayer = parentLayer.getLabelLayer();
        FeaturestoreMetadata parentFMD = parentLayer.getFMD();
        boolean useUpperCase = FeatureTypeUtil.isSchemaNameInUpperCase((String)parentFMD.getDatatypeNameEdit());
        String parentFidCol = FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.FID_PARENT.getName());
        Collection<SimpleFeature> parentFeatures = selectionManager.getFeaturesWithSelectedItems(parentLayer);
        selectionManager.clear();
        ArrayList<SimpleFeature> labelFeatures = new ArrayList<SimpleFeature>();
        for (SimpleFeature parentFeature : parentFeatures) {
            String fidParent = FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)parentFeature);
            PropertyIsEqualTo filter = LabelSelectedFeaturePlugIn.ff.equals((Expression)LabelSelectedFeaturePlugIn.ff.property(parentFidCol), (Expression)LabelSelectedFeaturePlugIn.ff.literal((Object)fidParent));
            FeatureIterator<SimpleFeature> iter = labelLayer.getFeatureIterator((Filter)filter);
            try {
                while (iter.hasNext()) {
                    SimpleFeature labelFeature = (SimpleFeature)iter.next();
                    labelFeatures.add(labelFeature);
                }
            }
            finally {
                IOUtils.closeQuietly(iter);
            }
        }
        selectionManager.getFeatureSelection().selectItems((Layer)labelLayer, labelFeatures);
        return true;
    }
}

