/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import java.util.Collection;
import javax.swing.JComponent;

public class SelectLabelLayerInLayerTreePlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.label.SelectLabelLayerInLayerTreePlugIn.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(0)).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Layer selectedLayer = WorkbenchContext.getInstance().getLayerNamePanel().getSelectedLayers()[0];
                if (!selectedLayer.getClass().equals(Layer.class)) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-only-layer");
                }
                if (selectedLayer.getLabelLayer() == null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-layer-has-no-label-layer");
                }
                return null;
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer selLy;
        LabelLayer labelLayer;
        LayerNamePanel layerNamePanel = context.getLayerNamePanel();
        Collection<Layer> colLy = layerNamePanel.selectedNodes(Layer.class);
        if (colLy.size() == 1 && (labelLayer = (selLy = colLy.iterator().next()).getLabelLayer()) != null) {
            context.getLayerNamePanel().clearSelection();
            context.getLayerNamePanel().addLayerable2Selection(labelLayer, true);
        }
        return true;
    }
}

