/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.MaxEntriesMap;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.ChooseLabelDefDialog;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.DatastoreCRUDLabelsUtil;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.LabelDef;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.label.LabelDefInfoComparator;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.data.model.TransformationService;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.components.StatusDisplayer;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.thread.Cancelable;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class LabelSelectedFeaturePlugIn
extends AbstractPlugIn {
    public static final String KEY_LABEL_DEFS = LabelSelectedFeaturePlugIn.class.getName() + "_LabelDefs";
    public static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
    private static final TransformationService transformer = new TransformationService();

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.name");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"label_mapobject.svg");
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(76, 128);
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1)).add(checkFactory.createExactlyNLayersMustHaveSelectedItemsCheck(1)).add(component -> {
            Layer selectedLayer = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems().iterator().next();
            if (!selectedLayer.getClass().equals(Layer.class)) {
                return I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.enablecheck-only-layer");
            }
            if (selectedLayer.getLabelLayer() == null) {
                return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-layer-has-no-label-layer");
            }
            if (!selectedLayer.getLabelLayer().isEditable()) {
                return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-layer-not-editable");
            }
            return null;
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                Collection<Layer> layersWithSelectedItems = context.getWorkbenchContext().getSelectionManager().getLayersWithSelectedItems();
                if (layersWithSelectedItems.isEmpty()) {
                    return;
                }
                Layer parentLayer = layersWithSelectedItems.iterator().next();
                LabelLayer labelLayer = parentLayer.getLabelLayer();
                Collection<SimpleFeature> selectedFeatures = context.getWorkbenchContext().getSelectionManager().getFeaturesWithSelectedItems();
                LabelSelectedFeaturePlugIn.createLabels(parentLayer, selectedFeatures, labelLayer, context, (Cancelable)dlgWait);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            context.getErrorHandler().handleThrowable(dlgWait.getError());
        }
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public static Object getParentFeatureFID(SimpleFeature parentFeature, String parentFidCol) {
        if (parentFidCol == null) {
            return FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)parentFeature);
        }
        return parentFeature.getAttribute(parentFidCol);
    }

    public static String determineParentFidCol(FeaturestoreMetadata parentFMD, boolean useUpperCase) {
        String parentFidCol;
        String string = parentFidCol = parentFMD.getEditInOtherDatatype() ? parentFMD.getKeyAttEdit() : parentFMD.getKeyAtt();
        if (StringUtils.isWhitespace((CharSequence)parentFidCol)) {
            throw new IllegalArgumentException(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"riwa_label_def") + " Primary Key: '" + parentFidCol + "'");
        }
        return parentFidCol;
    }

    public static List<LabelDefInfo> queryLabelDefs(String parentTypeName, DataStore dataStore, Collection<SimpleFeature> selectedFeatures, Layer parentLayer, boolean useUpperCase) throws SystemException, IOException {
        And labelDefFilter = ff.and((Filter)ff.like((Expression)ff.property(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"feature_table")), parentTypeName), (Filter)ff.equals((Expression)ff.property(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"active")), (Expression)ff.literal(1)));
        List<LabelDefInfo> labelInfos4Datastore = parentLayer.getLayerManager().getTask().cacheLabelDefs(parentLayer.getFMD().getDatastoreName(), dataStore, useUpperCase);
        List<Object> labelInfos = labelInfos4Datastore.stream().filter(labelInfo -> labelInfo.getFeature_table().equalsIgnoreCase(parentTypeName) && labelInfo.isActive()).collect(Collectors.toList());
        Collections.sort(labelInfos, new LabelDefInfoComparator());
        int countLabelDefs = labelInfos.size();
        if (countLabelDefs == 0) {
            throw new SystemException(I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-no-riwa-label-def"));
        }
        if (countLabelDefs > 1) {
            ArrayList<String> predefinedLabelDefs;
            Blackboard bb = PersistentBlackboardPlugIn.get();
            MaxEntriesMap<String, ArrayList<String>> mapLabelDefs = (MaxEntriesMap<String, ArrayList<String>>)bb.get(KEY_LABEL_DEFS);
            if (mapLabelDefs == null) {
                mapLabelDefs = new MaxEntriesMap<String, ArrayList<String>>(50);
                bb.put(KEY_LABEL_DEFS, mapLabelDefs);
            }
            if ((predefinedLabelDefs = (ArrayList<String>)mapLabelDefs.get(parentLayer.getLabelLayer().getKey())) == null) {
                predefinedLabelDefs = new ArrayList<String>();
            }
            Query query = new Query(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"riwa_label_def"), (Filter)labelDefFilter, new String[]{FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"label_name"), FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"example")});
            SortBy sortBy = ff.sort(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"label_order"), SortOrder.ASCENDING);
            query.setSortBy(new SortBy[]{sortBy});
            ChooseLabelDefDialog dlg = new ChooseLabelDefDialog();
            dlg.setLabelDefs(labelInfos);
            dlg.selectPredefinedLabelDefs(predefinedLabelDefs);
            StringBuilder sbMessage = new StringBuilder(selectedFeatures.size() + " ");
            sbMessage.append(parentLayer.getName());
            sbMessage.append(" ").append(I18N.get("ui.WorkbenchFrame.selected"));
            dlg.setMessage(sbMessage.toString());
            GUIUtil.centreOnScreen(dlg);
            dlg.pack();
            dlg.setVisible(true);
            List<LabelDef> choosenLabelDefs = dlg.getResult();
            if (choosenLabelDefs == null || choosenLabelDefs.isEmpty()) {
                return Collections.emptyList();
            }
            HashSet<Integer> choosenLabelDefIDs = new HashSet<Integer>();
            predefinedLabelDefs.clear();
            for (LabelDef choosenLabelDef : choosenLabelDefs) {
                String choosenLabelDefID = choosenLabelDef.getID();
                predefinedLabelDefs.add(choosenLabelDefID);
                choosenLabelDefIDs.add(Integer.parseInt(choosenLabelDefID));
            }
            mapLabelDefs.put(parentLayer.getLabelLayer().getKey(), predefinedLabelDefs);
            labelInfos = labelInfos.stream().filter(labelInfo -> choosenLabelDefIDs.contains(labelInfo.getFid())).collect(Collectors.toList());
        }
        return labelInfos;
    }

    public static void createLabels(Layer parentLayer, Collection<SimpleFeature> selectedFeatures, LabelLayer labelLayer, PlugInContext context, Cancelable cancelable) throws Exception {
        FeaturestoreMetadata parentFMD = parentLayer.getFMD();
        DMDCollection dataStores = context.getTask().getDataStores();
        DataStore dataStore = parentFMD.getDataStore(dataStores);
        FeaturestoreMetadata labelFMD = labelLayer.getFMD();
        String parentTypeName = parentFMD.getEditInOtherDatatype() ? parentFMD.getDatatypeNameEdit() : parentFMD.getDatatypeName();
        SimpleFeatureType labelSchema = labelFMD.getEditInOtherDatatype() ? labelFMD.getSchemaEdit(dataStores) : labelFMD.getQuerySchema(dataStores);
        boolean useUpperCase = FeatureTypeUtil.isSchemaNameInUpperCase((String)parentTypeName);
        List<LabelDefInfo> labelDefs = LabelSelectedFeaturePlugIn.queryLabelDefs(parentTypeName, dataStore, selectedFeatures, parentLayer, useUpperCase);
        if (labelDefs == null || labelDefs.isEmpty()) {
            cancelable.cancel();
            return;
        }
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        DatastoreCRUDLabelsUtil lblUtil = new DatastoreCRUDLabelsUtil(labelLayer.getLayerManager().getTask(), dataStore, parentFMD.getDatastoreName(), useUpperCase);
        lblUtil.setLabelSchema(labelLayer.getFeatureType());
        for (LabelDefInfo labelDef : labelDefs) {
            if (cancelable.isCanceled()) {
                return;
            }
            String labelTableFromDef = labelDef.getLabel_table();
            if (!labelSchema.getTypeName().equalsIgnoreCase(labelTableFromDef)) {
                throw new SystemException(String.format("Error in definition of layer '%s'. Name of label layers feature type '%s' does not match with RIWA_LABEL_DEF.LABEL_TABLE '%s'", labelLayer.getName(), labelSchema.getTypeName(), labelTableFromDef));
            }
            int count = 0;
            for (SimpleFeature selectedFeature : selectedFeatures) {
                ++count;
                if (cancelable.isCanceled()) {
                    return;
                }
                LabelSelectedFeaturePlugIn.updateStatusDisplay(selectedFeatures, cancelable, labelDef, count);
                SimpleFeature parentFeature = LabelSelectedFeaturePlugIn.determineParentFeatureWithAllAttributes(parentFMD, selectedFeature, dataStore, parentTypeName);
                SimpleFeature lblFeature = lblUtil.createLabel(labelDef, parentFeature);
                if (lblFeature == null) continue;
                LabelSelectedFeaturePlugIn.transformIfNecessary(parentFMD, dataStores, lblFeature);
                features.add(lblFeature);
            }
        }
        if (cancelable.isCanceled() || features.isEmpty()) {
            return;
        }
        labelLayer.editFeature(features, 1);
        labelLayer.commitEditedFeatures(true, false, false);
    }

    private static void transformIfNecessary(FeaturestoreMetadata parentFMD, DMDCollection dataStores, SimpleFeature feature) throws Exception {
        if (transformer.hasTransformation(parentFMD, dataStores)) {
            transformer.getTransformer(parentFMD, dataStores).transform2d(feature);
        }
    }

    private static void updateStatusDisplay(Collection<SimpleFeature> selectedFeatures, Cancelable cancelable, LabelDefInfo labelDef, int count) {
        if (cancelable instanceof StatusDisplayer) {
            ((StatusDisplayer)cancelable).setMessage(String.format("%s%n%s %s %d/%d", I18N.get("common.wait"), I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.create-label"), labelDef.getLabel_name(), count, selectedFeatures.size()));
        }
    }

    public static SimpleFeature determineParentFeatureWithAllAttributes(FeaturestoreMetadata parentFMD, SimpleFeature selectedFeature, DataStore dataStore, String parentTypeName) throws IOException {
        SimpleFeature parentFeature = null;
        String keyAtt = parentFMD.getKeyAtt();
        Object viewID = keyAtt == null ? FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)selectedFeature) : selectedFeature.getAttribute(keyAtt);
        Filter parentFilter = null;
        if (parentFMD.getEditInOtherDatatype()) {
            String keyAttEdit = parentFMD.getKeyAttEdit();
            parentFilter = FilterUtil.buildFeatureIdFilter((String)keyAttEdit, (Object)viewID);
            SimpleFeatureSource fsParent = dataStore.getFeatureSource(parentFMD.getDatatypeNameEdit());
            SimpleFeatureCollection fCol = fsParent.getFeatures(parentFilter);
            parentFeature = (SimpleFeature)DataUtilities.first((FeatureCollection)fCol);
        } else {
            parentFilter = FilterUtil.buildFeatureIdFilter((String)keyAtt, (Object)viewID);
            SimpleFeatureSource fsParent = dataStore.getFeatureSource(parentFMD.getDatatypeName());
            SimpleFeatureCollection fCol = fsParent.getFeatures(parentFilter);
            parentFeature = (SimpleFeature)DataUtilities.first((FeatureCollection)fCol);
        }
        if (parentFeature == null) {
            throw new IllegalArgumentException(I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.error-no-feature-found") + ": " + parentTypeName + " - " + String.valueOf(parentFilter));
        }
        return parentFeature;
    }
}

