/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.LabelSelectedFeaturePlugIn;
import de.riwagis.label.AbstractCRUDLabelsUtil;
import de.riwagis.label.LabelDefInfo;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class DatastoreCRUDLabelsUtil
extends AbstractCRUDLabelsUtil {
    private final DataStore datastore;
    private final String datastoreName;
    private final Task task;
    private final boolean useUpperCase;
    private SimpleFeatureType labelSchema;

    public DatastoreCRUDLabelsUtil(Task task, DataStore datastore, String datastoreName, boolean useUpperCase) {
        this.task = task;
        this.datastore = datastore;
        this.datastoreName = datastoreName;
        this.useUpperCase = useUpperCase;
    }

    protected LabelDefInfo retrieveLabelInfoForID(int labelID) throws IOException {
        List<LabelDefInfo> labelInfos4Datastore = this.task.cacheLabelDefs(this.datastoreName, this.datastore, this.useUpperCase);
        List labelInfos4Id = labelInfos4Datastore.stream().filter(labelInfo -> labelInfo.getFid() == labelID).collect(Collectors.toList());
        if (labelInfos4Id.size() > 1) {
            throw new IllegalArgumentException("Should never reach here. Only one label definition per ID should be returned.");
        }
        if (labelInfos4Id.isEmpty()) {
            return null;
        }
        return (LabelDefInfo)labelInfos4Id.get(0);
    }

    protected SimpleFeature retrieveLinkedFeature(String typeName, String properties, String fkAttribute, String fid4Filter) throws Exception {
        Query labelTableQuery = new Query(typeName);
        if (StringUtils.isNotEmpty((CharSequence)properties)) {
            properties = StringUtils.remove((String)properties, (String)" ");
            labelTableQuery.setPropertyNames(properties.split(","));
        }
        PropertyIsEqualTo labelTextTableFilter = LabelSelectedFeaturePlugIn.ff.equals((Expression)LabelSelectedFeaturePlugIn.ff.property(fkAttribute), (Expression)LabelSelectedFeaturePlugIn.ff.literal((Object)fid4Filter));
        labelTableQuery.setFilter((Filter)labelTextTableFilter);
        return (SimpleFeature)DataUtilities.first((FeatureCollection)this.datastore.getFeatureSource(typeName).getFeatures(labelTableQuery));
    }

    protected SimpleFeatureType retrieveLabelSchema(String labelTypeName) throws Exception {
        if (this.labelSchema == null) {
            return (SimpleFeatureType)this.datastore.getFeatureSource(labelTypeName).getSchema();
        }
        return this.labelSchema;
    }

    public void setLabelSchema(SimpleFeatureType labelSchema) {
        this.labelSchema = labelSchema;
    }
}

