/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.LabelDef;
import de.riwagis.label.LabelDefInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;

public class ChooseLabelDefDialog
extends JDialog {
    private OKCancelPanel okCancelPanel = new OKCancelPanel();
    private JLabel lblExamble = new JLabel();
    private JList<LabelDef> liLabelDefs = new JList(new DefaultListModel());
    private List<LabelDef> result = null;
    private final JLabel lblMessage = new JLabel();

    public ChooseLabelDefDialog() {
        super(WorkbenchContext.getFrame(), I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.name"), true);
        this.okCancelPanel.setOKEnabled(false);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.lblExamble.setBackground(Color.WHITE);
        this.liLabelDefs.setSelectionMode(2);
        this.liLabelDefs.setVisibleRowCount(5);
        this.liLabelDefs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JList liLabelDefs = (JList)evt.getSource();
                LabelDef labelDef = (LabelDef)liLabelDefs.getSelectedValue();
                if (labelDef == null) {
                    ChooseLabelDefDialog.this.okCancelPanel.setOKEnabled(false);
                    ChooseLabelDefDialog.this.lblExamble.setText("");
                } else {
                    ChooseLabelDefDialog.this.okCancelPanel.setOKEnabled(true);
                    ChooseLabelDefDialog.this.lblExamble.setText(Objects.toString(labelDef.getExample(), ""));
                }
            }
        });
        JPanel centerPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        centerPanel.setLayout(gbl);
        GUIUtil.addGridBagComponent(centerPanel, this.lblMessage, gbl, 0, 0, 3, 1, 10, 1, new Insets(12, 5, 5, 5));
        GUIUtil.addGridBagComponent(centerPanel, new JLabel(I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.choose-label-def")), gbl, 0, 1, 3, 1, 10, 1, new Insets(5, 5, 5, 5));
        GUIUtil.addGridBagComponent(centerPanel, new JScrollPane(this.liLabelDefs), gbl, 0, 2, 3, 1, 12, 1, new Insets(5, 5, 5, 5));
        GUIUtil.addGridBagComponent(centerPanel, new JLabel(I18N.get("ui.plugin.layer.label.LabelSelectedFeaturePlugIn.example")), gbl, 0, 3, 1, 1, 12, 0, new Insets(12, 5, 15, 5));
        GUIUtil.addGridBagComponent(centerPanel, this.lblExamble, gbl, 1, 3, 2, 3, 12, 1, new Insets(12, 5, 15, 5));
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.okCancelPanel, "South");
        this.pack();
        this.setResizable(false);
        this.okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ChooseLabelDefDialog.this.okCancelPanel.wasOKPressed()) {
                    ChooseLabelDefDialog.this.result = Collections.unmodifiableList(ChooseLabelDefDialog.this.liLabelDefs.getSelectedValuesList());
                }
                ChooseLabelDefDialog.this.dispose();
            }
        });
    }

    public void selectPredefinedLabelDefs(final Collection<String> predefinedLabelDefs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String predefinedLabelDef : predefinedLabelDefs) {
                    for (int i = 0; i < ChooseLabelDefDialog.this.liLabelDefs.getModel().getSize(); ++i) {
                        LabelDef labelDef = ChooseLabelDefDialog.this.liLabelDefs.getModel().getElementAt(i);
                        if (!StringUtils.equals((CharSequence)predefinedLabelDef, (CharSequence)labelDef.getID())) continue;
                        ChooseLabelDefDialog.this.liLabelDefs.getSelectionModel().addSelectionInterval(i, i);
                    }
                }
            }
        });
    }

    public void setLabelDefs(final List<LabelDefInfo> labelDefs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel liModel = (DefaultListModel)ChooseLabelDefDialog.this.liLabelDefs.getModel();
                for (LabelDefInfo labelDefInfo : labelDefs) {
                    String id = "" + labelDefInfo.getFid();
                    String name = labelDefInfo.getLabel_name();
                    String example = labelDefInfo.getExample();
                    LabelDef labelDef = new LabelDef(id, name, example);
                    liModel.addElement(labelDef);
                }
            }
        });
    }

    public List<LabelDef> getResult() {
        return this.result;
    }

    public void setMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChooseLabelDefDialog.this.lblMessage.setText(Objects.toString(message, ""));
                ChooseLabelDefDialog.this.pack();
            }
        });
    }
}

