/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.AddLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.label.LabelTaskIOListener;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import com.vividsolutions.jump.workbench.ui.style.VectorLayerStylePanel;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.label.LabelFeatureAtts;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.data.DataStore;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeatureType;

public class AddLabelLayerPlugIn
extends AddLayerPlugIn {
    private static final LabelTaskIOListener labelTaskIOListener = new LabelTaskIOListener();

    public AddLabelLayerPlugIn() {
        AbstractTaskPlugIn.addTaskIOListener(labelTaskIOListener);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.name");
    }

    @Override
    protected AbstractLayerable generateLayerable(PlugInContext context) throws Exception {
        LayerManager layMngr = context.getLayerManager();
        return this.createDefaultLayer(layMngr, context.getSelectedLayer(0));
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLocalLayersMustBeSelectedCheck(1)).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(0)).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Layer selectedLayer = WorkbenchContext.getInstance().getLayerNamePanel().getSelectedLayers()[0];
                if (!selectedLayer.getClass().equals(Layer.class)) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-only-layer");
                }
                if (selectedLayer.getLabelLayer() != null) {
                    return I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.enablecheck-layer-has-label-layer");
                }
                return null;
            }
        });
    }

    @Override
    protected StylePanel generateStylePanel(PlugInContext context, AbstractLayerable layer) throws Exception {
        VectorLayerStylePanel vlStylePanel = (VectorLayerStylePanel)super.generateStylePanel(context, layer);
        return vlStylePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer createDefaultLayer(LayerManager layMngr, Layer parentLayer) throws IOException {
        LabelLayer layer = null;
        boolean tmpFiringEvents = layMngr.isFiringEvents();
        try {
            String[] arrError;
            layMngr.setFiringEvents(false);
            String strName = parentLayer.getName() + " " + I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.layer-title");
            Object strKey = parentLayer.getKey() + "_" + I18N.get("ui.plugin.layer.label.AddLabelLayerPlugIn.layer-title");
            strKey = ((String)strKey).toLowerCase();
            FeaturestoreMetadata parentFMD = parentLayer.getFMD();
            FeaturestoreMetadata fmd = new FeaturestoreMetadata();
            fmd.setDatastoreName(parentFMD.getDatastoreName());
            boolean useUpperCase = FeatureTypeUtil.isSchemaNameInUpperCase((String)parentFMD.getDatatypeName());
            String datatypeName = null;
            datatypeName = parentFMD.getEditInOtherDatatype() ? parentFMD.getDatatypeNameEdit() + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"_tbl") : parentFMD.getDatatypeName() + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"_tbl");
            fmd.setDatatypeName(datatypeName);
            fmd.setCRSFrom(parentFMD.getCRSFrom());
            fmd.setCRSTo(parentFMD.getCRSTo());
            fmd.setDeleteAllowed(true);
            fmd.setInsertAllowed(true);
            DataStore dataStore = parentLayer.getFMD().getDataStore(layMngr.getTask().getDataStores());
            SimpleFeatureType schema = null;
            if (!ArrayUtils.contains((Object[])dataStore.getTypeNames(), (Object)datatypeName) || (arrError = LabelFeatureAtts.checkStructure((SimpleFeatureType)(schema = dataStore.getSchema(datatypeName)))) != null) {
                // empty if block
            }
            layer = new LabelLayer(strName, fmd, layMngr, parentLayer);
            layer.setKey((String)strKey);
            layer.setCacheAll(parentLayer.getCacheAll());
            layer.setCacheEnvSize(parentLayer.getCacheEnvSize());
            layer.setCacheMinEnv(parentLayer.getCacheMinEnv());
            layer.setEditable(parentLayer.isEditable());
            layer.setRenderPrio(parentLayer.getRenderPrio() + 10);
            boolean hasAlignmentAttribute = schema == null ? true : FeatureTypeUtil.hasSchemaAttribute((SimpleFeatureType)schema, (String)LabelFeatureAtts.ALIGNMENT.getName());
            fmd.setKeyAttView(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.FID_PARENT.getName()));
            fmd.setGeomTypes(new Class[]{Point.class});
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.FID_PARENT.getName()));
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.GEOM.getName()));
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.LABEL_TEXT.getName()));
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.LABEL_DEF_ID.getName()));
            if (hasAlignmentAttribute) {
                attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.ALIGNMENT.getName()));
            } else {
                attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.HORIZONTAL_ALIGNMENT.getName()));
                attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()));
            }
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.PRE.getName()));
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.SUF.getName()));
            attributes.add(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.ORIENTATION.getName()));
            fmd.setAttributes(attributes.toArray(new String[attributes.size()]));
            fmd.setEditInOtherDatatype(false);
            fmd.setDeleteAllowed(true);
            fmd.setInsertAllowed(true);
            fmd.setRestrictGeomType(true);
            fmd.setUseText(true);
            fmd.setTextAtt(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.LABEL_TEXT.getName()));
            fmd.setTextOriAtt(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.ORIENTATION.getName()));
            LayerStyleCollection styleCollection = new LayerStyleCollection(layer, true);
            BasicStyleModel basStyle = new BasicStyleModel();
            basStyle.setRenderingFill(false);
            basStyle.setRenderingFillPattern(false);
            basStyle.setLineBase(null);
            basStyle.setLineBackground(null);
            basStyle.setLineForeground(null);
            basStyle.setRenderingSymbol(false);
            basStyle.setRenderingText(true);
            basStyle.setBolUseAlphaLine(false);
            basStyle.setBolUseAlphaArea(false);
            TextStyleModel textStyle = new TextStyleModel();
            textStyle.setEnabled(true);
            textStyle.setStrText("str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.PRE.getName()) + "\") + str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.LABEL_TEXT.getName()) + "\") + str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.SUF.getName()) + "\")");
            textStyle.setStrOrient("num(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.ORIENTATION.getName()) + "\")");
            textStyle.setBolShowPoint(true);
            textStyle.setBolShowLine(false);
            textStyle.setBolShowArea(false);
            textStyle.setIntUnitOrient(0);
            textStyle.setIntUnitLength(1);
            if (hasAlignmentAttribute) {
                textStyle.setAlignPoint("num(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.ALIGNMENT.getName()) + "\")");
            } else {
                textStyle.setAlignPoint("( str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.HORIZONTAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Left\") ? 1 : str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.HORIZONTAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Center\") ? 2 : str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.HORIZONTAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Right\") ? 3 : 1 ) + ( str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Bottom\") || str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Baseline\") ? 6 : str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Halfline\") ? 3 : str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Capline\") || str(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()) + "\").equalsIgnoreCase(\"Top\") ? 0 : 6 )");
            }
            basStyle.setTextStyle(textStyle);
            BasicStyleModel basStyleDefault = basStyle.clone();
            basStyleDefault.setEnabled(false);
            styleCollection.addStyle((StyleModel)basStyleDefault);
            ColorThemingStyleModel colorThemingStyle = new ColorThemingStyleModel("num(\"" + FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)LabelFeatureAtts.LABEL_DEF_ID.getName()) + "\",0)", new TreeMap(), basStyle.clone());
            styleCollection.addStyle((StyleModel)colorThemingStyle);
            layer.addStyleCollection(styleCollection);
        }
        catch (CloneNotSupportedException ex) {
            Assert.shouldNeverReachHere((String)("error at clone style for label layer: " + ex.getMessage()));
        }
        finally {
            layMngr.setFiringEvents(tmpFiringEvents);
        }
        return layer;
    }

    @Override
    protected void addDialogListener(final PlugInContext context, final List<LayerStylePanel> layerPanels, final MultiInputDialog dialog, final AbstractLayerable layer) {
        dialog.addOkApplyCancelListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.wasApplyPressed() || dialog.wasOKPressed()) {
                    Iterator i;
                    ArrayList<UndoableCommand> lstUndo = new ArrayList<UndoableCommand>();
                    Iterator i2 = layerPanels.iterator();
                    while (i2.hasNext()) {
                        lstUndo.add(((LayerStylePanel)i2.next()).updateLayer());
                    }
                    boolean isFiringEvents = layer.getLayerManager().isFiringEvents();
                    layer.getLayerManager().setFiringEvents(false);
                    try {
                        i = lstUndo.iterator();
                        while (i.hasNext()) {
                            ((UndoableCommand)i.next()).execute();
                        }
                    }
                    finally {
                        layer.getLayerManager().setFiringEvents(isFiringEvents);
                    }
                    AbstractPlugIn.execute(new UndoableCommand(I18N.get("ui.plugin.AbstractChangeStylePlugIn.add-layerable")){
                        private final LayerManager layMngr;
                        private final Layer parentLayer;
                        {
                            this.layMngr = layer.getLayerManager();
                            this.parentLayer = context.getSelectedLayer(0);
                        }

                        @Override
                        public void execute() {
                            boolean isFiringEvents = this.layMngr.isFiringEvents();
                            this.layMngr.setFiringEvents(false);
                            try {
                                String catName = this.parentLayer.getCategory().getName();
                                this.layMngr.addLayerable(catName, (Layerable)layer);
                                this.parentLayer.setLabelLayer((LabelLayer)layer);
                            }
                            catch (Exception e) {
                                Assert.shouldNeverReachHere((String)e.getMessage());
                            }
                            finally {
                                this.layMngr.setFiringEvents(isFiringEvents);
                                if (layer instanceof Layer) {
                                    ((Layer)layer).clearFeatureCache();
                                }
                                this.layMngr.fireLayerChanged(layer, LayerEventType.ADDED);
                                layer.fireAppearanceChanged();
                            }
                        }

                        @Override
                        public void unexecute() {
                            try {
                                this.parentLayer.setLabelLayer(null);
                                this.layMngr.remove(layer);
                            }
                            catch (Exception e) {
                                Assert.shouldNeverReachHere((String)e.getMessage());
                            }
                        }
                    }, (LayerManagerProxy)context);
                    i = layerPanels.iterator();
                    while (i.hasNext()) {
                        ((LayerStylePanel)i.next()).setLayerable(layer);
                    }
                }
            }
        });
    }
}

